/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _zotonic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _zotonic__WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _zotonic__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _controllers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _controllers__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_controllers__WEBPACK_IMPORTED_MODULE_1__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _controllers__WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _controllers__WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _data__WEBPACK_IMPORTED_MODULE_2__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _data__WEBPACK_IMPORTED_MODULE_2__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _seed__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8);
/* harmony import */ var _seed__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_seed__WEBPACK_IMPORTED_MODULE_3__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _seed__WEBPACK_IMPORTED_MODULE_3__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _seed__WEBPACK_IMPORTED_MODULE_3__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11);
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_ui__WEBPACK_IMPORTED_MODULE_4__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _ui__WEBPACK_IMPORTED_MODULE_4__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _ui__WEBPACK_IMPORTED_MODULE_4__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _app_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12);
/* harmony import */ var _app_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_app_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _app_js__WEBPACK_IMPORTED_MODULE_5__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _app_js__WEBPACK_IMPORTED_MODULE_5__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _scss_ionic_app_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13);
/* harmony import */ var _scss_ionic_app_scss__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_scss_ionic_app_scss__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _scss_rtl_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(17);
/* harmony import */ var _scss_rtl_scss__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_scss_rtl_scss__WEBPACK_IMPORTED_MODULE_7__);











/***/ }),
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _zotonic_rsc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _zotonic_rsc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_zotonic_rsc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _zotonic_rsc__WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _zotonic_rsc__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _zotonic_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var _zotonic_util__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_zotonic_util__WEBPACK_IMPORTED_MODULE_1__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _zotonic_util__WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _zotonic_util__WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _zotonic_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
/* harmony import */ var _zotonic_ui__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_zotonic_ui__WEBPACK_IMPORTED_MODULE_2__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _zotonic_ui__WEBPACK_IMPORTED_MODULE_2__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _zotonic_ui__WEBPACK_IMPORTED_MODULE_2__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _zotonic_survey__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5);
/* harmony import */ var _zotonic_survey__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_zotonic_survey__WEBPACK_IMPORTED_MODULE_3__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _zotonic_survey__WEBPACK_IMPORTED_MODULE_3__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _zotonic_survey__WEBPACK_IMPORTED_MODULE_3__[key]; }) }(__WEBPACK_IMPORT_KEY__));






/***/ }),
/* 2 */
/***/ (function(module, exports) {

angular
  .module('zotonic.rsc', [])

  .factory('apiRequest', function($q, $http, zConfig) {
    return function(path, params, urlProvider) {
      params = params || {};
      urlProvider = urlProvider || zConfig;
      params.callback = 'JSON_CALLBACK';
      var url = urlProvider.url(path, params);
      //console.log('GET ' + url);
      var d = $q.defer();

      function error(e) {
        console.log('*** ERROR! ' + JSON.stringify(e))
        console.log(e)
        d.resolve(null);
      }
      console.log('url', url)

      $http.jsonp(url).error(error).then(function(r) { return d.resolve(r.data); });
      return d.promise;
    };
  })

  .factory('apiRequestCached', function($q, apiRequest, zConfig) {
    return function(path, params, urlProvider) {
      urlProvider = urlProvider || zConfig;

      var d = $q.defer();

      var key = urlProvider.cachePrefix() + ':' + path + '?' + $.param(params || {});
      var resolved;

      if (key in window.localStorage) {
        var value = JSON.parse(window.localStorage[key]);
        d.resolve(value);
        resolved = true;
        return d.promise;
      }

      apiRequest(path, params, urlProvider).then(function(data) {
        window.localStorage[key] = JSON.stringify(data);
        if (!resolved) {
          d.resolve(data);
        }
      });

      return d.promise;
    };
  })

  .factory('ResourceModelFactory', function($q, $http, apiRequestCached) {
    return function (urlProvider) {
      function get(id) {
        return apiRequestCached('base/export', {id: id}, urlProvider);
      }
      function post(path, params, body) {
        params = params || {};
        var url = urlProvider.url(path, params);
        //url = 'http://smugglers.miraclethings.nl/api/survey/submit?id=316';
        //console.log('POST ' + url);
        return $http.post(url, body);
      }

      return {
        get: get,
        post: post,

        getMany: function(ids) {
          var ret = {};
          var qs = _(ids).map(function(id) {
            return get(id).then(function(r) {
              ret[id] = r;
            });
          }).valueOf();
          return $q.all(qs).then(function() {
            return ret;
          });
        },

        invalidate: function(ids) {
          _.each(ids, function(id) {
            var k = urlProvider.cachePrefix() + ':base/export?' + $.param({id: id});
            delete window.localStorage[k];
          });
        }

      };
    };
  })

  .factory('ResourceController', function($ionicLoading, $ionicPopup, $ionicHistory) {

    function rscError() {
      $ionicPopup.show({
        title: 'Error',
        subTitle: 'The page failed to load.',
        buttons: [
          { text: 'Back' },
        ]
      }).then(function() {
        $ionicHistory.goBack();
      });
    }

    return {
      bind: function(scope, id, resourceModel) {

        function load() {
          $ionicLoading.show();
          resourceModel.get(id).then(function(rsc) {
            $ionicLoading.hide();
            scope.$broadcast('scroll.refreshComplete');
            if (rsc === null) {
              rscError();
              return;
            }
            scope.rsc = rsc;
          });
        }

        scope.doRefresh = function() {
          resourceModel.invalidate([id]);
          load();
        };

        load();
      }
    };
  })
;


/***/ }),
/* 3 */
/***/ (function(module, exports) {

angular
  .module('zotonic.util', [])

  .factory('zUtil', function($state, $ionicViewService) {

    return {

      openExternal: function(link) {
        if (ionic.Platform.isAndroid()) {

          // check whether we have the Facebook app installed
          if (link.indexOf("facebook.com") >= 0) {
            window.appAvailability.check(
              'com.facebook.katana',
              function() {
                window.open("fb://facewebmodal/f?href=" + link, '_system');
              },
              function() {
                window.open(link, '_system');
              }
            );
          } else {
            window.open(link, '_system');
          }

        } else {
          window.open(link, '_blank', 'location=yes');
        }
      }
    };
  })

  .factory('zConfig', function($rootScope, $timeout) {
    var config = {
      BASE_URL: '',
      LANG: 'en',

      // URL provider
      url: function(path, params) {
        return config.BASE_URL + 'api/' + path + '?' + $.param(params);
      },
      cachePrefix: function() {
        return config.BASE_URL;
      }

    };
    $timeout(function() {
      $rootScope.$broadcast('zotonic.config', config);
    }, 0);

    return config;
  })

  .factory('zUrlProvider', function() {
    return function(baseurl) {
      return {
        url: function(path, params) {
          return baseurl + 'api/' + path + '?' + $.param(params);
        },
        cachePrefix: function() {
          return baseurl;
        },
        base: baseurl
      };
    };
  })

  .factory('zTrans', function(zConfig) {
    return function(tr) {
      if (typeof tr == 'object' && tr !== null && typeof tr.trans == 'object') {
        return tr.trans[zConfig.LANG] || tr.trans.en;
      } else {
        return tr||'';
      }
    };
  })

  .filter('trans', function(zTrans) {
    return function(tr) {
      return zTrans(tr);
    };
  })

  .filter('zNavTitle', function(zTrans) {
    return function(rsc) {
      if (!rsc) return '';
      var t = zTrans(rsc.short_title) ? rsc.short_title : rsc.title;
      return zTrans(t);
    };
  })

  .value('zTranslate', (function(){
    function get() {

    }
    return {
      get: get
    };
  })())

  .filter('rscUrl', function(zConfig) {
    return function(id) {
      return zConfig.BASE_URL + 'page/' + id;
    };
  })

  .filter('trunc', function(zTrans) {
    return function(str, size) {
      if (!size) { size = 200; }
      str = zTrans(str);
      str = str.substr(0, size);
      str = str.replace(/[ ]([^ ]*)$/, "...");
      return str;
    };
  })
;

/**
 * Checklist-model
 * AngularJS directive for list of checkboxes
 */


angular.module('checklist-model', [])
       .directive('checklistModel', ['$parse', '$compile', function($parse, $compile) {
         // contains
         function contains(arr, item) {
           if (angular.isArray(arr)) {
             for (var i = 0; i < arr.length; i++) {
               if (angular.equals(arr[i], item)) {
                 return true;
               }
             }
           }
           return false;
         }

         // add
         function add(arr, item) {
           arr = angular.isArray(arr) ? arr : [];
           for (var i = 0; i < arr.length; i++) {
             if (angular.equals(arr[i], item)) {
               return arr;
             }
           }
           arr.push(item);
           return arr;
         }

         // remove
         function remove(arr, item) {
           if (angular.isArray(arr)) {
             for (var i = 0; i < arr.length; i++) {
               if (angular.equals(arr[i], item)) {
                 arr.splice(i, 1);
                 break;
               }
             }
           }
           return arr;
         }

         // http://stackoverflow.com/a/19228302/1458162
         function postLinkFn(scope, elem, attrs) {
           // compile with `ng-model` pointing to `checked`
           $compile(elem)(scope);

           // getter / setter for original model
           var getter = $parse(attrs.checklistModel);
           var setter = getter.assign;

           // value added to list
           var value = $parse(attrs.checklistValue)(scope.$parent);

           // watch UI checked change
           scope.$watch('checked', function(newValue, oldValue) {
             if (newValue === oldValue) {
               return;
             }
             var current = getter(scope.$parent);
             if (newValue === true) {
               setter(scope.$parent, add(current, value));
             } else {
               setter(scope.$parent, remove(current, value));
             }
           });

           // watch original model change
           scope.$parent.$watch(attrs.checklistModel, function(newArr, oldArr) {
             scope.checked = contains(newArr, value);
           }, true);
         }

         return {
           restrict: 'A',
           priority: 1000,
           terminal: true,
           scope: true,
           compile: function(tElement, tAttrs) {
             if (tElement[0].tagName !== 'INPUT' || !tElement.attr('type', 'checkbox')) {
               throw 'checklist-model should be applied to `input[type="checkbox"]`.';
             }

             if (!tAttrs.checklistValue) {
               throw 'You should provide `checklist-value`.';
             }

             // exclude recursion
             tElement.removeAttr('checklist-model');

             // local scope var storing individual checkbox model
             tElement.attr('ng-model', 'checked');

             return postLinkFn;
           }
         };
       }])
//

       .factory('zRscBlockFactory', function() {
         return function(template, linkfn) {
           return {
             restrict: 'E',
             templateUrl: 'templates/rsc/block_' + template + '.html',
             scope: {
               rsc: '=',
               block: '=',
             },
             link: linkfn
           };
         };
       })

;


/***/ }),
/* 4 */
/***/ (function(module, exports) {

angular
  .module('zotonic.ui', ['zotonic.util', 'zotonic.rsc'])

  .directive('zAppLink', function(zConfig, $state, zUtil) {

    function normalizeLink(href) {
      if (!href.match(/^(mailto|https?):/)) {
        if (href.match(/^\//)) {
          // abs URL
          href = zConfig.BASE_URL + href.substr(1);
        } else {
          href = zConfig.BASE_URL + href;
        }
      }
      return href;
    }

    return {
      restrict: 'A',
      link: function(scope, elem, attr) {

        var pageId;

        var href = normalizeLink(attr.href);
        if (href.match(/^\/[^\/]/)) {
          href = zConfig.BASE_URL + href.substr(1);
        }
        if (href.substr(0, zConfig.BASE_URL.length) == zConfig.BASE_URL) {
          // internal link; extract page id
          var m = href.match(/^.*?(page|id)\/(\d+)/);
          if (m) {
            pageId = m[2];
          }
        }

        var src;
        switch(elem[0].hostname) {
          case 'www.womenonwaves.org':
            src = 'waves'; break;
          default:
            src = 'web'; break;
        }

        // add indication
        if (pageId) {
          elem.addClass("internal-link");
        } else {
          elem.addClass("external-link");
          elem.prepend($('<i class="ion-link"></i>'));
        }

        // Add click handler
        elem.on('click', function(e) {
          e.preventDefault();
          if (pageId) {
            $state.go('app.rsc', {src: src, rscId: pageId});
          } else {
            zUtil.openExternal(href);
          }
          return false;
        });
      }
    };
  })

  .directive('zRscBody', function($compile, zTrans) {
    return {
      restrict: 'E',
      scope: {
        rsc: '=',
        showBlocks: '='
      },
      templateUrl: 'templates/rsc/body.html',
      link: function(scope, elem) {

        if (scope.rsc.body) {
          var body = zTrans(scope.rsc.body);
          //var body = scope.rsc.body.trans.tr;
          //console.log(scope.rsc.body.trans.tr);

          body = body.replace(/<a /g, "<a z-app-link ");

          var b = elem.find(".rsc-body");
          b.html(body);
          $compile(b.contents())(scope);
        }

        if (scope.showBlocks && scope.rsc.blocks) {
          scope.rscBlocks = _.filter(scope.rsc.blocks, function(blk) { return blk.name != 'week_days'; });
        }

      }
    };
  })

// shows HTML; replaces <a> tags with app links
  .directive('zBindHtml', function($compile, zTrans) {
    return {
      restrict: 'A',
      scope: {
        zBindHtml: '=',
      },
      link: function(scope, elem) {
        var body = zTrans(scope.zBindHtml);
        body = body.replace(/<a /g, "<a z-app-link ");
        elem.html(body);
        $compile(elem.contents())(scope);
      }
    };
  })

  .directive('zRscList', function(zTrans) {
    return {
      restrict: 'E',
      scope: {
        edges: '=',
        predicate: '=',
        rscModel: '='
      },
      templateUrl: 'templates/rsc/rsc_list.html',
      link: function(scope, elem) {
        if (scope.edges) {
          scope.list = scope.edges;
          if (scope.predicate) {
            scope.list = _.filter(scope.list, function(e) {
              return e.predicate_name == scope.predicate;
            });
          }
          scope.list = _.map(scope.list, function(e) {
            return {title: e.object_title,
                    id: e.object_id};
          });

          scope.rscModel
               .getMany(_.map(scope.list, function(r) { return r.id; }))
               .then(function(byId) {
                 scope.byId = byId;
               });
        }
      }
    };
  })

  .factory('zPlayVideo', function() {
    return function(url) {
      var url = url.replace('/id/', '/media/inline/id/');
      window.VideoPlayback.ensureDownloaded(
        url,
        function() {
          window.VideoPlayback.play(url);
        },
        function() {
          window.VideoPlayback.play(url);
        }
      );
    }
  })

  .directive('zRscMedium', function($compile, zTrans, zUtil, zPlayVideo) {
    return {
      restrict: 'E',
      scope: {
        rsc: '=',
      },
      templateUrl: 'templates/rsc/medium.html',
      link: function(scope, elem) {
        scope.type = scope.rsc.medium.mime.split("/")[0];
        scope.play = function() {
          zPlayVideo(scope.rsc.uri)
        };
      }
    };
  })

;


/***/ }),
/* 5 */
/***/ (function(module, exports) {

angular.module('zotonic.survey', ['zotonic.rsc', 'zotonic.util', 'checklist-model'])

  .factory('SurveyState', function() {
    function k(id) {
      return 'survey-state-' + id;
    }
    function save(id, state) {
      window.localStorage[k(id)] = JSON.stringify(state);
      return state;
    }
    function load(id) {
      if (!(k(id) in window.localStorage)) {
        save(id, {currentPage: 0,
                  answers: {},
                  backStack: [],
                  initial: true});
      }
      return JSON.parse(window.localStorage[k(id)]);
    }

    function reset(id) {
      delete window.localStorage[k(id)];
      return load(id);
    }
    
    return {
      load:  load,
      reset: reset,
      save:  save
    };
  })

  .factory('SurveyModel', function($q, $rootScope) {

    function checkCondition(target, cond, evalScope) {
      if (!target) return false;

      // unescape
      cond = $('<div/>').html(cond).text();

      // replace "foo|bar" --> bar(foo) 'function call' constructs
      cond = cond.replace(/(\w+)\|(\w+)/g, "$2($1)");

      // ' and ' -> &&; or -> ||; not -> !
      cond = cond.replace(/\band\b/ig, ' && ');
      cond = cond.replace(/\bor\b/ig, ' || ');
      cond = cond.replace(/\bnot\b/ig, '!');
      
      //console.log('EVAL', unescape(cond), evalScope);
      var result = eval("with (evalScope) { " + unescape(cond) + "; }");
      //console.log("??", cond, result);
      return result;
    }
    
    function Page(name, questions, pageBreaks, isStop) {
      this.name = name;
      this.questions = questions;
      this.showButton = !isStop || !_.any(questions, function(q) {
        return q.input_type == 'submit' || q.type == 'survey_button';
      });
      this.pageBreaks = pageBreaks;

      this.next = function(state, scope) {

        //console.log('aaaaaaaaaaaa', state.answers);

        // check required fields
        var hasErrors = false;
        _.each(this.questions, function(q) {
          if (q.is_required && !state.answers[q.name]) {
            scope.$broadcast('error.' + q.name, 'is_required');
            hasErrors = true;
            return;
          }
          if (q.validation == 'numericality') {
            // FIXME
          }

          // field is good, reset the error
          scope.$broadcast('error.' + q.name, false);
        });

        if (hasErrors) {
          scope.errorMessage = "Please check all fields";
          return false;
        }
        scope.errorMessage = null;

        if (!pageBreaks.length) {
          // done?
          return true;
        }

        var evalScope = JSON.parse(JSON.stringify(state.answers));
        $rootScope.$broadcast('SurveyModel.eval', evalScope);
        
        for (var i=0; i<pageBreaks.length; i++) {
          var pageBreak = pageBreaks[i];
          if (checkCondition(pageBreak.target1, pageBreak.condition1, evalScope)) {
            return pageBreak.target1;
          }
          if (checkCondition(pageBreak.target2, pageBreak.condition2, evalScope)) {
            return pageBreak.target2;
          }
        }
        return true;
      };
      return this;
    }
    
    return function(resourceModel) {
      return {
        get: function(id) {
          return resourceModel.get(id).then(function(r) {
            var allQuestions = r.rsc.blocks;

            var pages = [];
            var qs = [];
            var pageName;

            var collectingBreaks = false;
            var group = [];
            var groups = [];
            //
            // Group questions into pages
            for (var i=0; i<allQuestions.length; i++) {
              var q = allQuestions[i];

              if (!collectingBreaks) {
                if (q.type == 'survey_page_break' || q.type == 'survey_stop') {
                  collectingBreaks = true;
                }
                group.push(q);
              } else {
                // collecting
                if (q.type == 'survey_page_break' || q.type == 'survey_stop') {
                  group.push(q);
                } else {
                  groups.push(group);
                  group = [q];
                  collectingBreaks = false;
                }
              }
            }

            if (group.length) {
              groups.push(group);
            }

            _.each(groups,
                   function(q) {
                     var qs = _.filter(q,
                                       function(d) {
                                         return d.type != 'survey_stop' && d.type != 'survey_page_break';
                                       });
                     var name = q[0].name;
                     var breaks = _.filter(q, {type: 'survey_page_break'});
                     var isStop = typeof _.filter(q, {type: 'survey_page_break'}) == 'object';
                     pages.push(new Page(name, qs, breaks, isStop));
                   });

            //
            // Make name-to-page lookup
            var byName = {};
            for (i=0; i<pages.length; i++) {
              if (typeof pages[i].name != 'undefined') {
                byName[pages[i].name] = i;
              }
            }

            //
            // Find external page resource ids
            var ext = {};
            var extq =
              _(allQuestions)
              .filter(function(q) { return q.type == 'page'; })
              .indexBy('rsc_id')
              .keys()
              .forEach(function(id) {
                resourceModel.get(id).then(
                  function(r) {
                    ext[r.id] = r;
                  });
              })
              .valueOf();
            var externalPages = $q.all(extq);
            
            return externalPages.then(function(p) {
              r.pages = pages;
              r.byName = byName;
              r.ext = ext;
              return r;
            });
          });
        }
      };
    };
  })

//
// Survey main controller
//

  .factory('SurveyController', function($rootScope, $ionicPopup, $ionicScrollDelegate, $ionicNavBarDelegate, zTrans, SurveyModel, SurveyState, appTrans) {
    return {
      bind: function($scope, id, resourceModel) {

        SurveyModel(resourceModel).get(id).then(function(survey) {

          //$ionicNavBarDelegate.title(zTrans(survey.rsc.short_title) || zTrans(survey.rsc.title));

          $scope.resourceModel = resourceModel;
          
          var state = SurveyState.load(id);
          $scope.state = state;
          $scope.survey = survey;

          var p = survey.pages[state.currentPage];
          
          function doStop() {
            $ionicScrollDelegate.scrollTop();
            $scope.state = state = SurveyState.reset(id);
          }

          function doSubmit() {
            var data = $scope.state.answers;
            // zotonic does not like null things
            for (var k in data) {
              if (data[k] === null || typeof data[k] == 'undefined') {
                data[k] = '';
              }
            }
            resourceModel.post('survey/submit', {id: id, allow_missing: "true"}, data).then(
              function(r) {
                $rootScope.$broadcast('Survey.submit', data, r);
                $scope.state = state = SurveyState.reset(id);
              },
              function(e) {
                console.log(JSON.stringify(e));
                $rootScope.$broadcast('Survey.submit-error', data, e);
              });
          }
          
          $scope.next = function(target) {
            if (state.initial) {
              state.initial = false;
              SurveyState.save(id, state);
              $ionicScrollDelegate.scrollTop();
              return;
            }
            var p = survey.pages[state.currentPage];
            var result = p.next(state, $scope);
            var next;
            if (typeof result == "string" || typeof target == "string") {
              if (result === true) result = target;
              if (result == "stop") {
                doStop();
                return;
              }
              if (result == "submit") {
                doSubmit();
                return;
              }

              next = survey.byName[result];
            } else if (result === true) {
              next = state.currentPage+1;
            }

            // save it
            if (typeof next != 'undefined') {
              state.backStack.push(state.currentPage);
              state.currentPage = next;
              SurveyState.save(id, state);
              $ionicScrollDelegate.scrollTop();
            }
          };

          $scope.back = function() {
            $ionicScrollDelegate.scrollTop();
            state.currentPage = state.backStack.pop();
            SurveyState.save(id, state);
          };

          $scope.stop = function() {
            $ionicPopup.confirm({
              title: appTrans('Confirm'),
              template: appTrans('Are you sure you want to stop?'),
              okType: 'button-positve',
              okText: appTrans('Yes'),
              cancelType: 'button-clear',
              cancelText: appTrans('No')
            }).then(function(res) {
              if (res) {
                doStop();
              }
            });
          };
          
          $scope.$on('survey-next', function(_, target) {
            $scope.next(target);
          });
        });
        
      }
    };
  })

//
// Directives
//

  .factory('zSurveyDirective', function() {
    return function(template, linkfn) {
      return {
        restrict: 'E',
        templateUrl: 'templates/survey/' + template + '.html',
        scope: {
          q: '=',
          survey: '=',
          state: '=',
        },
        link: linkfn
      };
    };
  })

  .directive('zSurveyHeader', function(zSurveyDirective) {
    return zSurveyDirective(
      'q_header',
      function(){}
    );
  })

  .directive('zSurveyPage', function($ionicModal, zSurveyDirective) {
    return zSurveyDirective(
      'q_page',
      function(scope, elem, attr) {
        scope.page = scope.survey.ext[scope.q.rsc_id];
        scope.showModal = function() {
          $ionicModal.fromTemplateUrl('templates/survey/q_page_modal.html', {
            scope: scope,
            animation: 'slide-in-up'
          }).then(function(modal) {
            scope.modal = modal;
            modal.show();
          });
        };
      });
  })

  .directive('zSurveyText', function(zTrans, zSurveyDirective) {
    return zSurveyDirective(
      'q_text',
      function(scope, elem, attr) {
      });
  })

  .factory('zSurveySimpleAnswer', function() {
    return function(extra) {
      return function(scope, elem, attr) {
        scope.answer = {value: null};
        scope.state.answers[scope.q.name] = null;

        scope.$watch('answer.value', function() {
          scope.state.answers[scope.q.name] = scope.answer.value;
        });
        scope.go = function(t) {
          scope.state.answers[scope.q.name] = t;
          scope.$emit('survey-next', scope.q.target);
        };
        if (typeof extra == 'function') {
          extra(scope, elem, attr);
        }
        scope.$on('error.' + scope.q.name, function(s, value) {
          scope.error = value;
        });

      };
    };
  })

  .directive('zSurveyThurstone', function(zTrans, zSurveyDirective, zSurveySimpleAnswer) {
    return zSurveyDirective(
      'q_survey_thurstone',
      zSurveySimpleAnswer(
        function(scope, elem, attr) {
          var unescape = function(s) { return $('<div/>').html(s).text(); };
          var a = _(zTrans(scope.q.answers).split("\n"))
            .filter(function(s) { return s.length>0; })
            .map(function(s) {
              var i = s.indexOf('#');
              return i >= 0 ? [s.slice(0,i), s.slice(i+1)] : [s, s];
            })
            .valueOf();
          scope.answers = a;
        })
    );
  })

  .directive('zSurveyYesno', function(zTrans, zSurveyDirective, zSurveySimpleAnswer) {
    return zSurveyDirective(
      'q_survey_yesno',
      zSurveySimpleAnswer()
    );
  })

  .directive('zSurveyCountry', function(zTrans, zSurveyDirective, apiRequestCached, zSurveySimpleAnswer, appConfig) {
    return zSurveyDirective(
      'q_survey_country',
      zSurveySimpleAnswer(
        function(scope, elem, attr) {
          apiRequestCached('womenonweb/countries', {}, appConfig.webProvider).then(
            function(c) {
              scope.countries = c;
            });
        })
    );
  })

  .directive('zSurveyShortAnswer', function(zTrans, zSurveyDirective, zSurveySimpleAnswer) {
    return zSurveyDirective(
      'q_survey_short_answer',
      zSurveySimpleAnswer()
    );
  })

  .directive('zSurveyLongAnswer', function(zTrans, zSurveyDirective, zSurveySimpleAnswer) {
    return zSurveyDirective(
      'q_survey_long_answer',
      zSurveySimpleAnswer()
    );
  })

  .directive('zSurveyButton', function(zTrans, zSurveyDirective, zSurveySimpleAnswer) {
    return zSurveyDirective(
      'q_survey_button',
      zSurveySimpleAnswer()
    );
  })

;


/***/ }),
/* 6 */
/***/ (function(module, exports) {

angular
  .module('wow.controllers', ['wow.data', 'wow.ui'])

  .controller('AppCtrl', function($rootScope, $scope, stateRedirect, statePush, Nav, appConfig, zConfig) {

    if (!Nav.intakeDone()) {
      // intake
      Nav.doIntake();
    }

    $rootScope.$on('zotonic.config', function(_, config) {
      config.LANG = localStorage.lang;
    });

    if (localStorage.lang == 'ar') {
      $("body").addClass("rtl");
    }

    $rootScope.lang = localStorage.lang;
    $rootScope.rtl = $rootScope.lang == 'ar';

    $scope.Nav = Nav;

    $scope.menu = [];
    _.each(['abortionSurvey', 'contraceptivesSurvey', 'qa', 'pregcalc'], function(name) {
      var id = appConfig.rsc[name];
      appConfig.web.get(id).then(function(r) {
        r.click = function() {
          if (name.match(/survey/)) {
            statePush('app.survey', {src: 'web', surveyId: id});
          } else if (name == 'pregcalc') {
            statePush('app.pregcalc', {src: 'web', rscId: id});
          } else {
            statePush('app.rsc', {src: 'web', rscId: id});
          }
        };
        $scope.menu.push(r);
      });
    });

  })

  .controller('HomeCtrl', function($scope) {
    $scope.Nav.goHome();
  })

  .controller('CountryCtrl', function($scope, $state, $stateParams, $ionicLoading, zTrans, zPlayVideo, appConfig) {

    var country = $stateParams.countryId;
    var lang = localStorage.lang;

    $scope.movieId = null

    $scope.doRefresh = function() {
      appConfig.waves.invalidate([country]);
      appConfig.web.invalidate([appConfig.rsc.abortionsurvey]);
      if ($scope.movieId)
        appConfig.waves.invalidate([$scope.movieId]);
    }

    $scope.go = function(id, src) {
      $state.go('app.rsc', {src: src, rscId: id});
    };

    $scope.playMovie = function() {
      zPlayVideo($scope.movie.uri);
    };

    function load() {
      appConfig.waves.get(country).then(function(c) {
        $scope.country = c;
        $ionicLoading.hide();
        $scope.$broadcast('scroll.refreshComplete');
      });

      // select the right movie
      appConfig.web.get(appConfig.rsc.movieCollection).then(function(r) {
        r.edges.forEach(function(e) {
          if (e.predicate_name === 'relation' && e.object_title.trans[lang] && !$scope.movieId) {
            $scope.movieId = e.object_id
          }
        })

        if ($scope.movieId) {
          appConfig.web.get($scope.movieId).then(function(r) {

            appConfig.web.get(r.edges[0].object_id).then(function(r) {

              $scope.movie = r;
              console.log('>>r', JSON.stringify(r))

              $scope.movie.rsc.title = zTrans($scope.movie.rsc.title).replace(/\(.*?\)/, '');
            });
          });
        }
      })

      appConfig.web.get(appConfig.rsc.abortionSurvey).then(function(r) {
        $scope.abortionSurvey = r;
      });

      appConfig.web.get(appConfig.rsc.contraceptivesSurvey).then(function(r) {
        $scope.contraceptivesSurvey = r;
      });
    }

    $ionicLoading.show();
    load();
  })

  .controller('SurveysCtrl', function($scope, $ionicLoading, appConfig) {
    $ionicLoading.show();

    //var ids = [6894];
    var ids = [9188,9182,9181,6898,6896,6894,2817];
    appConfig.web.getMany(ids).then(function(byId) {
      $scope.surveys = [];
      for (var i=0; i<ids.length; i++) {
        $scope.surveys.push(byId[ids[i]]);
      }

      $ionicLoading.hide();
    });

    $scope.surveys = [];
  })


  .factory('CountryModel', function(apiRequestCached, appConfig) {
    return {
      getCountries: function(id) {
        return apiRequestCached('womenonweb/countries', {}, appConfig.webProvider);
      }
    };
  })

  .controller('RscCtrl', function($scope, $stateParams, ResourceController, appConfig) {
    $scope.resourceModel = appConfig[$stateParams.src];
    ResourceController.bind($scope, $stateParams.rscId, $scope.resourceModel);
  })

  .controller('SurveyCtrl', function($scope, $ionicPopup, $stateParams, $ionicLoading, CountryModel, SurveyController, appConfig, Nav) {

    $ionicLoading.show();

    // install handler for survey checks
    CountryModel.getCountries().then(
      function(countries) {
        $scope.$on('SurveyModel.eval', function(_caller, s) {
          s.wow_is_problem = function(x) {
            var country = _.find(countries, {code: x});
            return country.restriction == 4;
          };
          s.wow_is_restricted = function(x) {
            var country = _.find(countries, {code: x});
            return country.restriction === 0 || country.restriction == 1 || country.restriction == 4;
          };
          s.wow_is_shipping_to = function(x) {
            var country = _.find(countries, {code: x});
            return country.restriction != 1 && country.restriction != 2 && country.restriction != 4;
          };
        });

        $scope.$on('Survey.submit', function(_caller, answers, result) {
          $ionicPopup.show({
            title: 'Thank you',
            subTitle: 'Your consultation has been sent to our backoffice.',
            buttons: [
              { text: 'OK' },
            ]
          }).then(function() {
            Nav.goHome();
          });
        });

        $scope.$on('Survey.submit-error', function(_caller, answers, e) {
          $ionicPopup.show({
            title: 'Error',
            subTitle: e.data.error.message,
            buttons: [
              { text: 'OK' },
            ]
          });
        });

        $ionicLoading.hide();
      });

    // bind survey logic
    SurveyController.bind($scope, $stateParams.surveyId, appConfig.web);
  });


/***/ }),
/* 7 */
/***/ (function(module, exports) {

angular.module('wow.data', ['zotonic.rsc', 'zotonic.survey', 'zotonic.util'])

  .factory('appConfig', function(ResourceModelFactory, zUrlProvider) {
    return {
      waves: ResourceModelFactory(zUrlProvider('https://www.womenonwaves.org/')),
      wavesProvider: zUrlProvider('https://www.womenonwaves.org/'),
      web: ResourceModelFactory(zUrlProvider('https://www.womenonweb.org/')),
      webProvider: zUrlProvider('https://www.womenonweb.org/'),
      rsc: {
        contraceptivesSurvey: 6898,
        abortionSurvey: 6894,
        qa: 523,
        pregcalc: 6900,
        movieCollection: 11849
      }
    };
  })

  .factory('autocompleteDialog', function($rootScope, $q, $ionicModal) {
    return function(title, all, cancelable, onCancel) {

      var q = $q.defer();

      var scope = $rootScope.$new();
      scope.cancelable = cancelable === null ? true : cancelable;

      scope.title = title;
      var modal;

      scope.search = function() {
        scope.data.choices = _.filter(all, function(r) {
          return (r.title||"").match(new RegExp(scope.data.q, 'i'));
        });
      };

      var success = false;

      scope.data = {
        choices: all,
        q: ""
      };

      scope.$on('modal.hidden', function() {
        if (!success && typeof onCancel == 'function') {
          onCancel();
        }
      });

      $ionicModal.fromTemplateUrl('templates/_dialog_autocomplete.html', {
        scope: scope,
        animation: 'slide-in-up'
      }).then(function(modal) {
        modal.show();
        scope.choose = function(id) {
          success = true;
          modal.hide();
          q.resolve(id);
        };
        scope.close = function() {
          modal.hide();
        };
      });

      return q.promise;
    };
  })

  .directive('wowPregcalc', function() {
    return {
      restrict: 'E',
      scope: {
        q: '=',
        page: '='
      },
      templateUrl: 'templates/wow/pregcalc.html',
      link: function(scope, elem, attr) {

        function pregcalc_year ( y ) {
          if (y<2000) {
            return y+1900;
          } else {
            return y;
          }
        }

        var now = new Date();

        scope.block = function(name) {
          return _.find(scope.page.rsc.blocks, {name: name});
        };

        var tr = {
          fr: 'janvier,février,mars,avril,mai,juin,juillet,août,septembre,octobre,novembre,décembre',
          en: 'January,February,March,April,May,June,July,August,September,October,November,December',
          es: 'Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre',
          id: 'Januari,Februari,Maret,April,Mei,Juni,Juli,Augustus,September,Oktober,November,Desember',
          ja: '一月,二月,三月,四月,五月,六月,七月,八月,九月,十月,十一月,十二月',
          ko: 'January,February,March,April,May,June,July,August,September,October,November,December',
          nl: 'januari,februari,maart,april,mei,juni,juli,augustus,september,oktober,november,december',
          pl: 'Styczen,Luty,Marzec,Kwiecień,Maj,Czerwiec,Lipiec,Sierpień,Wrzesień,Październik,Listopad,Grudzień',
          pt: 'Janeiro,Fevereiro,Março,Abril,Maio,Junho,Julho,Agosto,Setembro,Outubro,Novembro,Dezembro',
          th: 'มกราคม,กุมภาพันธ์,มีนาคม,เมษายน,พฤษภาคม,มิถุนายน,กรกฎาคม,สิงหาคม,กันยายน,ตุลาคม,พฤศจิกายน,ธันวาคม',
          tl: 'January,February,March,April,May,June,July,August,September,October,November,December',
          tr: 'Ocak,Şubat,Mart,Nisan,Mayıs,Haziran,Temmuz,Ağustos,Eylül,Ekim,Kasım,Aralık',
        };

        var lang = localStorage.lang;
        var month_names;
        if (!(lang in tr)) {
          month_names = tr.en.split(",");
        } else {
          month_names = tr[lang].split(',');
        }

        var days_in_month = Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

        scope.monthyears = [];
        scope.monthyear = null;

        for (var i=0; i<=10; i++) {
          var m = now.getMonth() - i;
          var y = pregcalc_year(now.getYear());

          if (m < 0) {
            m += 12;
            y -= 1;
          }
          var ym = y * 100 + m;
          scope.monthyears.push({value: ym, label: month_names[m]+' '+y});
        }

        scope.days = [];
        function recalc_days() {
          var ym = parseInt(scope.monthyear, 10);
          var y = Math.floor(ym/100);
          var m = ym%100;
          var days = days_in_month[m];
          scope.days = [];
          for (var d = 1; d <= days; d++) {
            scope.days.push(d);
          }
        }

        function show_result() {
          var ym = parseInt(scope.monthyear, 10);
          var y = Math.floor(ym/100);
          var m = ym%100;
          var d = parseInt(scope.day, 10);
          if (d === 0 || ym === 0 || isNaN(ym) || isNaN(d)) {
            scope.result = false;
            return;
          }

          var now = new Date();
          var now0 = new Date(pregcalc_year(now.getYear()), now.getMonth(), now.getDate());
          var last_menstruation = new Date(y,m,d);

          var msec = now0.getTime() - last_menstruation.getTime();
          var days = Math.max(0, Math.ceil(msec / 1000 / 60 / 60 / 24));

          var weeks = Math.max(0, Math.floor(days/7));
          var wdays = Math.max(0, days%7);

          elem.find('.pregcalc-result-ds').html(days+'');
          elem.find('.pregcalc-result-w').html(weeks+'');
          elem.find('.pregcalc-result-d').html(wdays+'');

          scope.result = true;
        }

        scope.$watch('monthyear', recalc_days);
        scope.$watch('monthyear', show_result);
        scope.$watch('day', show_result);
      }
    };
  })

  .factory('appTrans', function() {
    return function(key) {
      var lang = localStorage.lang;
      var trans = {
        ja: {
          'Home': 'ホーム',
          'Stop': '停止',
          'Yes': 'はい',
          'No': 'しない',
          'Are you sure you want to stop?': 'あなたが停止してもよろしいですか？',
          'Confirm': '確認する'
        }
      };

      return (trans[lang] && key in trans[lang]) ? trans[lang][key] : key;
    };
  })

  .filter('appTrans', function(appTrans) {
    return function(key) {
      return appTrans(key);
    };
  })
;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;window.dumpseed = function() {

  /*! @source http://purl.eligrey.com/github/FileSaver.js/blob/master/FileSaver.js */
  var saveAs=saveAs||"undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob&&navigator.msSaveOrOpenBlob.bind(navigator)||function(e){"use strict";if("undefined"==typeof navigator||!/MSIE [1-9]\./.test(navigator.userAgent)){var t=e.document,n=function(){return e.URL||e.webkitURL||e},o=t.createElementNS("http://www.w3.org/1999/xhtml","a"),r="download"in o,i=function(n){var o=t.createEvent("MouseEvents");o.initMouseEvent("click",!0,!1,e,0,0,0,0,0,!1,!1,!1,!1,0,null),n.dispatchEvent(o)},a=e.webkitRequestFileSystem,c=e.requestFileSystem||a||e.mozRequestFileSystem,s=function(t){(e.setImmediate||e.setTimeout)(function(){throw t},0)},u="application/octet-stream",f=0,d=500,l=function(t){var o=function(){"string"==typeof t?n().revokeObjectURL(t):t.remove()};e.chrome?o():setTimeout(o,d)},v=function(e,t,n){t=[].concat(t);for(var o=t.length;o--;){var r=e["on"+t[o]];if("function"==typeof r)try{r.call(e,n||e)}catch(i){s(i)}}},p=function(t,s){var d,p,w,y=this,m=t.type,S=!1,h=function(){v(y,"writestart progress write writeend".split(" "))},O=function(){if((S||!d)&&(d=n().createObjectURL(t)),p)p.location.href=d;else{var o=e.open(d,"_blank");void 0==o&&"undefined"!=typeof safari&&(e.location.href=d)}y.readyState=y.DONE,h(),l(d)},b=function(e){return function(){return y.readyState!==y.DONE?e.apply(this,arguments):void 0}},g={create:!0,exclusive:!1};return y.readyState=y.INIT,s||(s="download"),r?(d=n().createObjectURL(t),o.href=d,o.download=s,i(o),y.readyState=y.DONE,h(),void l(d)):(/^\s*(?:text\/(?:plain|xml)|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(t.type)&&(t=new Blob(["﻿",t],{type:t.type})),e.chrome&&m&&m!==u&&(w=t.slice||t.webkitSlice,t=w.call(t,0,t.size,u),S=!0),a&&"download"!==s&&(s+=".download"),(m===u||a)&&(p=e),c?(f+=t.size,void c(e.TEMPORARY,f,b(function(e){e.root.getDirectory("saved",g,b(function(e){var n=function(){e.getFile(s,g,b(function(e){e.createWriter(b(function(n){n.onwriteend=function(t){p.location.href=e.toURL(),y.readyState=y.DONE,v(y,"writeend",t),l(e)},n.onerror=function(){var e=n.error;e.code!==e.ABORT_ERR&&O()},"writestart progress write abort".split(" ").forEach(function(e){n["on"+e]=y["on"+e]}),n.write(t),y.abort=function(){n.abort(),y.readyState=y.DONE},y.readyState=y.WRITING}),O)}),O)};e.getFile(s,{create:!1},b(function(e){e.remove(),n()}),b(function(e){e.code===e.NOT_FOUND_ERR?n():O()}))}),O)}),O)):void O())},w=p.prototype,y=function(e,t){return new p(e,t)};return w.abort=function(){var e=this;e.readyState=e.DONE,v(e,"abort")},w.readyState=w.INIT=0,w.WRITING=1,w.DONE=2,w.error=w.onwritestart=w.onprogress=w.onwrite=w.onabort=w.onerror=w.onwriteend=null,y}}("undefined"!=typeof self&&self||"undefined"!=typeof window&&window||this.content); true&&module.exports?module.exports.saveAs=saveAs: true&&null!==__webpack_require__(9)&&null!=__webpack_require__(10)&&!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function(){return saveAs}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

  var d = {};
  for (var k in localStorage) {
    if (k.match(/^http/)) {
      d[k] = localStorage[k];
    }
  }
  
  saveAs(new Blob([JSON.stringify(d)], {type: "application/json"}), "seed.json");
};

if (!('seeded' in window.localStorage)) {
  $.getJSON('js/seed.json', function(d) {
    for (var k in d) {
      window.localStorage[k] = d[k];
    }
    window.localStorage.seeded = '1';
    document.location.reload();
  });
}


/***/ }),
/* 9 */
/***/ (function(module, exports) {

module.exports = function() {
	throw new Error("define cannot be used indirect");
};


/***/ }),
/* 10 */
/***/ (function(module, exports) {

/* WEBPACK VAR INJECTION */(function(__webpack_amd_options__) {/* globals __webpack_amd_options__ */
module.exports = __webpack_amd_options__;

/* WEBPACK VAR INJECTION */}.call(this, {}))

/***/ }),
/* 11 */
/***/ (function(module, exports) {

angular
  .module('wow.ui', ['wow.data'])

  .filter('filter', function() {
    return function(list, f) {
      return _.filter(list, f);
    };
  })

  .factory('stateRedirect', function($state, $ionicHistory) {
    return function(state, params) {
      $ionicHistory.nextViewOptions({
        disableAnimate: true,
        disableBack: true
      });
      $state.go(state, params || {});
    };
  })

  .factory('statePush', function($state, $ionicHistory) {
    return function(state, params) {
      $ionicHistory.nextViewOptions({
        disableAnimate: false,
        disableBack: false
      });
      $state.go(state, params || {});
    };
  })

  .factory('chooseCountry', function($rootScope, apiRequestCached, appConfig, $ionicLoading, zTrans, autocompleteDialog, appTrans) {
    return function(cancelable, onCancel) {
      $ionicLoading.show();
      return apiRequestCached('search', {cat: 'country', limit: 1000, format: 'simple', sort: 'pivot_title'}, appConfig.wavesProvider).then(
        function(countries) {
          var all = _(countries)
            .map(function(r) {
              return {id: r.id, title: zTrans(r.title) };
            })
            .sortBy('title')
            .value();
          $ionicLoading.hide();
          return autocompleteDialog(appTrans('Choose your country'), all, cancelable, onCancel).then(function(id) {
            localStorage.country = id;
            return id;
          });
        });
    };
  })

  .factory('chooseLanguage', function($q, $ionicLoading, appConfig, autocompleteDialog, apiRequestCached) {
    return function(cancelable, onCancel) {
      $ionicLoading.show();

      return apiRequestCached('translation/language_list', {}, appConfig.webProvider).then(
        function(data) {
          $ionicLoading.hide();
          console.log('languages', languages)
          var languages = data.filter(function(l) { return l.is_enabled ; }).map(function(l) { return { id: l.iso, title: l.language } })

          return autocompleteDialog('Choose your language', languages, cancelable, onCancel).then(function(lang) {
            localStorage.lang = lang;
            return lang;
          })
        });
    }
  })

  .factory('Nav', function(chooseLanguage, chooseCountry, stateRedirect, statePush, appConfig) {
    return {

      switchLanguage: function() {
        chooseLanguage().then(function() {
          console.log('CHOOSE LANG DONE');
          document.location.reload();
        });
      },

      switchCountry: function() {
        chooseCountry().then(function(c) {
          stateRedirect('app.country', {countryId: c});
        });
      },

      goHome: function() {
        var country = localStorage.country;
        if (!country) return;
        stateRedirect('app.country', {countryId: country});
      },

      goSurvey: function(id) {
        statePush('app.survey', {surveyId: id});
      },

      intakeDone: function() {
        return ('country' in localStorage) && typeof localStorage.country == 'string';
      },

      doIntake: function() {
        var onCancel = function() {
          console.log('Intake cancelled, exiting app.');
          if (ionic.Platform.isAndroid()) {
            navigator.app.exitApp(); // Android
          } else {
            doIntake(); // iOS
          }
        };

        var doIntake = function() {
          chooseLanguage(false, onCancel).then(function(lang) {
            chooseCountry(false, onCancel).then(function(country) {
              localStorage.lang = lang;
              localStorage.country = country;
              document.location.reload(); //stateRedirect('app.home');
            });
          });
        };

        doIntake();
      }
    };
  })
;


/***/ }),
/* 12 */
/***/ (function(module, exports) {

// Ionic Women on W{eb,aves} App
angular
  .module('wow', ['ionic', 'ui.router', 'wow.controllers', 'wow.data', 'zotonic.ui'])

  .run(function($ionicPlatform) {

    $ionicPlatform.ready(function() {
      // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
      // for form inputs)
      if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
        cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
      }
      if (window.StatusBar) {
        // org.apache.cordova.statusbar required
        StatusBar.styleDefault();
      }
    });
  })

  .config(function($stateProvider, $urlRouterProvider) {
    $stateProvider

      .state('app', {
        url: "/app",
        abstract: true,
        templateUrl: "templates/menu.html",
        controller: 'AppCtrl'
      })

      .state('app.home', {
        url: "/home",
        views: {
          'menuContent': {
            controller: 'HomeCtrl'
          }
        }
      })

      .state('app.country', {
        url: "/country/:countryId",
        views: {
          'menuContent': {
            templateUrl: "templates/country.html",
            controller: 'CountryCtrl'
          }
        }
      })

      .state('app.search', {
        url: "/search",
        views: {
          'menuContent': {
            templateUrl: "templates/search.html"
          }
        }
      })

      .state('app.surveys', {
        url: "/surveys",
        views: {
          'menuContent': {
            templateUrl: "templates/surveys.html",
            controller: 'SurveysCtrl'
          }
        }
      })

      .state('app.survey', {
        url: "/surveys/:surveyId",
        views: {
          'menuContent': {
            templateUrl: "templates/survey.html",
            controller: 'SurveyCtrl'
          }
        }
      })

      .state('app.rsc', {
        url: "/rsc/:src/:rscId",
        views: {
          'menuContent': {
            templateUrl: "templates/rsc.html",
            controller: 'RscCtrl'
          }
        }
      })

      .state('app.pregcalc', {
        url: "/pregcalc/:src/:rscId",
        views: {
          'menuContent': {
            templateUrl: "templates/pregcalc.html",
            controller: 'RscCtrl'
          }
        }
      })

    ;
    // if none of the above states are matched, use this as the fallback
    $urlRouterProvider.otherwise('/app/home');
  });


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(14);

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(16)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(15)(false);
// Module
exports.push([module.i, "@charset \"UTF-8\";\n/*!\n  Ionicons, v1.5.2\n  Created by Ben Sperry for the Ionic Framework, http://ionicons.com/\n  https://twitter.com/benjsperry  https://twitter.com/ionicframework\n  MIT License: https://github.com/driftyco/ionicons\n*/\n@font-face {\n  font-family: \"Ionicons\";\n  src: url(\"./fonts/ionicons.eot?v=1.5.2\");\n  src: url(\"./fonts/ionicons.eot?v=1.5.2#iefix\") format(\"embedded-opentype\"), url(\"./fonts/ionicons.ttf?v=1.5.2\") format(\"truetype\"), url(\"./fonts/ionicons.woff?v=1.5.2\") format(\"woff\"), url(\"./fonts/ionicons.svg?v=1.5.2#Ionicons\") format(\"svg\");\n  font-weight: normal;\n  font-style: normal; }\n\n.ion, .ion-loading-a,\n.ion-loading-b,\n.ion-loading-c,\n.ion-loading-d,\n.ion-looping,\n.ion-refreshing,\n.ion-ios7-reloading, .ionicons,\n.ion-alert:before,\n.ion-alert-circled:before,\n.ion-android-add:before,\n.ion-android-add-contact:before,\n.ion-android-alarm:before,\n.ion-android-archive:before,\n.ion-android-arrow-back:before,\n.ion-android-arrow-down-left:before,\n.ion-android-arrow-down-right:before,\n.ion-android-arrow-forward:before,\n.ion-android-arrow-up-left:before,\n.ion-android-arrow-up-right:before,\n.ion-android-battery:before,\n.ion-android-book:before,\n.ion-android-calendar:before,\n.ion-android-call:before,\n.ion-android-camera:before,\n.ion-android-chat:before,\n.ion-android-checkmark:before,\n.ion-android-clock:before,\n.ion-android-close:before,\n.ion-android-contact:before,\n.ion-android-contacts:before,\n.ion-android-data:before,\n.ion-android-developer:before,\n.ion-android-display:before,\n.ion-android-download:before,\n.ion-android-drawer:before,\n.ion-android-dropdown:before,\n.ion-android-earth:before,\n.ion-android-folder:before,\n.ion-android-forums:before,\n.ion-android-friends:before,\n.ion-android-hand:before,\n.ion-android-image:before,\n.ion-android-inbox:before,\n.ion-android-information:before,\n.ion-android-keypad:before,\n.ion-android-lightbulb:before,\n.ion-android-locate:before,\n.ion-android-location:before,\n.ion-android-mail:before,\n.ion-android-microphone:before,\n.ion-android-mixer:before,\n.ion-android-more:before,\n.ion-android-note:before,\n.ion-android-playstore:before,\n.ion-android-printer:before,\n.ion-android-promotion:before,\n.ion-android-reminder:before,\n.ion-android-remove:before,\n.ion-android-search:before,\n.ion-android-send:before,\n.ion-android-settings:before,\n.ion-android-share:before,\n.ion-android-social:before,\n.ion-android-social-user:before,\n.ion-android-sort:before,\n.ion-android-stair-drawer:before,\n.ion-android-star:before,\n.ion-android-stopwatch:before,\n.ion-android-storage:before,\n.ion-android-system-back:before,\n.ion-android-system-home:before,\n.ion-android-system-windows:before,\n.ion-android-timer:before,\n.ion-android-trash:before,\n.ion-android-user-menu:before,\n.ion-android-volume:before,\n.ion-android-wifi:before,\n.ion-aperture:before,\n.ion-archive:before,\n.ion-arrow-down-a:before,\n.ion-arrow-down-b:before,\n.ion-arrow-down-c:before,\n.ion-arrow-expand:before,\n.ion-arrow-graph-down-left:before,\n.ion-arrow-graph-down-right:before,\n.ion-arrow-graph-up-left:before,\n.ion-arrow-graph-up-right:before,\n.ion-arrow-left-a:before,\n.ion-arrow-left-b:before,\n.ion-arrow-left-c:before,\n.ion-arrow-move:before,\n.ion-arrow-resize:before,\n.ion-arrow-return-left:before,\n.ion-arrow-return-right:before,\n.ion-arrow-right-a:before,\n.ion-arrow-right-b:before,\n.ion-arrow-right-c:before,\n.ion-arrow-shrink:before,\n.ion-arrow-swap:before,\n.ion-arrow-up-a:before,\n.ion-arrow-up-b:before,\n.ion-arrow-up-c:before,\n.ion-asterisk:before,\n.ion-at:before,\n.ion-bag:before,\n.ion-battery-charging:before,\n.ion-battery-empty:before,\n.ion-battery-full:before,\n.ion-battery-half:before,\n.ion-battery-low:before,\n.ion-beaker:before,\n.ion-beer:before,\n.ion-bluetooth:before,\n.ion-bonfire:before,\n.ion-bookmark:before,\n.ion-briefcase:before,\n.ion-bug:before,\n.ion-calculator:before,\n.ion-calendar:before,\n.ion-camera:before,\n.ion-card:before,\n.ion-cash:before,\n.ion-chatbox:before,\n.ion-chatbox-working:before,\n.ion-chatboxes:before,\n.ion-chatbubble:before,\n.ion-chatbubble-working:before,\n.ion-chatbubbles:before,\n.ion-checkmark:before,\n.ion-checkmark-circled:before,\n.ion-checkmark-round:before,\n.ion-chevron-down:before,\n.ion-chevron-left:before,\n.ion-chevron-right:before,\n.ion-chevron-up:before,\n.ion-clipboard:before,\n.ion-clock:before,\n.ion-close:before,\n.ion-close-circled:before,\n.ion-close-round:before,\n.ion-closed-captioning:before,\n.ion-cloud:before,\n.ion-code:before,\n.ion-code-download:before,\n.ion-code-working:before,\n.ion-coffee:before,\n.ion-compass:before,\n.ion-compose:before,\n.ion-connection-bars:before,\n.ion-contrast:before,\n.ion-cube:before,\n.ion-disc:before,\n.ion-document:before,\n.ion-document-text:before,\n.ion-drag:before,\n.ion-earth:before,\n.ion-edit:before,\n.ion-egg:before,\n.ion-eject:before,\n.ion-email:before,\n.ion-eye:before,\n.ion-eye-disabled:before,\n.ion-female:before,\n.ion-filing:before,\n.ion-film-marker:before,\n.ion-fireball:before,\n.ion-flag:before,\n.ion-flame:before,\n.ion-flash:before,\n.ion-flash-off:before,\n.ion-flask:before,\n.ion-folder:before,\n.ion-fork:before,\n.ion-fork-repo:before,\n.ion-forward:before,\n.ion-funnel:before,\n.ion-game-controller-a:before,\n.ion-game-controller-b:before,\n.ion-gear-a:before,\n.ion-gear-b:before,\n.ion-grid:before,\n.ion-hammer:before,\n.ion-happy:before,\n.ion-headphone:before,\n.ion-heart:before,\n.ion-heart-broken:before,\n.ion-help:before,\n.ion-help-buoy:before,\n.ion-help-circled:before,\n.ion-home:before,\n.ion-icecream:before,\n.ion-icon-social-google-plus:before,\n.ion-icon-social-google-plus-outline:before,\n.ion-image:before,\n.ion-images:before,\n.ion-information:before,\n.ion-information-circled:before,\n.ion-ionic:before,\n.ion-ios7-alarm:before,\n.ion-ios7-alarm-outline:before,\n.ion-ios7-albums:before,\n.ion-ios7-albums-outline:before,\n.ion-ios7-americanfootball:before,\n.ion-ios7-americanfootball-outline:before,\n.ion-ios7-analytics:before,\n.ion-ios7-analytics-outline:before,\n.ion-ios7-arrow-back:before,\n.ion-ios7-arrow-down:before,\n.ion-ios7-arrow-forward:before,\n.ion-ios7-arrow-left:before,\n.ion-ios7-arrow-right:before,\n.ion-ios7-arrow-thin-down:before,\n.ion-ios7-arrow-thin-left:before,\n.ion-ios7-arrow-thin-right:before,\n.ion-ios7-arrow-thin-up:before,\n.ion-ios7-arrow-up:before,\n.ion-ios7-at:before,\n.ion-ios7-at-outline:before,\n.ion-ios7-barcode:before,\n.ion-ios7-barcode-outline:before,\n.ion-ios7-baseball:before,\n.ion-ios7-baseball-outline:before,\n.ion-ios7-basketball:before,\n.ion-ios7-basketball-outline:before,\n.ion-ios7-bell:before,\n.ion-ios7-bell-outline:before,\n.ion-ios7-bolt:before,\n.ion-ios7-bolt-outline:before,\n.ion-ios7-bookmarks:before,\n.ion-ios7-bookmarks-outline:before,\n.ion-ios7-box:before,\n.ion-ios7-box-outline:before,\n.ion-ios7-briefcase:before,\n.ion-ios7-briefcase-outline:before,\n.ion-ios7-browsers:before,\n.ion-ios7-browsers-outline:before,\n.ion-ios7-calculator:before,\n.ion-ios7-calculator-outline:before,\n.ion-ios7-calendar:before,\n.ion-ios7-calendar-outline:before,\n.ion-ios7-camera:before,\n.ion-ios7-camera-outline:before,\n.ion-ios7-cart:before,\n.ion-ios7-cart-outline:before,\n.ion-ios7-chatboxes:before,\n.ion-ios7-chatboxes-outline:before,\n.ion-ios7-chatbubble:before,\n.ion-ios7-chatbubble-outline:before,\n.ion-ios7-checkmark:before,\n.ion-ios7-checkmark-empty:before,\n.ion-ios7-checkmark-outline:before,\n.ion-ios7-circle-filled:before,\n.ion-ios7-circle-outline:before,\n.ion-ios7-clock:before,\n.ion-ios7-clock-outline:before,\n.ion-ios7-close:before,\n.ion-ios7-close-empty:before,\n.ion-ios7-close-outline:before,\n.ion-ios7-cloud:before,\n.ion-ios7-cloud-download:before,\n.ion-ios7-cloud-download-outline:before,\n.ion-ios7-cloud-outline:before,\n.ion-ios7-cloud-upload:before,\n.ion-ios7-cloud-upload-outline:before,\n.ion-ios7-cloudy:before,\n.ion-ios7-cloudy-night:before,\n.ion-ios7-cloudy-night-outline:before,\n.ion-ios7-cloudy-outline:before,\n.ion-ios7-cog:before,\n.ion-ios7-cog-outline:before,\n.ion-ios7-compose:before,\n.ion-ios7-compose-outline:before,\n.ion-ios7-contact:before,\n.ion-ios7-contact-outline:before,\n.ion-ios7-copy:before,\n.ion-ios7-copy-outline:before,\n.ion-ios7-download:before,\n.ion-ios7-download-outline:before,\n.ion-ios7-drag:before,\n.ion-ios7-email:before,\n.ion-ios7-email-outline:before,\n.ion-ios7-expand:before,\n.ion-ios7-eye:before,\n.ion-ios7-eye-outline:before,\n.ion-ios7-fastforward:before,\n.ion-ios7-fastforward-outline:before,\n.ion-ios7-filing:before,\n.ion-ios7-filing-outline:before,\n.ion-ios7-film:before,\n.ion-ios7-film-outline:before,\n.ion-ios7-flag:before,\n.ion-ios7-flag-outline:before,\n.ion-ios7-folder:before,\n.ion-ios7-folder-outline:before,\n.ion-ios7-football:before,\n.ion-ios7-football-outline:before,\n.ion-ios7-gear:before,\n.ion-ios7-gear-outline:before,\n.ion-ios7-glasses:before,\n.ion-ios7-glasses-outline:before,\n.ion-ios7-heart:before,\n.ion-ios7-heart-outline:before,\n.ion-ios7-help:before,\n.ion-ios7-help-empty:before,\n.ion-ios7-help-outline:before,\n.ion-ios7-home:before,\n.ion-ios7-home-outline:before,\n.ion-ios7-infinite:before,\n.ion-ios7-infinite-outline:before,\n.ion-ios7-information:before,\n.ion-ios7-information-empty:before,\n.ion-ios7-information-outline:before,\n.ion-ios7-ionic-outline:before,\n.ion-ios7-keypad:before,\n.ion-ios7-keypad-outline:before,\n.ion-ios7-lightbulb:before,\n.ion-ios7-lightbulb-outline:before,\n.ion-ios7-location:before,\n.ion-ios7-location-outline:before,\n.ion-ios7-locked:before,\n.ion-ios7-locked-outline:before,\n.ion-ios7-loop:before,\n.ion-ios7-loop-strong:before,\n.ion-ios7-medkit:before,\n.ion-ios7-medkit-outline:before,\n.ion-ios7-mic:before,\n.ion-ios7-mic-off:before,\n.ion-ios7-mic-outline:before,\n.ion-ios7-minus:before,\n.ion-ios7-minus-empty:before,\n.ion-ios7-minus-outline:before,\n.ion-ios7-monitor:before,\n.ion-ios7-monitor-outline:before,\n.ion-ios7-moon:before,\n.ion-ios7-moon-outline:before,\n.ion-ios7-more:before,\n.ion-ios7-more-outline:before,\n.ion-ios7-musical-note:before,\n.ion-ios7-musical-notes:before,\n.ion-ios7-navigate:before,\n.ion-ios7-navigate-outline:before,\n.ion-ios7-paper:before,\n.ion-ios7-paper-outline:before,\n.ion-ios7-paperplane:before,\n.ion-ios7-paperplane-outline:before,\n.ion-ios7-partlysunny:before,\n.ion-ios7-partlysunny-outline:before,\n.ion-ios7-pause:before,\n.ion-ios7-pause-outline:before,\n.ion-ios7-paw:before,\n.ion-ios7-paw-outline:before,\n.ion-ios7-people:before,\n.ion-ios7-people-outline:before,\n.ion-ios7-person:before,\n.ion-ios7-person-outline:before,\n.ion-ios7-personadd:before,\n.ion-ios7-personadd-outline:before,\n.ion-ios7-photos:before,\n.ion-ios7-photos-outline:before,\n.ion-ios7-pie:before,\n.ion-ios7-pie-outline:before,\n.ion-ios7-play:before,\n.ion-ios7-play-outline:before,\n.ion-ios7-plus:before,\n.ion-ios7-plus-empty:before,\n.ion-ios7-plus-outline:before,\n.ion-ios7-pricetag:before,\n.ion-ios7-pricetag-outline:before,\n.ion-ios7-pricetags:before,\n.ion-ios7-pricetags-outline:before,\n.ion-ios7-printer:before,\n.ion-ios7-printer-outline:before,\n.ion-ios7-pulse:before,\n.ion-ios7-pulse-strong:before,\n.ion-ios7-rainy:before,\n.ion-ios7-rainy-outline:before,\n.ion-ios7-recording:before,\n.ion-ios7-recording-outline:before,\n.ion-ios7-redo:before,\n.ion-ios7-redo-outline:before,\n.ion-ios7-refresh:before,\n.ion-ios7-refresh-empty:before,\n.ion-ios7-refresh-outline:before,\n.ion-ios7-reload:before, .ion-ios7-reloading:before,\n.ion-ios7-reverse-camera:before,\n.ion-ios7-reverse-camera-outline:before,\n.ion-ios7-rewind:before,\n.ion-ios7-rewind-outline:before,\n.ion-ios7-search:before,\n.ion-ios7-search-strong:before,\n.ion-ios7-settings:before,\n.ion-ios7-settings-strong:before,\n.ion-ios7-shrink:before,\n.ion-ios7-skipbackward:before,\n.ion-ios7-skipbackward-outline:before,\n.ion-ios7-skipforward:before,\n.ion-ios7-skipforward-outline:before,\n.ion-ios7-snowy:before,\n.ion-ios7-speedometer:before,\n.ion-ios7-speedometer-outline:before,\n.ion-ios7-star:before,\n.ion-ios7-star-half:before,\n.ion-ios7-star-outline:before,\n.ion-ios7-stopwatch:before,\n.ion-ios7-stopwatch-outline:before,\n.ion-ios7-sunny:before,\n.ion-ios7-sunny-outline:before,\n.ion-ios7-telephone:before,\n.ion-ios7-telephone-outline:before,\n.ion-ios7-tennisball:before,\n.ion-ios7-tennisball-outline:before,\n.ion-ios7-thunderstorm:before,\n.ion-ios7-thunderstorm-outline:before,\n.ion-ios7-time:before,\n.ion-ios7-time-outline:before,\n.ion-ios7-timer:before,\n.ion-ios7-timer-outline:before,\n.ion-ios7-toggle:before,\n.ion-ios7-toggle-outline:before,\n.ion-ios7-trash:before,\n.ion-ios7-trash-outline:before,\n.ion-ios7-undo:before,\n.ion-ios7-undo-outline:before,\n.ion-ios7-unlocked:before,\n.ion-ios7-unlocked-outline:before,\n.ion-ios7-upload:before,\n.ion-ios7-upload-outline:before,\n.ion-ios7-videocam:before,\n.ion-ios7-videocam-outline:before,\n.ion-ios7-volume-high:before,\n.ion-ios7-volume-low:before,\n.ion-ios7-wineglass:before,\n.ion-ios7-wineglass-outline:before,\n.ion-ios7-world:before,\n.ion-ios7-world-outline:before,\n.ion-ipad:before,\n.ion-iphone:before,\n.ion-ipod:before,\n.ion-jet:before,\n.ion-key:before,\n.ion-knife:before,\n.ion-laptop:before,\n.ion-leaf:before,\n.ion-levels:before,\n.ion-lightbulb:before,\n.ion-link:before,\n.ion-load-a:before, .ion-loading-a:before,\n.ion-load-b:before, .ion-loading-b:before,\n.ion-load-c:before, .ion-loading-c:before,\n.ion-load-d:before, .ion-loading-d:before,\n.ion-location:before,\n.ion-locked:before,\n.ion-log-in:before,\n.ion-log-out:before,\n.ion-loop:before, .ion-looping:before,\n.ion-magnet:before,\n.ion-male:before,\n.ion-man:before,\n.ion-map:before,\n.ion-medkit:before,\n.ion-merge:before,\n.ion-mic-a:before,\n.ion-mic-b:before,\n.ion-mic-c:before,\n.ion-minus:before,\n.ion-minus-circled:before,\n.ion-minus-round:before,\n.ion-model-s:before,\n.ion-monitor:before,\n.ion-more:before,\n.ion-mouse:before,\n.ion-music-note:before,\n.ion-navicon:before,\n.ion-navicon-round:before,\n.ion-navigate:before,\n.ion-network:before,\n.ion-no-smoking:before,\n.ion-nuclear:before,\n.ion-outlet:before,\n.ion-paper-airplane:before,\n.ion-paperclip:before,\n.ion-pause:before,\n.ion-person:before,\n.ion-person-add:before,\n.ion-person-stalker:before,\n.ion-pie-graph:before,\n.ion-pin:before,\n.ion-pinpoint:before,\n.ion-pizza:before,\n.ion-plane:before,\n.ion-planet:before,\n.ion-play:before,\n.ion-playstation:before,\n.ion-plus:before,\n.ion-plus-circled:before,\n.ion-plus-round:before,\n.ion-podium:before,\n.ion-pound:before,\n.ion-power:before,\n.ion-pricetag:before,\n.ion-pricetags:before,\n.ion-printer:before,\n.ion-pull-request:before,\n.ion-qr-scanner:before,\n.ion-quote:before,\n.ion-radio-waves:before,\n.ion-record:before,\n.ion-refresh:before, .ion-refreshing:before,\n.ion-reply:before,\n.ion-reply-all:before,\n.ion-ribbon-a:before,\n.ion-ribbon-b:before,\n.ion-sad:before,\n.ion-scissors:before,\n.ion-search:before,\n.ion-settings:before,\n.ion-share:before,\n.ion-shuffle:before,\n.ion-skip-backward:before,\n.ion-skip-forward:before,\n.ion-social-android:before,\n.ion-social-android-outline:before,\n.ion-social-apple:before,\n.ion-social-apple-outline:before,\n.ion-social-bitcoin:before,\n.ion-social-bitcoin-outline:before,\n.ion-social-buffer:before,\n.ion-social-buffer-outline:before,\n.ion-social-designernews:before,\n.ion-social-designernews-outline:before,\n.ion-social-dribbble:before,\n.ion-social-dribbble-outline:before,\n.ion-social-dropbox:before,\n.ion-social-dropbox-outline:before,\n.ion-social-facebook:before,\n.ion-social-facebook-outline:before,\n.ion-social-foursquare:before,\n.ion-social-foursquare-outline:before,\n.ion-social-freebsd-devil:before,\n.ion-social-github:before,\n.ion-social-github-outline:before,\n.ion-social-google:before,\n.ion-social-google-outline:before,\n.ion-social-googleplus:before,\n.ion-social-googleplus-outline:before,\n.ion-social-hackernews:before,\n.ion-social-hackernews-outline:before,\n.ion-social-instagram:before,\n.ion-social-instagram-outline:before,\n.ion-social-linkedin:before,\n.ion-social-linkedin-outline:before,\n.ion-social-pinterest:before,\n.ion-social-pinterest-outline:before,\n.ion-social-reddit:before,\n.ion-social-reddit-outline:before,\n.ion-social-rss:before,\n.ion-social-rss-outline:before,\n.ion-social-skype:before,\n.ion-social-skype-outline:before,\n.ion-social-tumblr:before,\n.ion-social-tumblr-outline:before,\n.ion-social-tux:before,\n.ion-social-twitter:before,\n.ion-social-twitter-outline:before,\n.ion-social-usd:before,\n.ion-social-usd-outline:before,\n.ion-social-vimeo:before,\n.ion-social-vimeo-outline:before,\n.ion-social-windows:before,\n.ion-social-windows-outline:before,\n.ion-social-wordpress:before,\n.ion-social-wordpress-outline:before,\n.ion-social-yahoo:before,\n.ion-social-yahoo-outline:before,\n.ion-social-youtube:before,\n.ion-social-youtube-outline:before,\n.ion-speakerphone:before,\n.ion-speedometer:before,\n.ion-spoon:before,\n.ion-star:before,\n.ion-stats-bars:before,\n.ion-steam:before,\n.ion-stop:before,\n.ion-thermometer:before,\n.ion-thumbsdown:before,\n.ion-thumbsup:before,\n.ion-toggle:before,\n.ion-toggle-filled:before,\n.ion-trash-a:before,\n.ion-trash-b:before,\n.ion-trophy:before,\n.ion-umbrella:before,\n.ion-university:before,\n.ion-unlocked:before,\n.ion-upload:before,\n.ion-usb:before,\n.ion-videocamera:before,\n.ion-volume-high:before,\n.ion-volume-low:before,\n.ion-volume-medium:before,\n.ion-volume-mute:before,\n.ion-wand:before,\n.ion-waterdrop:before,\n.ion-wifi:before,\n.ion-wineglass:before,\n.ion-woman:before,\n.ion-wrench:before,\n.ion-xbox:before {\n  display: inline-block;\n  font-family: \"Ionicons\";\n  speak: none;\n  font-style: normal;\n  font-weight: normal;\n  font-variant: normal;\n  text-transform: none;\n  text-rendering: auto;\n  line-height: 1;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale; }\n\n.ion-spin, .ion-loading-a,\n.ion-loading-b,\n.ion-loading-c,\n.ion-loading-d,\n.ion-looping,\n.ion-refreshing,\n.ion-ios7-reloading {\n  -webkit-animation: spin 1s infinite linear;\n  -moz-animation: spin 1s infinite linear;\n  -o-animation: spin 1s infinite linear;\n  animation: spin 1s infinite linear; }\n\n@-moz-keyframes spin {\n  0% {\n    -moz-transform: rotate(0deg); }\n  100% {\n    -moz-transform: rotate(359deg); } }\n\n@-webkit-keyframes spin {\n  0% {\n    -webkit-transform: rotate(0deg); }\n  100% {\n    -webkit-transform: rotate(359deg); } }\n\n@-o-keyframes spin {\n  0% {\n    -o-transform: rotate(0deg); }\n  100% {\n    -o-transform: rotate(359deg); } }\n\n@-ms-keyframes spin {\n  0% {\n    -ms-transform: rotate(0deg); }\n  100% {\n    -ms-transform: rotate(359deg); } }\n\n@keyframes spin {\n  0% {\n    transform: rotate(0deg); }\n  100% {\n    transform: rotate(359deg); } }\n\n.ion-loading-a {\n  -webkit-animation-timing-function: steps(8, start);\n  -moz-animation-timing-function: steps(8, start);\n  animation-timing-function: steps(8, start); }\n\n.ion-alert:before {\n  content: \"\"; }\n\n.ion-alert-circled:before {\n  content: \"\"; }\n\n.ion-android-add:before {\n  content: \"\"; }\n\n.ion-android-add-contact:before {\n  content: \"\"; }\n\n.ion-android-alarm:before {\n  content: \"\"; }\n\n.ion-android-archive:before {\n  content: \"\"; }\n\n.ion-android-arrow-back:before {\n  content: \"\"; }\n\n.ion-android-arrow-down-left:before {\n  content: \"\"; }\n\n.ion-android-arrow-down-right:before {\n  content: \"\"; }\n\n.ion-android-arrow-forward:before {\n  content: \"\"; }\n\n.ion-android-arrow-up-left:before {\n  content: \"\"; }\n\n.ion-android-arrow-up-right:before {\n  content: \"\"; }\n\n.ion-android-battery:before {\n  content: \"\"; }\n\n.ion-android-book:before {\n  content: \"\"; }\n\n.ion-android-calendar:before {\n  content: \"\"; }\n\n.ion-android-call:before {\n  content: \"\"; }\n\n.ion-android-camera:before {\n  content: \"\"; }\n\n.ion-android-chat:before {\n  content: \"\"; }\n\n.ion-android-checkmark:before {\n  content: \"\"; }\n\n.ion-android-clock:before {\n  content: \"\"; }\n\n.ion-android-close:before {\n  content: \"\"; }\n\n.ion-android-contact:before {\n  content: \"\"; }\n\n.ion-android-contacts:before {\n  content: \"\"; }\n\n.ion-android-data:before {\n  content: \"\"; }\n\n.ion-android-developer:before {\n  content: \"\"; }\n\n.ion-android-display:before {\n  content: \"\"; }\n\n.ion-android-download:before {\n  content: \"\"; }\n\n.ion-android-drawer:before {\n  content: \"\"; }\n\n.ion-android-dropdown:before {\n  content: \"\"; }\n\n.ion-android-earth:before {\n  content: \"\"; }\n\n.ion-android-folder:before {\n  content: \"\"; }\n\n.ion-android-forums:before {\n  content: \"\"; }\n\n.ion-android-friends:before {\n  content: \"\"; }\n\n.ion-android-hand:before {\n  content: \"\"; }\n\n.ion-android-image:before {\n  content: \"\"; }\n\n.ion-android-inbox:before {\n  content: \"\"; }\n\n.ion-android-information:before {\n  content: \"\"; }\n\n.ion-android-keypad:before {\n  content: \"\"; }\n\n.ion-android-lightbulb:before {\n  content: \"\"; }\n\n.ion-android-locate:before {\n  content: \"\"; }\n\n.ion-android-location:before {\n  content: \"\"; }\n\n.ion-android-mail:before {\n  content: \"\"; }\n\n.ion-android-microphone:before {\n  content: \"\"; }\n\n.ion-android-mixer:before {\n  content: \"\"; }\n\n.ion-android-more:before {\n  content: \"\"; }\n\n.ion-android-note:before {\n  content: \"\"; }\n\n.ion-android-playstore:before {\n  content: \"\"; }\n\n.ion-android-printer:before {\n  content: \"\"; }\n\n.ion-android-promotion:before {\n  content: \"\"; }\n\n.ion-android-reminder:before {\n  content: \"\"; }\n\n.ion-android-remove:before {\n  content: \"\"; }\n\n.ion-android-search:before {\n  content: \"\"; }\n\n.ion-android-send:before {\n  content: \"\"; }\n\n.ion-android-settings:before {\n  content: \"\"; }\n\n.ion-android-share:before {\n  content: \"\"; }\n\n.ion-android-social:before {\n  content: \"\"; }\n\n.ion-android-social-user:before {\n  content: \"\"; }\n\n.ion-android-sort:before {\n  content: \"\"; }\n\n.ion-android-stair-drawer:before {\n  content: \"\"; }\n\n.ion-android-star:before {\n  content: \"\"; }\n\n.ion-android-stopwatch:before {\n  content: \"\"; }\n\n.ion-android-storage:before {\n  content: \"\"; }\n\n.ion-android-system-back:before {\n  content: \"\"; }\n\n.ion-android-system-home:before {\n  content: \"\"; }\n\n.ion-android-system-windows:before {\n  content: \"\"; }\n\n.ion-android-timer:before {\n  content: \"\"; }\n\n.ion-android-trash:before {\n  content: \"\"; }\n\n.ion-android-user-menu:before {\n  content: \"\"; }\n\n.ion-android-volume:before {\n  content: \"\"; }\n\n.ion-android-wifi:before {\n  content: \"\"; }\n\n.ion-aperture:before {\n  content: \"\"; }\n\n.ion-archive:before {\n  content: \"\"; }\n\n.ion-arrow-down-a:before {\n  content: \"\"; }\n\n.ion-arrow-down-b:before {\n  content: \"\"; }\n\n.ion-arrow-down-c:before {\n  content: \"\"; }\n\n.ion-arrow-expand:before {\n  content: \"\"; }\n\n.ion-arrow-graph-down-left:before {\n  content: \"\"; }\n\n.ion-arrow-graph-down-right:before {\n  content: \"\"; }\n\n.ion-arrow-graph-up-left:before {\n  content: \"\"; }\n\n.ion-arrow-graph-up-right:before {\n  content: \"\"; }\n\n.ion-arrow-left-a:before {\n  content: \"\"; }\n\n.ion-arrow-left-b:before {\n  content: \"\"; }\n\n.ion-arrow-left-c:before {\n  content: \"\"; }\n\n.ion-arrow-move:before {\n  content: \"\"; }\n\n.ion-arrow-resize:before {\n  content: \"\"; }\n\n.ion-arrow-return-left:before {\n  content: \"\"; }\n\n.ion-arrow-return-right:before {\n  content: \"\"; }\n\n.ion-arrow-right-a:before {\n  content: \"\"; }\n\n.ion-arrow-right-b:before {\n  content: \"\"; }\n\n.ion-arrow-right-c:before {\n  content: \"\"; }\n\n.ion-arrow-shrink:before {\n  content: \"\"; }\n\n.ion-arrow-swap:before {\n  content: \"\"; }\n\n.ion-arrow-up-a:before {\n  content: \"\"; }\n\n.ion-arrow-up-b:before {\n  content: \"\"; }\n\n.ion-arrow-up-c:before {\n  content: \"\"; }\n\n.ion-asterisk:before {\n  content: \"\"; }\n\n.ion-at:before {\n  content: \"\"; }\n\n.ion-bag:before {\n  content: \"\"; }\n\n.ion-battery-charging:before {\n  content: \"\"; }\n\n.ion-battery-empty:before {\n  content: \"\"; }\n\n.ion-battery-full:before {\n  content: \"\"; }\n\n.ion-battery-half:before {\n  content: \"\"; }\n\n.ion-battery-low:before {\n  content: \"\"; }\n\n.ion-beaker:before {\n  content: \"\"; }\n\n.ion-beer:before {\n  content: \"\"; }\n\n.ion-bluetooth:before {\n  content: \"\"; }\n\n.ion-bonfire:before {\n  content: \"\"; }\n\n.ion-bookmark:before {\n  content: \"\"; }\n\n.ion-briefcase:before {\n  content: \"\"; }\n\n.ion-bug:before {\n  content: \"\"; }\n\n.ion-calculator:before {\n  content: \"\"; }\n\n.ion-calendar:before {\n  content: \"\"; }\n\n.ion-camera:before {\n  content: \"\"; }\n\n.ion-card:before {\n  content: \"\"; }\n\n.ion-cash:before {\n  content: \"\"; }\n\n.ion-chatbox:before {\n  content: \"\"; }\n\n.ion-chatbox-working:before {\n  content: \"\"; }\n\n.ion-chatboxes:before {\n  content: \"\"; }\n\n.ion-chatbubble:before {\n  content: \"\"; }\n\n.ion-chatbubble-working:before {\n  content: \"\"; }\n\n.ion-chatbubbles:before {\n  content: \"\"; }\n\n.ion-checkmark:before {\n  content: \"\"; }\n\n.ion-checkmark-circled:before {\n  content: \"\"; }\n\n.ion-checkmark-round:before {\n  content: \"\"; }\n\n.ion-chevron-down:before {\n  content: \"\"; }\n\n.ion-chevron-left:before {\n  content: \"\"; }\n\n.ion-chevron-right:before {\n  content: \"\"; }\n\n.ion-chevron-up:before {\n  content: \"\"; }\n\n.ion-clipboard:before {\n  content: \"\"; }\n\n.ion-clock:before {\n  content: \"\"; }\n\n.ion-close:before {\n  content: \"\"; }\n\n.ion-close-circled:before {\n  content: \"\"; }\n\n.ion-close-round:before {\n  content: \"\"; }\n\n.ion-closed-captioning:before {\n  content: \"\"; }\n\n.ion-cloud:before {\n  content: \"\"; }\n\n.ion-code:before {\n  content: \"\"; }\n\n.ion-code-download:before {\n  content: \"\"; }\n\n.ion-code-working:before {\n  content: \"\"; }\n\n.ion-coffee:before {\n  content: \"\"; }\n\n.ion-compass:before {\n  content: \"\"; }\n\n.ion-compose:before {\n  content: \"\"; }\n\n.ion-connection-bars:before {\n  content: \"\"; }\n\n.ion-contrast:before {\n  content: \"\"; }\n\n.ion-cube:before {\n  content: \"\"; }\n\n.ion-disc:before {\n  content: \"\"; }\n\n.ion-document:before {\n  content: \"\"; }\n\n.ion-document-text:before {\n  content: \"\"; }\n\n.ion-drag:before {\n  content: \"\"; }\n\n.ion-earth:before {\n  content: \"\"; }\n\n.ion-edit:before {\n  content: \"\"; }\n\n.ion-egg:before {\n  content: \"\"; }\n\n.ion-eject:before {\n  content: \"\"; }\n\n.ion-email:before {\n  content: \"\"; }\n\n.ion-eye:before {\n  content: \"\"; }\n\n.ion-eye-disabled:before {\n  content: \"\"; }\n\n.ion-female:before {\n  content: \"\"; }\n\n.ion-filing:before {\n  content: \"\"; }\n\n.ion-film-marker:before {\n  content: \"\"; }\n\n.ion-fireball:before {\n  content: \"\"; }\n\n.ion-flag:before {\n  content: \"\"; }\n\n.ion-flame:before {\n  content: \"\"; }\n\n.ion-flash:before {\n  content: \"\"; }\n\n.ion-flash-off:before {\n  content: \"\"; }\n\n.ion-flask:before {\n  content: \"\"; }\n\n.ion-folder:before {\n  content: \"\"; }\n\n.ion-fork:before {\n  content: \"\"; }\n\n.ion-fork-repo:before {\n  content: \"\"; }\n\n.ion-forward:before {\n  content: \"\"; }\n\n.ion-funnel:before {\n  content: \"\"; }\n\n.ion-game-controller-a:before {\n  content: \"\"; }\n\n.ion-game-controller-b:before {\n  content: \"\"; }\n\n.ion-gear-a:before {\n  content: \"\"; }\n\n.ion-gear-b:before {\n  content: \"\"; }\n\n.ion-grid:before {\n  content: \"\"; }\n\n.ion-hammer:before {\n  content: \"\"; }\n\n.ion-happy:before {\n  content: \"\"; }\n\n.ion-headphone:before {\n  content: \"\"; }\n\n.ion-heart:before {\n  content: \"\"; }\n\n.ion-heart-broken:before {\n  content: \"\"; }\n\n.ion-help:before {\n  content: \"\"; }\n\n.ion-help-buoy:before {\n  content: \"\"; }\n\n.ion-help-circled:before {\n  content: \"\"; }\n\n.ion-home:before {\n  content: \"\"; }\n\n.ion-icecream:before {\n  content: \"\"; }\n\n.ion-icon-social-google-plus:before {\n  content: \"\"; }\n\n.ion-icon-social-google-plus-outline:before {\n  content: \"\"; }\n\n.ion-image:before {\n  content: \"\"; }\n\n.ion-images:before {\n  content: \"\"; }\n\n.ion-information:before {\n  content: \"\"; }\n\n.ion-information-circled:before {\n  content: \"\"; }\n\n.ion-ionic:before {\n  content: \"\"; }\n\n.ion-ios7-alarm:before {\n  content: \"\"; }\n\n.ion-ios7-alarm-outline:before {\n  content: \"\"; }\n\n.ion-ios7-albums:before {\n  content: \"\"; }\n\n.ion-ios7-albums-outline:before {\n  content: \"\"; }\n\n.ion-ios7-americanfootball:before {\n  content: \"\"; }\n\n.ion-ios7-americanfootball-outline:before {\n  content: \"\"; }\n\n.ion-ios7-analytics:before {\n  content: \"\"; }\n\n.ion-ios7-analytics-outline:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-back:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-down:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-forward:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-left:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-right:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-thin-down:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-thin-left:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-thin-right:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-thin-up:before {\n  content: \"\"; }\n\n.ion-ios7-arrow-up:before {\n  content: \"\"; }\n\n.ion-ios7-at:before {\n  content: \"\"; }\n\n.ion-ios7-at-outline:before {\n  content: \"\"; }\n\n.ion-ios7-barcode:before {\n  content: \"\"; }\n\n.ion-ios7-barcode-outline:before {\n  content: \"\"; }\n\n.ion-ios7-baseball:before {\n  content: \"\"; }\n\n.ion-ios7-baseball-outline:before {\n  content: \"\"; }\n\n.ion-ios7-basketball:before {\n  content: \"\"; }\n\n.ion-ios7-basketball-outline:before {\n  content: \"\"; }\n\n.ion-ios7-bell:before {\n  content: \"\"; }\n\n.ion-ios7-bell-outline:before {\n  content: \"\"; }\n\n.ion-ios7-bolt:before {\n  content: \"\"; }\n\n.ion-ios7-bolt-outline:before {\n  content: \"\"; }\n\n.ion-ios7-bookmarks:before {\n  content: \"\"; }\n\n.ion-ios7-bookmarks-outline:before {\n  content: \"\"; }\n\n.ion-ios7-box:before {\n  content: \"\"; }\n\n.ion-ios7-box-outline:before {\n  content: \"\"; }\n\n.ion-ios7-briefcase:before {\n  content: \"\"; }\n\n.ion-ios7-briefcase-outline:before {\n  content: \"\"; }\n\n.ion-ios7-browsers:before {\n  content: \"\"; }\n\n.ion-ios7-browsers-outline:before {\n  content: \"\"; }\n\n.ion-ios7-calculator:before {\n  content: \"\"; }\n\n.ion-ios7-calculator-outline:before {\n  content: \"\"; }\n\n.ion-ios7-calendar:before {\n  content: \"\"; }\n\n.ion-ios7-calendar-outline:before {\n  content: \"\"; }\n\n.ion-ios7-camera:before {\n  content: \"\"; }\n\n.ion-ios7-camera-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cart:before {\n  content: \"\"; }\n\n.ion-ios7-cart-outline:before {\n  content: \"\"; }\n\n.ion-ios7-chatboxes:before {\n  content: \"\"; }\n\n.ion-ios7-chatboxes-outline:before {\n  content: \"\"; }\n\n.ion-ios7-chatbubble:before {\n  content: \"\"; }\n\n.ion-ios7-chatbubble-outline:before {\n  content: \"\"; }\n\n.ion-ios7-checkmark:before {\n  content: \"\"; }\n\n.ion-ios7-checkmark-empty:before {\n  content: \"\"; }\n\n.ion-ios7-checkmark-outline:before {\n  content: \"\"; }\n\n.ion-ios7-circle-filled:before {\n  content: \"\"; }\n\n.ion-ios7-circle-outline:before {\n  content: \"\"; }\n\n.ion-ios7-clock:before {\n  content: \"\"; }\n\n.ion-ios7-clock-outline:before {\n  content: \"\"; }\n\n.ion-ios7-close:before {\n  content: \"\"; }\n\n.ion-ios7-close-empty:before {\n  content: \"\"; }\n\n.ion-ios7-close-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cloud:before {\n  content: \"\"; }\n\n.ion-ios7-cloud-download:before {\n  content: \"\"; }\n\n.ion-ios7-cloud-download-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cloud-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cloud-upload:before {\n  content: \"\"; }\n\n.ion-ios7-cloud-upload-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cloudy:before {\n  content: \"\"; }\n\n.ion-ios7-cloudy-night:before {\n  content: \"\"; }\n\n.ion-ios7-cloudy-night-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cloudy-outline:before {\n  content: \"\"; }\n\n.ion-ios7-cog:before {\n  content: \"\"; }\n\n.ion-ios7-cog-outline:before {\n  content: \"\"; }\n\n.ion-ios7-compose:before {\n  content: \"\"; }\n\n.ion-ios7-compose-outline:before {\n  content: \"\"; }\n\n.ion-ios7-contact:before {\n  content: \"\"; }\n\n.ion-ios7-contact-outline:before {\n  content: \"\"; }\n\n.ion-ios7-copy:before {\n  content: \"\"; }\n\n.ion-ios7-copy-outline:before {\n  content: \"\"; }\n\n.ion-ios7-download:before {\n  content: \"\"; }\n\n.ion-ios7-download-outline:before {\n  content: \"\"; }\n\n.ion-ios7-drag:before {\n  content: \"\"; }\n\n.ion-ios7-email:before {\n  content: \"\"; }\n\n.ion-ios7-email-outline:before {\n  content: \"\"; }\n\n.ion-ios7-expand:before {\n  content: \"\"; }\n\n.ion-ios7-eye:before {\n  content: \"\"; }\n\n.ion-ios7-eye-outline:before {\n  content: \"\"; }\n\n.ion-ios7-fastforward:before {\n  content: \"\"; }\n\n.ion-ios7-fastforward-outline:before {\n  content: \"\"; }\n\n.ion-ios7-filing:before {\n  content: \"\"; }\n\n.ion-ios7-filing-outline:before {\n  content: \"\"; }\n\n.ion-ios7-film:before {\n  content: \"\"; }\n\n.ion-ios7-film-outline:before {\n  content: \"\"; }\n\n.ion-ios7-flag:before {\n  content: \"\"; }\n\n.ion-ios7-flag-outline:before {\n  content: \"\"; }\n\n.ion-ios7-folder:before {\n  content: \"\"; }\n\n.ion-ios7-folder-outline:before {\n  content: \"\"; }\n\n.ion-ios7-football:before {\n  content: \"\"; }\n\n.ion-ios7-football-outline:before {\n  content: \"\"; }\n\n.ion-ios7-gear:before {\n  content: \"\"; }\n\n.ion-ios7-gear-outline:before {\n  content: \"\"; }\n\n.ion-ios7-glasses:before {\n  content: \"\"; }\n\n.ion-ios7-glasses-outline:before {\n  content: \"\"; }\n\n.ion-ios7-heart:before {\n  content: \"\"; }\n\n.ion-ios7-heart-outline:before {\n  content: \"\"; }\n\n.ion-ios7-help:before {\n  content: \"\"; }\n\n.ion-ios7-help-empty:before {\n  content: \"\"; }\n\n.ion-ios7-help-outline:before {\n  content: \"\"; }\n\n.ion-ios7-home:before {\n  content: \"\"; }\n\n.ion-ios7-home-outline:before {\n  content: \"\"; }\n\n.ion-ios7-infinite:before {\n  content: \"\"; }\n\n.ion-ios7-infinite-outline:before {\n  content: \"\"; }\n\n.ion-ios7-information:before {\n  content: \"\"; }\n\n.ion-ios7-information-empty:before {\n  content: \"\"; }\n\n.ion-ios7-information-outline:before {\n  content: \"\"; }\n\n.ion-ios7-ionic-outline:before {\n  content: \"\"; }\n\n.ion-ios7-keypad:before {\n  content: \"\"; }\n\n.ion-ios7-keypad-outline:before {\n  content: \"\"; }\n\n.ion-ios7-lightbulb:before {\n  content: \"\"; }\n\n.ion-ios7-lightbulb-outline:before {\n  content: \"\"; }\n\n.ion-ios7-location:before {\n  content: \"\"; }\n\n.ion-ios7-location-outline:before {\n  content: \"\"; }\n\n.ion-ios7-locked:before {\n  content: \"\"; }\n\n.ion-ios7-locked-outline:before {\n  content: \"\"; }\n\n.ion-ios7-loop:before {\n  content: \"\"; }\n\n.ion-ios7-loop-strong:before {\n  content: \"\"; }\n\n.ion-ios7-medkit:before {\n  content: \"\"; }\n\n.ion-ios7-medkit-outline:before {\n  content: \"\"; }\n\n.ion-ios7-mic:before {\n  content: \"\"; }\n\n.ion-ios7-mic-off:before {\n  content: \"\"; }\n\n.ion-ios7-mic-outline:before {\n  content: \"\"; }\n\n.ion-ios7-minus:before {\n  content: \"\"; }\n\n.ion-ios7-minus-empty:before {\n  content: \"\"; }\n\n.ion-ios7-minus-outline:before {\n  content: \"\"; }\n\n.ion-ios7-monitor:before {\n  content: \"\"; }\n\n.ion-ios7-monitor-outline:before {\n  content: \"\"; }\n\n.ion-ios7-moon:before {\n  content: \"\"; }\n\n.ion-ios7-moon-outline:before {\n  content: \"\"; }\n\n.ion-ios7-more:before {\n  content: \"\"; }\n\n.ion-ios7-more-outline:before {\n  content: \"\"; }\n\n.ion-ios7-musical-note:before {\n  content: \"\"; }\n\n.ion-ios7-musical-notes:before {\n  content: \"\"; }\n\n.ion-ios7-navigate:before {\n  content: \"\"; }\n\n.ion-ios7-navigate-outline:before {\n  content: \"\"; }\n\n.ion-ios7-paper:before {\n  content: \"\"; }\n\n.ion-ios7-paper-outline:before {\n  content: \"\"; }\n\n.ion-ios7-paperplane:before {\n  content: \"\"; }\n\n.ion-ios7-paperplane-outline:before {\n  content: \"\"; }\n\n.ion-ios7-partlysunny:before {\n  content: \"\"; }\n\n.ion-ios7-partlysunny-outline:before {\n  content: \"\"; }\n\n.ion-ios7-pause:before {\n  content: \"\"; }\n\n.ion-ios7-pause-outline:before {\n  content: \"\"; }\n\n.ion-ios7-paw:before {\n  content: \"\"; }\n\n.ion-ios7-paw-outline:before {\n  content: \"\"; }\n\n.ion-ios7-people:before {\n  content: \"\"; }\n\n.ion-ios7-people-outline:before {\n  content: \"\"; }\n\n.ion-ios7-person:before {\n  content: \"\"; }\n\n.ion-ios7-person-outline:before {\n  content: \"\"; }\n\n.ion-ios7-personadd:before {\n  content: \"\"; }\n\n.ion-ios7-personadd-outline:before {\n  content: \"\"; }\n\n.ion-ios7-photos:before {\n  content: \"\"; }\n\n.ion-ios7-photos-outline:before {\n  content: \"\"; }\n\n.ion-ios7-pie:before {\n  content: \"\"; }\n\n.ion-ios7-pie-outline:before {\n  content: \"\"; }\n\n.ion-ios7-play:before {\n  content: \"\"; }\n\n.ion-ios7-play-outline:before {\n  content: \"\"; }\n\n.ion-ios7-plus:before {\n  content: \"\"; }\n\n.ion-ios7-plus-empty:before {\n  content: \"\"; }\n\n.ion-ios7-plus-outline:before {\n  content: \"\"; }\n\n.ion-ios7-pricetag:before {\n  content: \"\"; }\n\n.ion-ios7-pricetag-outline:before {\n  content: \"\"; }\n\n.ion-ios7-pricetags:before {\n  content: \"\"; }\n\n.ion-ios7-pricetags-outline:before {\n  content: \"\"; }\n\n.ion-ios7-printer:before {\n  content: \"\"; }\n\n.ion-ios7-printer-outline:before {\n  content: \"\"; }\n\n.ion-ios7-pulse:before {\n  content: \"\"; }\n\n.ion-ios7-pulse-strong:before {\n  content: \"\"; }\n\n.ion-ios7-rainy:before {\n  content: \"\"; }\n\n.ion-ios7-rainy-outline:before {\n  content: \"\"; }\n\n.ion-ios7-recording:before {\n  content: \"\"; }\n\n.ion-ios7-recording-outline:before {\n  content: \"\"; }\n\n.ion-ios7-redo:before {\n  content: \"\"; }\n\n.ion-ios7-redo-outline:before {\n  content: \"\"; }\n\n.ion-ios7-refresh:before {\n  content: \"\"; }\n\n.ion-ios7-refresh-empty:before {\n  content: \"\"; }\n\n.ion-ios7-refresh-outline:before {\n  content: \"\"; }\n\n.ion-ios7-reload:before, .ion-ios7-reloading:before {\n  content: \"\"; }\n\n.ion-ios7-reverse-camera:before {\n  content: \"\"; }\n\n.ion-ios7-reverse-camera-outline:before {\n  content: \"\"; }\n\n.ion-ios7-rewind:before {\n  content: \"\"; }\n\n.ion-ios7-rewind-outline:before {\n  content: \"\"; }\n\n.ion-ios7-search:before {\n  content: \"\"; }\n\n.ion-ios7-search-strong:before {\n  content: \"\"; }\n\n.ion-ios7-settings:before {\n  content: \"\"; }\n\n.ion-ios7-settings-strong:before {\n  content: \"\"; }\n\n.ion-ios7-shrink:before {\n  content: \"\"; }\n\n.ion-ios7-skipbackward:before {\n  content: \"\"; }\n\n.ion-ios7-skipbackward-outline:before {\n  content: \"\"; }\n\n.ion-ios7-skipforward:before {\n  content: \"\"; }\n\n.ion-ios7-skipforward-outline:before {\n  content: \"\"; }\n\n.ion-ios7-snowy:before {\n  content: \"\"; }\n\n.ion-ios7-speedometer:before {\n  content: \"\"; }\n\n.ion-ios7-speedometer-outline:before {\n  content: \"\"; }\n\n.ion-ios7-star:before {\n  content: \"\"; }\n\n.ion-ios7-star-half:before {\n  content: \"\"; }\n\n.ion-ios7-star-outline:before {\n  content: \"\"; }\n\n.ion-ios7-stopwatch:before {\n  content: \"\"; }\n\n.ion-ios7-stopwatch-outline:before {\n  content: \"\"; }\n\n.ion-ios7-sunny:before {\n  content: \"\"; }\n\n.ion-ios7-sunny-outline:before {\n  content: \"\"; }\n\n.ion-ios7-telephone:before {\n  content: \"\"; }\n\n.ion-ios7-telephone-outline:before {\n  content: \"\"; }\n\n.ion-ios7-tennisball:before {\n  content: \"\"; }\n\n.ion-ios7-tennisball-outline:before {\n  content: \"\"; }\n\n.ion-ios7-thunderstorm:before {\n  content: \"\"; }\n\n.ion-ios7-thunderstorm-outline:before {\n  content: \"\"; }\n\n.ion-ios7-time:before {\n  content: \"\"; }\n\n.ion-ios7-time-outline:before {\n  content: \"\"; }\n\n.ion-ios7-timer:before {\n  content: \"\"; }\n\n.ion-ios7-timer-outline:before {\n  content: \"\"; }\n\n.ion-ios7-toggle:before {\n  content: \"\"; }\n\n.ion-ios7-toggle-outline:before {\n  content: \"\"; }\n\n.ion-ios7-trash:before {\n  content: \"\"; }\n\n.ion-ios7-trash-outline:before {\n  content: \"\"; }\n\n.ion-ios7-undo:before {\n  content: \"\"; }\n\n.ion-ios7-undo-outline:before {\n  content: \"\"; }\n\n.ion-ios7-unlocked:before {\n  content: \"\"; }\n\n.ion-ios7-unlocked-outline:before {\n  content: \"\"; }\n\n.ion-ios7-upload:before {\n  content: \"\"; }\n\n.ion-ios7-upload-outline:before {\n  content: \"\"; }\n\n.ion-ios7-videocam:before {\n  content: \"\"; }\n\n.ion-ios7-videocam-outline:before {\n  content: \"\"; }\n\n.ion-ios7-volume-high:before {\n  content: \"\"; }\n\n.ion-ios7-volume-low:before {\n  content: \"\"; }\n\n.ion-ios7-wineglass:before {\n  content: \"\"; }\n\n.ion-ios7-wineglass-outline:before {\n  content: \"\"; }\n\n.ion-ios7-world:before {\n  content: \"\"; }\n\n.ion-ios7-world-outline:before {\n  content: \"\"; }\n\n.ion-ipad:before {\n  content: \"\"; }\n\n.ion-iphone:before {\n  content: \"\"; }\n\n.ion-ipod:before {\n  content: \"\"; }\n\n.ion-jet:before {\n  content: \"\"; }\n\n.ion-key:before {\n  content: \"\"; }\n\n.ion-knife:before {\n  content: \"\"; }\n\n.ion-laptop:before {\n  content: \"\"; }\n\n.ion-leaf:before {\n  content: \"\"; }\n\n.ion-levels:before {\n  content: \"\"; }\n\n.ion-lightbulb:before {\n  content: \"\"; }\n\n.ion-link:before {\n  content: \"\"; }\n\n.ion-load-a:before, .ion-loading-a:before {\n  content: \"\"; }\n\n.ion-load-b:before, .ion-loading-b:before {\n  content: \"\"; }\n\n.ion-load-c:before, .ion-loading-c:before {\n  content: \"\"; }\n\n.ion-load-d:before, .ion-loading-d:before {\n  content: \"\"; }\n\n.ion-location:before {\n  content: \"\"; }\n\n.ion-locked:before {\n  content: \"\"; }\n\n.ion-log-in:before {\n  content: \"\"; }\n\n.ion-log-out:before {\n  content: \"\"; }\n\n.ion-loop:before, .ion-looping:before {\n  content: \"\"; }\n\n.ion-magnet:before {\n  content: \"\"; }\n\n.ion-male:before {\n  content: \"\"; }\n\n.ion-man:before {\n  content: \"\"; }\n\n.ion-map:before {\n  content: \"\"; }\n\n.ion-medkit:before {\n  content: \"\"; }\n\n.ion-merge:before {\n  content: \"\"; }\n\n.ion-mic-a:before {\n  content: \"\"; }\n\n.ion-mic-b:before {\n  content: \"\"; }\n\n.ion-mic-c:before {\n  content: \"\"; }\n\n.ion-minus:before {\n  content: \"\"; }\n\n.ion-minus-circled:before {\n  content: \"\"; }\n\n.ion-minus-round:before {\n  content: \"\"; }\n\n.ion-model-s:before {\n  content: \"\"; }\n\n.ion-monitor:before {\n  content: \"\"; }\n\n.ion-more:before {\n  content: \"\"; }\n\n.ion-mouse:before {\n  content: \"\"; }\n\n.ion-music-note:before {\n  content: \"\"; }\n\n.ion-navicon:before {\n  content: \"\"; }\n\n.ion-navicon-round:before {\n  content: \"\"; }\n\n.ion-navigate:before {\n  content: \"\"; }\n\n.ion-network:before {\n  content: \"\"; }\n\n.ion-no-smoking:before {\n  content: \"\"; }\n\n.ion-nuclear:before {\n  content: \"\"; }\n\n.ion-outlet:before {\n  content: \"\"; }\n\n.ion-paper-airplane:before {\n  content: \"\"; }\n\n.ion-paperclip:before {\n  content: \"\"; }\n\n.ion-pause:before {\n  content: \"\"; }\n\n.ion-person:before {\n  content: \"\"; }\n\n.ion-person-add:before {\n  content: \"\"; }\n\n.ion-person-stalker:before {\n  content: \"\"; }\n\n.ion-pie-graph:before {\n  content: \"\"; }\n\n.ion-pin:before {\n  content: \"\"; }\n\n.ion-pinpoint:before {\n  content: \"\"; }\n\n.ion-pizza:before {\n  content: \"\"; }\n\n.ion-plane:before {\n  content: \"\"; }\n\n.ion-planet:before {\n  content: \"\"; }\n\n.ion-play:before {\n  content: \"\"; }\n\n.ion-playstation:before {\n  content: \"\"; }\n\n.ion-plus:before {\n  content: \"\"; }\n\n.ion-plus-circled:before {\n  content: \"\"; }\n\n.ion-plus-round:before {\n  content: \"\"; }\n\n.ion-podium:before {\n  content: \"\"; }\n\n.ion-pound:before {\n  content: \"\"; }\n\n.ion-power:before {\n  content: \"\"; }\n\n.ion-pricetag:before {\n  content: \"\"; }\n\n.ion-pricetags:before {\n  content: \"\"; }\n\n.ion-printer:before {\n  content: \"\"; }\n\n.ion-pull-request:before {\n  content: \"\"; }\n\n.ion-qr-scanner:before {\n  content: \"\"; }\n\n.ion-quote:before {\n  content: \"\"; }\n\n.ion-radio-waves:before {\n  content: \"\"; }\n\n.ion-record:before {\n  content: \"\"; }\n\n.ion-refresh:before, .ion-refreshing:before {\n  content: \"\"; }\n\n.ion-reply:before {\n  content: \"\"; }\n\n.ion-reply-all:before {\n  content: \"\"; }\n\n.ion-ribbon-a:before {\n  content: \"\"; }\n\n.ion-ribbon-b:before {\n  content: \"\"; }\n\n.ion-sad:before {\n  content: \"\"; }\n\n.ion-scissors:before {\n  content: \"\"; }\n\n.ion-search:before {\n  content: \"\"; }\n\n.ion-settings:before {\n  content: \"\"; }\n\n.ion-share:before {\n  content: \"\"; }\n\n.ion-shuffle:before {\n  content: \"\"; }\n\n.ion-skip-backward:before {\n  content: \"\"; }\n\n.ion-skip-forward:before {\n  content: \"\"; }\n\n.ion-social-android:before {\n  content: \"\"; }\n\n.ion-social-android-outline:before {\n  content: \"\"; }\n\n.ion-social-apple:before {\n  content: \"\"; }\n\n.ion-social-apple-outline:before {\n  content: \"\"; }\n\n.ion-social-bitcoin:before {\n  content: \"\"; }\n\n.ion-social-bitcoin-outline:before {\n  content: \"\"; }\n\n.ion-social-buffer:before {\n  content: \"\"; }\n\n.ion-social-buffer-outline:before {\n  content: \"\"; }\n\n.ion-social-designernews:before {\n  content: \"\"; }\n\n.ion-social-designernews-outline:before {\n  content: \"\"; }\n\n.ion-social-dribbble:before {\n  content: \"\"; }\n\n.ion-social-dribbble-outline:before {\n  content: \"\"; }\n\n.ion-social-dropbox:before {\n  content: \"\"; }\n\n.ion-social-dropbox-outline:before {\n  content: \"\"; }\n\n.ion-social-facebook:before {\n  content: \"\"; }\n\n.ion-social-facebook-outline:before {\n  content: \"\"; }\n\n.ion-social-foursquare:before {\n  content: \"\"; }\n\n.ion-social-foursquare-outline:before {\n  content: \"\"; }\n\n.ion-social-freebsd-devil:before {\n  content: \"\"; }\n\n.ion-social-github:before {\n  content: \"\"; }\n\n.ion-social-github-outline:before {\n  content: \"\"; }\n\n.ion-social-google:before {\n  content: \"\"; }\n\n.ion-social-google-outline:before {\n  content: \"\"; }\n\n.ion-social-googleplus:before {\n  content: \"\"; }\n\n.ion-social-googleplus-outline:before {\n  content: \"\"; }\n\n.ion-social-hackernews:before {\n  content: \"\"; }\n\n.ion-social-hackernews-outline:before {\n  content: \"\"; }\n\n.ion-social-instagram:before {\n  content: \"\"; }\n\n.ion-social-instagram-outline:before {\n  content: \"\"; }\n\n.ion-social-linkedin:before {\n  content: \"\"; }\n\n.ion-social-linkedin-outline:before {\n  content: \"\"; }\n\n.ion-social-pinterest:before {\n  content: \"\"; }\n\n.ion-social-pinterest-outline:before {\n  content: \"\"; }\n\n.ion-social-reddit:before {\n  content: \"\"; }\n\n.ion-social-reddit-outline:before {\n  content: \"\"; }\n\n.ion-social-rss:before {\n  content: \"\"; }\n\n.ion-social-rss-outline:before {\n  content: \"\"; }\n\n.ion-social-skype:before {\n  content: \"\"; }\n\n.ion-social-skype-outline:before {\n  content: \"\"; }\n\n.ion-social-tumblr:before {\n  content: \"\"; }\n\n.ion-social-tumblr-outline:before {\n  content: \"\"; }\n\n.ion-social-tux:before {\n  content: \"\"; }\n\n.ion-social-twitter:before {\n  content: \"\"; }\n\n.ion-social-twitter-outline:before {\n  content: \"\"; }\n\n.ion-social-usd:before {\n  content: \"\"; }\n\n.ion-social-usd-outline:before {\n  content: \"\"; }\n\n.ion-social-vimeo:before {\n  content: \"\"; }\n\n.ion-social-vimeo-outline:before {\n  content: \"\"; }\n\n.ion-social-windows:before {\n  content: \"\"; }\n\n.ion-social-windows-outline:before {\n  content: \"\"; }\n\n.ion-social-wordpress:before {\n  content: \"\"; }\n\n.ion-social-wordpress-outline:before {\n  content: \"\"; }\n\n.ion-social-yahoo:before {\n  content: \"\"; }\n\n.ion-social-yahoo-outline:before {\n  content: \"\"; }\n\n.ion-social-youtube:before {\n  content: \"\"; }\n\n.ion-social-youtube-outline:before {\n  content: \"\"; }\n\n.ion-speakerphone:before {\n  content: \"\"; }\n\n.ion-speedometer:before {\n  content: \"\"; }\n\n.ion-spoon:before {\n  content: \"\"; }\n\n.ion-star:before {\n  content: \"\"; }\n\n.ion-stats-bars:before {\n  content: \"\"; }\n\n.ion-steam:before {\n  content: \"\"; }\n\n.ion-stop:before {\n  content: \"\"; }\n\n.ion-thermometer:before {\n  content: \"\"; }\n\n.ion-thumbsdown:before {\n  content: \"\"; }\n\n.ion-thumbsup:before {\n  content: \"\"; }\n\n.ion-toggle:before {\n  content: \"\"; }\n\n.ion-toggle-filled:before {\n  content: \"\"; }\n\n.ion-trash-a:before {\n  content: \"\"; }\n\n.ion-trash-b:before {\n  content: \"\"; }\n\n.ion-trophy:before {\n  content: \"\"; }\n\n.ion-umbrella:before {\n  content: \"\"; }\n\n.ion-university:before {\n  content: \"\"; }\n\n.ion-unlocked:before {\n  content: \"\"; }\n\n.ion-upload:before {\n  content: \"\"; }\n\n.ion-usb:before {\n  content: \"\"; }\n\n.ion-videocamera:before {\n  content: \"\"; }\n\n.ion-volume-high:before {\n  content: \"\"; }\n\n.ion-volume-low:before {\n  content: \"\"; }\n\n.ion-volume-medium:before {\n  content: \"\"; }\n\n.ion-volume-mute:before {\n  content: \"\"; }\n\n.ion-wand:before {\n  content: \"\"; }\n\n.ion-waterdrop:before {\n  content: \"\"; }\n\n.ion-wifi:before {\n  content: \"\"; }\n\n.ion-wineglass:before {\n  content: \"\"; }\n\n.ion-woman:before {\n  content: \"\"; }\n\n.ion-wrench:before {\n  content: \"\"; }\n\n.ion-xbox:before {\n  content: \"\"; }\n\n/**\n * Resets\n * --------------------------------------------------\n * Adapted from normalize.css and some reset.css. We don't care even one\n * bit about old IE, so we don't need any hacks for that in here.\n *\n * There are probably other things we could remove here, as well.\n *\n * normalize.css v2.1.2 | MIT License | git.io/normalize\n\n * Eric Meyer's Reset CSS v2.0 (http://meyerweb.com/eric/tools/css/reset/)\n * http://cssreset.com\n */\nhtml, body, div, span, applet, object, iframe,\nh1, h2, h3, h4, h5, h6, p, blockquote, pre,\na, abbr, acronym, address, big, cite, code,\ndel, dfn, em, img, ins, kbd, q, s, samp,\nsmall, strike, strong, sub, sup, tt, var,\nb, i, u, center,\ndl, dt, dd, ol, ul, li,\nfieldset, form, label, legend,\ntable, caption, tbody, tfoot, thead, tr, th, td,\narticle, aside, canvas, details, embed, fieldset,\nfigure, figcaption, footer, header, hgroup,\nmenu, nav, output, ruby, section, summary,\ntime, mark, audio, video {\n  margin: 0;\n  padding: 0;\n  border: 0;\n  vertical-align: baseline;\n  font: inherit;\n  font-size: 100%; }\n\nol, ul {\n  list-style: none; }\n\nblockquote, q {\n  quotes: none; }\n\nblockquote:before, blockquote:after,\nq:before, q:after {\n  content: '';\n  content: none; }\n\n/**\n * Prevent modern browsers from displaying `audio` without controls.\n * Remove excess height in iOS 5 devices.\n */\naudio:not([controls]) {\n  display: none;\n  height: 0; }\n\n/**\n * Hide the `template` element in IE, Safari, and Firefox < 22.\n */\n[hidden],\ntemplate {\n  display: none; }\n\nscript {\n  display: none !important; }\n\n/* ==========================================================================\n   Base\n   ========================================================================== */\n/**\n * 1. Set default font family to sans-serif.\n * 2. Prevent iOS text size adjust after orientation change, without disabling\n *  user zoom.\n */\nhtml {\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  font-family: sans-serif;\n  /* 1 */\n  -webkit-text-size-adjust: 100%;\n  -ms-text-size-adjust: 100%;\n  /* 2 */\n  -webkit-text-size-adjust: 100%;\n  /* 2 */ }\n\n/**\n * Remove default margin.\n */\nbody {\n  margin: 0;\n  line-height: 1; }\n\n/**\n * Remove default outlines.\n */\na,\nbutton,\n:focus,\na:focus,\nbutton:focus,\na:active,\na:hover {\n  outline: 0; }\n\n/* *\n * Remove tap highlight color\n */\na {\n  -webkit-user-drag: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-tap-highlight-color: transparent; }\n  a[href]:hover {\n    cursor: pointer; }\n\n/* ==========================================================================\n   Typography\n   ========================================================================== */\n/**\n * Address style set to `bolder` in Firefox 4+, Safari 5, and Chrome.\n */\nb,\nstrong {\n  font-weight: bold; }\n\n/**\n * Address styling not present in Safari 5 and Chrome.\n */\ndfn {\n  font-style: italic; }\n\n/**\n * Address differences between Firefox and other browsers.\n */\nhr {\n  -moz-box-sizing: content-box;\n  box-sizing: content-box;\n  height: 0; }\n\n/**\n * Correct font family set oddly in Safari 5 and Chrome.\n */\ncode,\nkbd,\npre,\nsamp {\n  font-size: 1em;\n  font-family: monospace, serif; }\n\n/**\n * Improve readability of pre-formatted text in all browsers.\n */\npre {\n  white-space: pre-wrap; }\n\n/**\n * Set consistent quote types.\n */\nq {\n  quotes: \"\\201C\" \"\\201D\" \"\\2018\" \"\\2019\"; }\n\n/**\n * Address inconsistent and variable font size in all browsers.\n */\nsmall {\n  font-size: 80%; }\n\n/**\n * Prevent `sub` and `sup` affecting `line-height` in all browsers.\n */\nsub,\nsup {\n  position: relative;\n  vertical-align: baseline;\n  font-size: 75%;\n  line-height: 0; }\n\nsup {\n  top: -0.5em; }\n\nsub {\n  bottom: -0.25em; }\n\n/**\n * Define consistent border, margin, and padding.\n */\nfieldset {\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em;\n  border: 1px solid #c0c0c0; }\n\n/**\n * 1. Correct `color` not being inherited in IE 8/9.\n * 2. Remove padding so people aren't caught out if they zero out fieldsets.\n */\nlegend {\n  padding: 0;\n  /* 2 */\n  border: 0;\n  /* 1 */ }\n\n/**\n * 1. Correct font family not being inherited in all browsers.\n * 2. Correct font size not being inherited in all browsers.\n * 3. Address margins set differently in Firefox 4+, Safari 5, and Chrome.\n * 4. Remove any default :focus styles\n * 5. Make sure webkit font smoothing is being inherited\n * 6. Remove default gradient in Android Firefox / FirefoxOS\n */\nbutton,\ninput,\nselect,\ntextarea {\n  margin: 0;\n  /* 3 */\n  font-size: 100%;\n  /* 2 */\n  font-family: inherit;\n  /* 1 */\n  outline-offset: 0;\n  /* 4 */\n  outline-style: none;\n  /* 4 */\n  outline-width: 0;\n  /* 4 */\n  -webkit-font-smoothing: inherit;\n  /* 5 */\n  background-image: none;\n  /* 6 */ }\n\n/**\n * Address Firefox 4+ setting `line-height` on `input` using `importnt` in\n * the UA stylesheet.\n */\nbutton,\ninput {\n  line-height: normal; }\n\n/**\n * Address inconsistent `text-transform` inheritance for `button` and `select`.\n * All other form control elements do not inherit `text-transform` values.\n * Correct `button` style inheritance in Chrome, Safari 5+, and IE 8+.\n * Correct `select` style inheritance in Firefox 4+ and Opera.\n */\nbutton,\nselect {\n  text-transform: none; }\n\n/**\n * 1. Avoid the WebKit bug in Android 4.0.* where (2) destroys native `audio`\n *  and `video` controls.\n * 2. Correct inability to style clickable `input` types in iOS.\n * 3. Improve usability and consistency of cursor style between image-type\n *  `input` and others.\n */\nbutton,\nhtml input[type=\"button\"],\ninput[type=\"reset\"],\ninput[type=\"submit\"] {\n  cursor: pointer;\n  /* 3 */\n  -webkit-appearance: button;\n  /* 2 */ }\n\n/**\n * Re-set default cursor for disabled elements.\n */\nbutton[disabled],\nhtml input[disabled] {\n  cursor: default; }\n\n/**\n * 1. Address `appearance` set to `searchfield` in Safari 5 and Chrome.\n * 2. Address `box-sizing` set to `border-box` in Safari 5 and Chrome\n *  (include `-moz` to future-proof).\n */\ninput[type=\"search\"] {\n  -webkit-box-sizing: content-box;\n  /* 2 */\n  -moz-box-sizing: content-box;\n  box-sizing: content-box;\n  -webkit-appearance: textfield;\n  /* 1 */ }\n\n/**\n * Remove inner padding and search cancel button in Safari 5 and Chrome\n * on OS X.\n */\ninput[type=\"search\"]::-webkit-search-cancel-button,\ninput[type=\"search\"]::-webkit-search-decoration {\n  -webkit-appearance: none; }\n\n/**\n * Remove inner padding and border in Firefox 4+.\n */\nbutton::-moz-focus-inner,\ninput::-moz-focus-inner {\n  padding: 0;\n  border: 0; }\n\n/**\n * 1. Remove default vertical scrollbar in IE 8/9.\n * 2. Improve readability and alignment in all browsers.\n */\ntextarea {\n  overflow: auto;\n  /* 1 */\n  vertical-align: top;\n  /* 2 */ }\n\nimg {\n  -webkit-user-drag: none; }\n\n/* ==========================================================================\n   Tables\n   ========================================================================== */\n/**\n * Remove most spacing between table cells.\n */\ntable {\n  border-spacing: 0;\n  border-collapse: collapse; }\n\n/**\n * Scaffolding\n * --------------------------------------------------\n */\n*,\n*:before,\n*:after {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box; }\n\nhtml {\n  overflow: hidden;\n  -ms-touch-action: pan-y;\n  touch-action: pan-y; }\n\nbody,\n.ionic-body {\n  -webkit-touch-callout: none;\n  -webkit-font-smoothing: antialiased;\n  font-smoothing: antialiased;\n  -webkit-text-size-adjust: none;\n  -moz-text-size-adjust: none;\n  text-size-adjust: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-tap-highlight-color: transparent;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  overflow: hidden;\n  margin: 0;\n  padding: 0;\n  color: #000;\n  word-wrap: break-word;\n  font-size: 14px;\n  font-family: \"Helvetica Neue\", \"Roboto\", sans-serif;\n  line-height: 20px;\n  text-rendering: optimizeLegibility;\n  -webkit-backface-visibility: hidden;\n  -webkit-user-drag: none; }\n\nbody.grade-b,\nbody.grade-c {\n  text-rendering: auto; }\n\n.content {\n  position: relative; }\n\n.scroll-content {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  overflow: hidden;\n  margin-top: -1px;\n  padding-top: 1px;\n  width: auto;\n  height: auto; }\n\n.scroll-content-false,\n.menu .scroll-content.scroll-content-false {\n  z-index: 11; }\n\n.scroll-view {\n  position: relative;\n  display: block;\n  overflow: hidden;\n  margin-top: -1px; }\n\n/**\n * Scroll is the scroll view component available for complex and custom\n * scroll view functionality.\n */\n.scroll {\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  -webkit-touch-callout: none;\n  -webkit-text-size-adjust: none;\n  -moz-text-size-adjust: none;\n  text-size-adjust: none;\n  -webkit-transform-origin: left top;\n  transform-origin: left top; }\n\n::-webkit-scrollbar {\n  display: none; }\n\n.scroll-bar {\n  position: absolute;\n  z-index: 9999; }\n\n.ng-animate .scroll-bar {\n  visibility: hidden; }\n\n.scroll-bar-h {\n  right: 2px;\n  bottom: 3px;\n  left: 2px;\n  height: 3px; }\n  .scroll-bar-h .scroll-bar-indicator {\n    height: 100%; }\n\n.scroll-bar-v {\n  top: 2px;\n  right: 3px;\n  bottom: 2px;\n  width: 3px; }\n  .scroll-bar-v .scroll-bar-indicator {\n    width: 100%; }\n\n.scroll-bar-indicator {\n  position: absolute;\n  border-radius: 4px;\n  background: rgba(0, 0, 0, 0.3);\n  opacity: 1;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear; }\n  .scroll-bar-indicator.scroll-bar-fade-out {\n    opacity: 0; }\n\n.platform-android .scroll-bar-indicator {\n  border-radius: 0; }\n\n.grade-b .scroll-bar-indicator,\n.grade-c .scroll-bar-indicator {\n  background: #aaa; }\n  .grade-b .scroll-bar-indicator.scroll-bar-fade-out,\n  .grade-c .scroll-bar-indicator.scroll-bar-fade-out {\n    -webkit-transition: none;\n    transition: none; }\n\n@keyframes refresh-spin {\n  0% {\n    transform: translate3d(0, 0, 0) rotate(0); }\n  100% {\n    transform: translate3d(0, 0, 0) rotate(180deg); } }\n\n@-webkit-keyframes refresh-spin {\n  0% {\n    -webkit-transform: translate3d(0, 0, 0) rotate(0); }\n  100% {\n    -webkit-transform: translate3d(0, 0, 0) rotate(180deg); } }\n\n@keyframes refresh-spin-back {\n  0% {\n    transform: translate3d(0, 0, 0) rotate(180deg); }\n  100% {\n    transform: translate3d(0, 0, 0) rotate(0); } }\n\n@-webkit-keyframes refresh-spin-back {\n  0% {\n    -webkit-transform: translate3d(0, 0, 0) rotate(180deg); }\n  100% {\n    -webkit-transform: translate3d(0, 0, 0) rotate(0); } }\n\n.scroll-refresher {\n  position: absolute;\n  top: -60px;\n  right: 0;\n  left: 0;\n  overflow: hidden;\n  margin: auto;\n  height: 60px; }\n  .scroll-refresher .ionic-refresher-content {\n    position: absolute;\n    bottom: 15px;\n    left: 0;\n    width: 100%;\n    color: #666666;\n    text-align: center;\n    font-size: 30px; }\n    .scroll-refresher .ionic-refresher-content .text-refreshing,\n    .scroll-refresher .ionic-refresher-content .text-pulling {\n      font-size: 16px;\n      line-height: 16px; }\n    .scroll-refresher .ionic-refresher-content.ionic-refresher-with-text {\n      bottom: 10px; }\n  .scroll-refresher .icon-refreshing,\n  .scroll-refresher .icon-pulling {\n    width: 100%;\n    -webkit-backface-visibility: hidden;\n    -webkit-transform-style: preserve-3d;\n    backface-visibility: hidden;\n    transform-style: preserve-3d; }\n  .scroll-refresher .icon-pulling {\n    -webkit-animation-name: refresh-spin-back;\n    animation-name: refresh-spin-back;\n    -webkit-animation-duration: 200ms;\n    animation-duration: 200ms;\n    -webkit-animation-timing-function: linear;\n    animation-timing-function: linear;\n    -webkit-animation-fill-mode: none;\n    animation-fill-mode: none;\n    -webkit-transform: translate3d(0, 0, 0) rotate(0deg);\n    transform: translate3d(0, 0, 0) rotate(0deg); }\n  .scroll-refresher .icon-refreshing,\n  .scroll-refresher .text-refreshing {\n    display: none; }\n  .scroll-refresher .icon-refreshing {\n    -webkit-animation-duration: 1.5s;\n    animation-duration: 1.5s; }\n  .scroll-refresher.active .icon-pulling:not(.pulling-rotation-disabled) {\n    -webkit-animation-name: refresh-spin;\n    animation-name: refresh-spin;\n    -webkit-transform: translate3d(0, 0, 0) rotate(-180deg);\n    transform: translate3d(0, 0, 0) rotate(-180deg); }\n  .scroll-refresher.active.refreshing {\n    -webkit-transition: transform 0.2s;\n    transition: transform 0.2s;\n    -webkit-transition: -webkit-transform 0.2s;\n    transition: -webkit-transform 0.2s;\n    -webkit-transform: scale(1, 1);\n    transform: scale(1, 1); }\n    .scroll-refresher.active.refreshing .icon-pulling,\n    .scroll-refresher.active.refreshing .text-pulling {\n      display: none; }\n    .scroll-refresher.active.refreshing .icon-refreshing,\n    .scroll-refresher.active.refreshing .text-refreshing {\n      display: block; }\n    .scroll-refresher.active.refreshing.refreshing-tail {\n      -webkit-transform: scale(0, 0);\n      transform: scale(0, 0); }\n\nion-infinite-scroll {\n  height: 60px;\n  width: 100%;\n  opacity: 0;\n  display: block;\n  -webkit-transition: opacity 0.25s;\n  transition: opacity 0.25s;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-direction: normal;\n  -webkit-box-orient: horizontal;\n  -webkit-flex-direction: row;\n  -moz-flex-direction: row;\n  -ms-flex-direction: row;\n  flex-direction: row;\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  -webkit-justify-content: center;\n  -moz-justify-content: center;\n  justify-content: center;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center; }\n  ion-infinite-scroll .icon {\n    color: #666666;\n    font-size: 30px;\n    color: #666666; }\n  ion-infinite-scroll.active {\n    opacity: 1; }\n\n.overflow-scroll {\n  overflow-x: hidden;\n  overflow-y: scroll;\n  -webkit-overflow-scrolling: touch;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  position: absolute; }\n  .overflow-scroll .scroll {\n    position: static;\n    height: 100%;\n    -webkit-transform: translate3d(0, 0, 0); }\n\n/* If you change these, change platform.scss as well */\n.has-header {\n  top: 44px; }\n\n.no-header {\n  top: 0; }\n\n.has-subheader {\n  top: 88px; }\n\n.has-tabs-top {\n  top: 93px; }\n\n.has-header.has-subheader.has-tabs-top {\n  top: 137px; }\n\n.has-footer {\n  bottom: 44px; }\n\n.has-subfooter {\n  bottom: 88px; }\n\n.has-tabs,\n.bar-footer.has-tabs {\n  bottom: 49px; }\n\n.has-footer.has-tabs {\n  bottom: 93px; }\n\n.pane {\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0);\n  -webkit-transition-duration: 0;\n  transition-duration: 0;\n  z-index: 1; }\n\n.view {\n  z-index: 1; }\n\n.pane,\n.view {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  background-color: #fff;\n  overflow: hidden; }\n\n.view-container {\n  position: absolute;\n  display: block;\n  width: 100%;\n  height: 100%; }\n\n/**\n * Typography\n * --------------------------------------------------\n */\np {\n  margin: 0 0 10px; }\n\nsmall {\n  font-size: 85%; }\n\ncite {\n  font-style: normal; }\n\n.text-left {\n  text-align: left; }\n\n.text-right {\n  text-align: right; }\n\n.text-center {\n  text-align: center; }\n\nh1, h2, h3, h4, h5, h6,\n.h1, .h2, .h3, .h4, .h5, .h6 {\n  color: #000;\n  font-weight: 500;\n  font-family: \"Helvetica Neue\", \"Roboto\", sans-serif;\n  line-height: 1.2; }\n  h1 small, h2 small, h3 small, h4 small, h5 small, h6 small,\n  .h1 small, .h2 small, .h3 small, .h4 small, .h5 small, .h6 small {\n    font-weight: normal;\n    line-height: 1; }\n\nh1, .h1,\nh2, .h2,\nh3, .h3 {\n  margin-top: 20px;\n  margin-bottom: 10px; }\n  h1:first-child, .h1:first-child,\n  h2:first-child, .h2:first-child,\n  h3:first-child, .h3:first-child {\n    margin-top: 0; }\n  h1 + h1, h1 + .h1,\n  h1 + h2, h1 + .h2,\n  h1 + h3, h1 + .h3, .h1 + h1, .h1 + .h1,\n  .h1 + h2, .h1 + .h2,\n  .h1 + h3, .h1 + .h3,\n  h2 + h1,\n  h2 + .h1,\n  h2 + h2,\n  h2 + .h2,\n  h2 + h3,\n  h2 + .h3, .h2 + h1, .h2 + .h1,\n  .h2 + h2, .h2 + .h2,\n  .h2 + h3, .h2 + .h3,\n  h3 + h1,\n  h3 + .h1,\n  h3 + h2,\n  h3 + .h2,\n  h3 + h3,\n  h3 + .h3, .h3 + h1, .h3 + .h1,\n  .h3 + h2, .h3 + .h2,\n  .h3 + h3, .h3 + .h3 {\n    margin-top: 10px; }\n\nh4, .h4,\nh5, .h5,\nh6, .h6 {\n  margin-top: 10px;\n  margin-bottom: 10px; }\n\nh1, .h1 {\n  font-size: 36px; }\n\nh2, .h2 {\n  font-size: 30px; }\n\nh3, .h3 {\n  font-size: 24px; }\n\nh4, .h4 {\n  font-size: 18px; }\n\nh5, .h5 {\n  font-size: 14px; }\n\nh6, .h6 {\n  font-size: 12px; }\n\nh1 small, .h1 small {\n  font-size: 24px; }\n\nh2 small, .h2 small {\n  font-size: 18px; }\n\nh3 small, .h3 small,\nh4 small, .h4 small {\n  font-size: 14px; }\n\ndl {\n  margin-bottom: 20px; }\n\ndt,\ndd {\n  line-height: 1.42857; }\n\ndt {\n  font-weight: bold; }\n\nblockquote {\n  margin: 0 0 20px;\n  padding: 10px 20px;\n  border-left: 5px solid gray; }\n  blockquote p {\n    font-weight: 300;\n    font-size: 17.5px;\n    line-height: 1.25; }\n  blockquote p:last-child {\n    margin-bottom: 0; }\n  blockquote small {\n    display: block;\n    line-height: 1.42857; }\n    blockquote small:before {\n      content: '\\2014 \\00A0'; }\n\nq:before,\nq:after,\nblockquote:before,\nblockquote:after {\n  content: \"\"; }\n\naddress {\n  display: block;\n  margin-bottom: 20px;\n  font-style: normal;\n  line-height: 1.42857; }\n\na.subdued {\n  padding-right: 10px;\n  color: #888;\n  text-decoration: none; }\n  a.subdued:hover {\n    text-decoration: none; }\n  a.subdued:last-child {\n    padding-right: 0; }\n\n/**\n * Action Sheets\n * --------------------------------------------------\n */\n.action-sheet-backdrop {\n  -webkit-transition: background-color 300ms ease-in-out;\n  transition: background-color 300ms ease-in-out;\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 11;\n  width: 100%;\n  height: 100%;\n  background-color: rgba(0, 0, 0, 0); }\n  .action-sheet-backdrop.active {\n    background-color: rgba(0, 0, 0, 0.5); }\n\n.action-sheet-wrapper {\n  -webkit-transform: translate3d(0, 100%, 0);\n  transform: translate3d(0, 100%, 0);\n  -webkit-transition: all ease-in-out 300ms;\n  transition: all ease-in-out 300ms;\n  position: absolute;\n  bottom: 0;\n  width: 100%; }\n\n.action-sheet-up {\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0); }\n\n.action-sheet {\n  margin-left: 15px;\n  margin-right: 15px;\n  width: auto;\n  z-index: 11;\n  overflow: hidden; }\n  .action-sheet .button {\n    display: block;\n    padding: 1px;\n    width: 100%;\n    border-radius: 0;\n    background-color: transparent;\n    color: #387ef5;\n    font-size: 18px; }\n    .action-sheet .button.destructive {\n      color: #ef473a; }\n\n.action-sheet-title {\n  padding: 10px;\n  color: #666666;\n  text-align: center;\n  font-size: 12px; }\n\n.action-sheet-group {\n  margin-bottom: 5px;\n  border-radius: 3px 3px 3px 3px;\n  background-color: #fff; }\n  .action-sheet-group .button {\n    border-width: 1px 0px 0px 0px;\n    border-radius: 0; }\n    .action-sheet-group .button.active {\n      background-color: transparent;\n      color: inherit; }\n  .action-sheet-group .button:first-child:last-child {\n    border-width: 0; }\n\n.action-sheet-open {\n  pointer-events: none; }\n  .action-sheet-open.modal-open .modal {\n    pointer-events: none; }\n  .action-sheet-open .action-sheet-backdrop {\n    pointer-events: auto; }\n\n.backdrop {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 11;\n  width: 100%;\n  height: 100%;\n  background-color: rgba(0, 0, 0, 0.4);\n  visibility: hidden;\n  opacity: 0;\n  -webkit-transition: 0.1s opacity linear;\n  transition: 0.1s opacity linear; }\n  .backdrop.visible {\n    visibility: visible; }\n  .backdrop.active {\n    opacity: 1; }\n\n/**\n * Bar (Headers and Footers)\n * --------------------------------------------------\n */\n.bar {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0);\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  position: absolute;\n  right: 0;\n  left: 0;\n  z-index: 9;\n  box-sizing: border-box;\n  padding: 5px;\n  width: 100%;\n  height: 44px;\n  border-width: 0;\n  border-style: solid;\n  border-top: 1px solid transparent;\n  border-bottom: 1px solid #ddd;\n  background-color: white;\n  /* border-width: 1px will actually create 2 device pixels on retina */\n  /* this nifty trick sets an actual 1px border on hi-res displays */\n  background-size: 0; }\n  @media (min--moz-device-pixel-ratio: 1.5), (-webkit-min-device-pixel-ratio: 1.5), (min-device-pixel-ratio: 1.5), (min-resolution: 144dpi), (min-resolution: 1.5dppx) {\n    .bar {\n      border: none;\n      background-image: linear-gradient(0deg, #ddd, #ddd 50%, transparent 50%);\n      background-position: bottom;\n      background-size: 100% 1px;\n      background-repeat: no-repeat; } }\n  .bar.bar-clear {\n    border: none;\n    background: none;\n    color: #fff; }\n    .bar.bar-clear .button {\n      color: #fff; }\n    .bar.bar-clear .title {\n      color: #fff; }\n  .bar.item-input-inset .item-input-wrapper {\n    margin-top: -1px; }\n    .bar.item-input-inset .item-input-wrapper input {\n      padding-left: 8px;\n      width: 94%;\n      height: 28px;\n      background: transparent; }\n  .bar.bar-light {\n    border-color: #ddd;\n    background-color: white;\n    background-image: linear-gradient(0deg, #ddd, #ddd 50%, transparent 50%);\n    color: #444; }\n    .bar.bar-light .title {\n      color: #444; }\n    .bar.bar-light.bar-footer {\n      background-image: linear-gradient(180deg, #ddd, #ddd 50%, transparent 50%); }\n  .bar.bar-stable {\n    border-color: #b2b2b2;\n    background-color: #ff0d6d;\n    background-image: linear-gradient(0deg, #b2b2b2, #b2b2b2 50%, transparent 50%);\n    color: #FFFFFF; }\n    .bar.bar-stable .title {\n      color: #FFFFFF; }\n    .bar.bar-stable.bar-footer {\n      background-image: linear-gradient(180deg, #b2b2b2, #b2b2b2 50%, transparent 50%); }\n  .bar.bar-positive {\n    border-color: #0c60ee;\n    background-color: #387ef5;\n    background-image: linear-gradient(0deg, #0c60ee, #0c60ee 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-positive .title {\n      color: #fff; }\n    .bar.bar-positive.bar-footer {\n      background-image: linear-gradient(180deg, #0c60ee, #0c60ee 50%, transparent 50%); }\n  .bar.bar-calm {\n    border-color: #e26401;\n    background-color: #fe7d18;\n    background-image: linear-gradient(0deg, #e26401, #e26401 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-calm .title {\n      color: #fff; }\n    .bar.bar-calm.bar-footer {\n      background-image: linear-gradient(180deg, #e26401, #e26401 50%, transparent 50%); }\n  .bar.bar-assertive {\n    border-color: #e42112;\n    background-color: #ef473a;\n    background-image: linear-gradient(0deg, #e42112, #e42112 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-assertive .title {\n      color: #fff; }\n    .bar.bar-assertive.bar-footer {\n      background-image: linear-gradient(180deg, #e42112, #e42112 50%, transparent 50%); }\n  .bar.bar-balanced {\n    border-color: #28a54c;\n    background-color: #33cd5f;\n    background-image: linear-gradient(0deg, #28a54c, #28a54c 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-balanced .title {\n      color: #fff; }\n    .bar.bar-balanced.bar-footer {\n      background-image: linear-gradient(180deg, #28a54c, #0c60ee 50%, transparent 50%); }\n  .bar.bar-energized {\n    border-color: #e6b500;\n    background-color: #ffc900;\n    background-image: linear-gradient(0deg, #e6b500, #e6b500 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-energized .title {\n      color: #fff; }\n    .bar.bar-energized.bar-footer {\n      background-image: linear-gradient(180deg, #e6b500, #e6b500 50%, transparent 50%); }\n  .bar.bar-royal {\n    border-color: #6b46e5;\n    background-color: #886aea;\n    background-image: linear-gradient(0deg, #6b46e5, #6b46e5 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-royal .title {\n      color: #fff; }\n    .bar.bar-royal.bar-footer {\n      background-image: linear-gradient(180deg, #6b46e5, #6b46e5 50%, transparent 50%); }\n  .bar.bar-dark {\n    border-color: #111;\n    background-color: #444444;\n    background-image: linear-gradient(0deg, #111, #111 50%, transparent 50%);\n    color: #fff; }\n    .bar.bar-dark .title {\n      color: #fff; }\n    .bar.bar-dark.bar-footer {\n      background-image: linear-gradient(180deg, #111, #111 50%, transparent 50%); }\n  .bar .title {\n    position: absolute;\n    top: 0;\n    right: 0;\n    left: 0;\n    z-index: 0;\n    overflow: hidden;\n    margin: 0 10px;\n    min-width: 30px;\n    height: 43px;\n    text-align: center;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    font-size: 17px;\n    font-weight: 500;\n    line-height: 44px; }\n    .bar .title.title-left {\n      text-align: left; }\n    .bar .title.title-right {\n      text-align: right; }\n  .bar .title a {\n    color: inherit; }\n  .bar .button {\n    z-index: 1;\n    padding: 0 8px;\n    min-width: initial;\n    min-height: 31px;\n    font-weight: 400;\n    font-size: 13px;\n    line-height: 32px; }\n    .bar .button.button-icon:before,\n    .bar .button .icon:before, .bar .button.icon:before, .bar .button.icon-left:before, .bar .button.icon-right:before {\n      padding-right: 2px;\n      padding-left: 2px;\n      font-size: 20px;\n      line-height: 32px; }\n    .bar .button.button-icon {\n      font-size: 17px; }\n      .bar .button.button-icon .icon:before, .bar .button.button-icon:before, .bar .button.button-icon.icon-left:before, .bar .button.button-icon.icon-right:before {\n        vertical-align: top;\n        font-size: 32px;\n        line-height: 32px; }\n    .bar .button.button-clear {\n      padding-right: 2px;\n      padding-left: 2px;\n      font-weight: 300;\n      font-size: 17px; }\n      .bar .button.button-clear .icon:before, .bar .button.button-clear.icon:before, .bar .button.button-clear.icon-left:before, .bar .button.button-clear.icon-right:before {\n        font-size: 32px;\n        line-height: 32px; }\n    .bar .button.back-button {\n      display: block;\n      margin-right: 5px;\n      padding: 0;\n      white-space: nowrap;\n      font-weight: 400; }\n    .bar .button.back-button.active, .bar .button.back-button.activated {\n      opacity: 0.2; }\n  .bar .button-bar > .button,\n  .bar .buttons > .button {\n    min-height: 31px;\n    line-height: 32px; }\n  .bar .button-bar + .button,\n  .bar .button + .button-bar {\n    margin-left: 5px; }\n  .bar .buttons,\n  .bar .buttons.primary-buttons,\n  .bar .buttons.secondary-buttons {\n    display: inherit; }\n  .bar .buttons span {\n    display: inline-block; }\n  .bar .buttons-left span {\n    margin-right: 5px; }\n  .bar .buttons-right span {\n    margin-left: 5px; }\n  .bar .title + .button:last-child,\n  .bar > .button + .button:last-child,\n  .bar > .button.pull-right,\n  .bar .buttons.pull-right,\n  .bar .title + .buttons {\n    position: absolute;\n    top: 5px;\n    right: 5px;\n    bottom: 5px; }\n\n.bar-light .button {\n  border-color: #ddd;\n  background-color: white;\n  color: #444; }\n  .bar-light .button:hover {\n    color: #444;\n    text-decoration: none; }\n  .bar-light .button.active, .bar-light .button.activated {\n    border-color: #ccc;\n    background-color: #fafafa;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-light .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #444;\n    font-size: 17px; }\n  .bar-light .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-stable .button {\n  border-color: #b2b2b2;\n  background-color: #ff0d6d;\n  color: #FFFFFF; }\n  .bar-stable .button:hover {\n    color: #FFFFFF;\n    text-decoration: none; }\n  .bar-stable .button.active, .bar-stable .button.activated {\n    border-color: #a2a2a2;\n    background-color: #e5e5e5;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-stable .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #FFFFFF;\n    font-size: 17px; }\n  .bar-stable .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-positive .button {\n  border-color: #0c60ee;\n  background-color: #387ef5;\n  color: #fff; }\n  .bar-positive .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-positive .button.active, .bar-positive .button.activated {\n    border-color: #0c60ee;\n    background-color: #0c60ee;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-positive .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-positive .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-calm .button {\n  border-color: #e26401;\n  background-color: #fe7d18;\n  color: #fff; }\n  .bar-calm .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-calm .button.active, .bar-calm .button.activated {\n    border-color: #e26401;\n    background-color: #e26401;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-calm .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-calm .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-assertive .button {\n  border-color: #e42112;\n  background-color: #ef473a;\n  color: #fff; }\n  .bar-assertive .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-assertive .button.active, .bar-assertive .button.activated {\n    border-color: #e42112;\n    background-color: #e42112;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-assertive .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-assertive .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-balanced .button {\n  border-color: #28a54c;\n  background-color: #33cd5f;\n  color: #fff; }\n  .bar-balanced .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-balanced .button.active, .bar-balanced .button.activated {\n    border-color: #28a54c;\n    background-color: #28a54c;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-balanced .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-balanced .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-energized .button {\n  border-color: #e6b500;\n  background-color: #ffc900;\n  color: #fff; }\n  .bar-energized .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-energized .button.active, .bar-energized .button.activated {\n    border-color: #e6b500;\n    background-color: #e6b500;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-energized .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-energized .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-royal .button {\n  border-color: #6b46e5;\n  background-color: #886aea;\n  color: #fff; }\n  .bar-royal .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-royal .button.active, .bar-royal .button.activated {\n    border-color: #6b46e5;\n    background-color: #6b46e5;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-royal .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-royal .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-dark .button {\n  border-color: #111;\n  background-color: #444444;\n  color: #fff; }\n  .bar-dark .button:hover {\n    color: #fff;\n    text-decoration: none; }\n  .bar-dark .button.active, .bar-dark .button.activated {\n    border-color: #000;\n    background-color: #262626;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .bar-dark .button.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #fff;\n    font-size: 17px; }\n  .bar-dark .button.button-icon {\n    border-color: transparent;\n    background: none; }\n\n.bar-header {\n  top: 0;\n  border-top-width: 0;\n  border-bottom-width: 1px; }\n  .bar-header.has-tabs-top {\n    border-bottom-width: 0px;\n    background-image: none; }\n\n.bar-footer {\n  bottom: 0;\n  border-top-width: 1px;\n  border-bottom-width: 0;\n  background-position: top;\n  height: 44px; }\n  .bar-footer.item-input-inset {\n    position: absolute; }\n\n.bar-tabs {\n  padding: 0; }\n\n.bar-subheader {\n  top: 44px;\n  display: block;\n  height: 44px; }\n\n.bar-subfooter {\n  bottom: 44px;\n  display: block;\n  height: 44px; }\n\n.nav-bar-block {\n  position: absolute;\n  top: 0;\n  right: 0;\n  left: 0;\n  z-index: 9; }\n\n.bar .back-button.hide,\n.bar .buttons .hide {\n  display: none; }\n\n/**\n * Tabs\n * --------------------------------------------------\n * A navigation bar with any number of tab items supported.\n */\n.tabs {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-direction: normal;\n  -webkit-box-orient: horizontal;\n  -webkit-flex-direction: horizontal;\n  -moz-flex-direction: horizontal;\n  -ms-flex-direction: horizontal;\n  flex-direction: horizontal;\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  -webkit-justify-content: center;\n  -moz-justify-content: center;\n  justify-content: center;\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0);\n  border-color: #b2b2b2;\n  background-color: #FF0D6D;\n  background-image: linear-gradient(0deg, #b2b2b2, #b2b2b2 50%, transparent 50%);\n  color: #FFFFFF;\n  position: absolute;\n  bottom: 0;\n  z-index: 5;\n  width: 100%;\n  height: 49px;\n  border-style: solid;\n  border-top-width: 1px;\n  background-size: 0;\n  line-height: 49px; }\n  .tabs .tab-item .badge {\n    background-color: #FFFFFF;\n    color: #FF0D6D; }\n  @media (min--moz-device-pixel-ratio: 1.5), (-webkit-min-device-pixel-ratio: 1.5), (min-device-pixel-ratio: 1.5), (min-resolution: 144dpi), (min-resolution: 1.5dppx) {\n    .tabs {\n      padding-top: 2px;\n      border-top: none !important;\n      border-bottom: none;\n      background-position: top;\n      background-size: 100% 1px;\n      background-repeat: no-repeat; } }\n\n/* Allow parent element of tabs to define color, or just the tab itself */\n.tabs-light > .tabs,\n.tabs.tabs-light {\n  border-color: #ddd;\n  background-color: #fff;\n  background-image: linear-gradient(0deg, #ddd, #ddd 50%, transparent 50%);\n  color: #444; }\n  .tabs-light > .tabs .tab-item .badge,\n  .tabs.tabs-light .tab-item .badge {\n    background-color: #444;\n    color: #fff; }\n\n.tabs-stable > .tabs,\n.tabs.tabs-stable {\n  border-color: #b2b2b2;\n  background-color: #FF0D6D;\n  background-image: linear-gradient(0deg, #b2b2b2, #b2b2b2 50%, transparent 50%);\n  color: #FFFFFF; }\n  .tabs-stable > .tabs .tab-item .badge,\n  .tabs.tabs-stable .tab-item .badge {\n    background-color: #FFFFFF;\n    color: #FF0D6D; }\n\n.tabs-positive > .tabs,\n.tabs.tabs-positive {\n  border-color: #0c60ee;\n  background-color: #387ef5;\n  background-image: linear-gradient(0deg, #0c60ee, #0c60ee 50%, transparent 50%);\n  color: #fff; }\n  .tabs-positive > .tabs .tab-item .badge,\n  .tabs.tabs-positive .tab-item .badge {\n    background-color: #fff;\n    color: #387ef5; }\n\n.tabs-calm > .tabs,\n.tabs.tabs-calm {\n  border-color: #e26401;\n  background-color: #FE7D18;\n  background-image: linear-gradient(0deg, #e26401, #e26401 50%, transparent 50%);\n  color: #fff; }\n  .tabs-calm > .tabs .tab-item .badge,\n  .tabs.tabs-calm .tab-item .badge {\n    background-color: #fff;\n    color: #FE7D18; }\n\n.tabs-assertive > .tabs,\n.tabs.tabs-assertive {\n  border-color: #e42112;\n  background-color: #ef473a;\n  background-image: linear-gradient(0deg, #e42112, #e42112 50%, transparent 50%);\n  color: #fff; }\n  .tabs-assertive > .tabs .tab-item .badge,\n  .tabs.tabs-assertive .tab-item .badge {\n    background-color: #fff;\n    color: #ef473a; }\n\n.tabs-balanced > .tabs,\n.tabs.tabs-balanced {\n  border-color: #28a54c;\n  background-color: #33cd5f;\n  background-image: linear-gradient(0deg, #28a54c, #28a54c 50%, transparent 50%);\n  color: #fff; }\n  .tabs-balanced > .tabs .tab-item .badge,\n  .tabs.tabs-balanced .tab-item .badge {\n    background-color: #fff;\n    color: #33cd5f; }\n\n.tabs-energized > .tabs,\n.tabs.tabs-energized {\n  border-color: #e6b500;\n  background-color: #ffc900;\n  background-image: linear-gradient(0deg, #e6b500, #e6b500 50%, transparent 50%);\n  color: #fff; }\n  .tabs-energized > .tabs .tab-item .badge,\n  .tabs.tabs-energized .tab-item .badge {\n    background-color: #fff;\n    color: #ffc900; }\n\n.tabs-royal > .tabs,\n.tabs.tabs-royal {\n  border-color: #6b46e5;\n  background-color: #886aea;\n  background-image: linear-gradient(0deg, #6b46e5, #6b46e5 50%, transparent 50%);\n  color: #fff; }\n  .tabs-royal > .tabs .tab-item .badge,\n  .tabs.tabs-royal .tab-item .badge {\n    background-color: #fff;\n    color: #886aea; }\n\n.tabs-dark > .tabs,\n.tabs.tabs-dark {\n  border-color: #111;\n  background-color: #444;\n  background-image: linear-gradient(0deg, #111, #111 50%, transparent 50%);\n  color: #fff; }\n  .tabs-dark > .tabs .tab-item .badge,\n  .tabs.tabs-dark .tab-item .badge {\n    background-color: #fff;\n    color: #444; }\n\n.tabs-striped .tabs {\n  background-color: white;\n  background-image: none;\n  border: none;\n  border-bottom: 1px solid #ddd;\n  padding-top: 2px; }\n\n.tabs-striped .tab-item.tab-item-active, .tabs-striped .tab-item.active, .tabs-striped .tab-item.activated {\n  margin-top: -2px;\n  border-style: solid;\n  border-width: 2px 0 0 0;\n  border-color: #444; }\n  .tabs-striped .tab-item.tab-item-active .badge, .tabs-striped .tab-item.active .badge, .tabs-striped .tab-item.activated .badge {\n    top: 2px;\n    opacity: 1; }\n\n.tabs-striped.tabs-light .tabs {\n  background-color: #fff; }\n\n.tabs-striped.tabs-light .tab-item {\n  color: rgba(68, 68, 68, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-light .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-light .tab-item.tab-item-active, .tabs-striped.tabs-light .tab-item.active, .tabs-striped.tabs-light .tab-item.activated {\n    margin-top: -2px;\n    color: #444;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #444; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-stable .tabs {\n  background-color: #FF0D6D; }\n\n.tabs-striped.tabs-stable .tab-item {\n  color: rgba(68, 68, 68, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-stable .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-stable .tab-item.tab-item-active, .tabs-striped.tabs-stable .tab-item.active, .tabs-striped.tabs-stable .tab-item.activated {\n    margin-top: -2px;\n    color: #444;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #444; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-positive .tabs {\n  background-color: #387ef5; }\n\n.tabs-striped.tabs-positive .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-positive .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-positive .tab-item.tab-item-active, .tabs-striped.tabs-positive .tab-item.active, .tabs-striped.tabs-positive .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-calm .tabs {\n  background-color: #FE7D18; }\n\n.tabs-striped.tabs-calm .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-calm .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-calm .tab-item.tab-item-active, .tabs-striped.tabs-calm .tab-item.active, .tabs-striped.tabs-calm .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-assertive .tabs {\n  background-color: #ef473a; }\n\n.tabs-striped.tabs-assertive .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-assertive .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-assertive .tab-item.tab-item-active, .tabs-striped.tabs-assertive .tab-item.active, .tabs-striped.tabs-assertive .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-balanced .tabs {\n  background-color: #33cd5f; }\n\n.tabs-striped.tabs-balanced .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-balanced .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-balanced .tab-item.tab-item-active, .tabs-striped.tabs-balanced .tab-item.active, .tabs-striped.tabs-balanced .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-energized .tabs {\n  background-color: #ffc900; }\n\n.tabs-striped.tabs-energized .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-energized .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-energized .tab-item.tab-item-active, .tabs-striped.tabs-energized .tab-item.active, .tabs-striped.tabs-energized .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-royal .tabs {\n  background-color: #886aea; }\n\n.tabs-striped.tabs-royal .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-royal .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-royal .tab-item.tab-item-active, .tabs-striped.tabs-royal .tab-item.active, .tabs-striped.tabs-royal .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-dark .tabs {\n  background-color: #444; }\n\n.tabs-striped.tabs-dark .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-dark .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-dark .tab-item.tab-item-active, .tabs-striped.tabs-dark .tab-item.active, .tabs-striped.tabs-dark .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border-style: solid;\n    border-width: 2px 0 0 0;\n    border-color: #fff; }\n\n.tabs-striped.tabs-top .tab-item.tab-item-active .badge, .tabs-striped.tabs-top .tab-item.active .badge, .tabs-striped.tabs-top .tab-item.activated .badge {\n  top: 4%; }\n\n.tabs-striped.tabs-background-light .tabs {\n  background-color: #fff;\n  background-image: none; }\n\n.tabs-striped.tabs-background-stable .tabs {\n  background-color: #FF0D6D;\n  background-image: none; }\n\n.tabs-striped.tabs-background-positive .tabs {\n  background-color: #387ef5;\n  background-image: none; }\n\n.tabs-striped.tabs-background-calm .tabs {\n  background-color: #FE7D18;\n  background-image: none; }\n\n.tabs-striped.tabs-background-assertive .tabs {\n  background-color: #ef473a;\n  background-image: none; }\n\n.tabs-striped.tabs-background-balanced .tabs {\n  background-color: #33cd5f;\n  background-image: none; }\n\n.tabs-striped.tabs-background-energized .tabs {\n  background-color: #ffc900;\n  background-image: none; }\n\n.tabs-striped.tabs-background-royal .tabs {\n  background-color: #886aea;\n  background-image: none; }\n\n.tabs-striped.tabs-background-dark .tabs {\n  background-color: #444;\n  background-image: none; }\n\n.tabs-striped.tabs-color-light .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-light .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-light .tab-item.tab-item-active, .tabs-striped.tabs-color-light .tab-item.active, .tabs-striped.tabs-color-light .tab-item.activated {\n    margin-top: -2px;\n    color: #fff;\n    border: 0 solid #fff;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-light .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-light .tab-item.active .badge, .tabs-striped.tabs-color-light .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-stable .tab-item {\n  color: rgba(255, 13, 109, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-stable .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-stable .tab-item.tab-item-active, .tabs-striped.tabs-color-stable .tab-item.active, .tabs-striped.tabs-color-stable .tab-item.activated {\n    margin-top: -2px;\n    color: #FF0D6D;\n    border: 0 solid #FF0D6D;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-stable .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-stable .tab-item.active .badge, .tabs-striped.tabs-color-stable .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-positive .tab-item {\n  color: rgba(56, 126, 245, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-positive .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-positive .tab-item.tab-item-active, .tabs-striped.tabs-color-positive .tab-item.active, .tabs-striped.tabs-color-positive .tab-item.activated {\n    margin-top: -2px;\n    color: #387ef5;\n    border: 0 solid #387ef5;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-positive .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-positive .tab-item.active .badge, .tabs-striped.tabs-color-positive .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-calm .tab-item {\n  color: rgba(254, 125, 24, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-calm .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-calm .tab-item.tab-item-active, .tabs-striped.tabs-color-calm .tab-item.active, .tabs-striped.tabs-color-calm .tab-item.activated {\n    margin-top: -2px;\n    color: #FE7D18;\n    border: 0 solid #FE7D18;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-calm .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-calm .tab-item.active .badge, .tabs-striped.tabs-color-calm .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-assertive .tab-item {\n  color: rgba(239, 71, 58, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-assertive .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-assertive .tab-item.tab-item-active, .tabs-striped.tabs-color-assertive .tab-item.active, .tabs-striped.tabs-color-assertive .tab-item.activated {\n    margin-top: -2px;\n    color: #ef473a;\n    border: 0 solid #ef473a;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-assertive .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-assertive .tab-item.active .badge, .tabs-striped.tabs-color-assertive .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-balanced .tab-item {\n  color: rgba(51, 205, 95, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-balanced .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-balanced .tab-item.tab-item-active, .tabs-striped.tabs-color-balanced .tab-item.active, .tabs-striped.tabs-color-balanced .tab-item.activated {\n    margin-top: -2px;\n    color: #33cd5f;\n    border: 0 solid #33cd5f;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-balanced .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-balanced .tab-item.active .badge, .tabs-striped.tabs-color-balanced .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-energized .tab-item {\n  color: rgba(255, 201, 0, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-energized .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-energized .tab-item.tab-item-active, .tabs-striped.tabs-color-energized .tab-item.active, .tabs-striped.tabs-color-energized .tab-item.activated {\n    margin-top: -2px;\n    color: #ffc900;\n    border: 0 solid #ffc900;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-energized .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-energized .tab-item.active .badge, .tabs-striped.tabs-color-energized .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-royal .tab-item {\n  color: rgba(136, 106, 234, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-royal .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-royal .tab-item.tab-item-active, .tabs-striped.tabs-color-royal .tab-item.active, .tabs-striped.tabs-color-royal .tab-item.activated {\n    margin-top: -2px;\n    color: #886aea;\n    border: 0 solid #886aea;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-royal .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-royal .tab-item.active .badge, .tabs-striped.tabs-color-royal .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-striped.tabs-color-dark .tab-item {\n  color: rgba(68, 68, 68, 0.4);\n  opacity: 1; }\n  .tabs-striped.tabs-color-dark .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-striped.tabs-color-dark .tab-item.tab-item-active, .tabs-striped.tabs-color-dark .tab-item.active, .tabs-striped.tabs-color-dark .tab-item.activated {\n    margin-top: -2px;\n    color: #444;\n    border: 0 solid #444;\n    border-top-width: 2px; }\n    .tabs-striped.tabs-color-dark .tab-item.tab-item-active .badge, .tabs-striped.tabs-color-dark .tab-item.active .badge, .tabs-striped.tabs-color-dark .tab-item.activated .badge {\n      top: 2px;\n      opacity: 1; }\n\n.tabs-background-light .tabs,\n.tabs-background-light > .tabs {\n  background-color: #fff;\n  background-image: linear-gradient(0deg, #ddd, #ddd 50%, transparent 50%);\n  border-color: #ddd; }\n\n.tabs-background-stable .tabs,\n.tabs-background-stable > .tabs {\n  background-color: #FF0D6D;\n  background-image: linear-gradient(0deg, #b2b2b2, #b2b2b2 50%, transparent 50%);\n  border-color: #b2b2b2; }\n\n.tabs-background-positive .tabs,\n.tabs-background-positive > .tabs {\n  background-color: #387ef5;\n  background-image: linear-gradient(0deg, #0c60ee, #0c60ee 50%, transparent 50%);\n  border-color: #0c60ee; }\n\n.tabs-background-calm .tabs,\n.tabs-background-calm > .tabs {\n  background-color: #FE7D18;\n  background-image: linear-gradient(0deg, #e26401, #e26401 50%, transparent 50%);\n  border-color: #e26401; }\n\n.tabs-background-assertive .tabs,\n.tabs-background-assertive > .tabs {\n  background-color: #ef473a;\n  background-image: linear-gradient(0deg, #e42112, #e42112 50%, transparent 50%);\n  border-color: #e42112; }\n\n.tabs-background-balanced .tabs,\n.tabs-background-balanced > .tabs {\n  background-color: #33cd5f;\n  background-image: linear-gradient(0deg, #28a54c, #28a54c 50%, transparent 50%);\n  border-color: #28a54c; }\n\n.tabs-background-energized .tabs,\n.tabs-background-energized > .tabs {\n  background-color: #ffc900;\n  background-image: linear-gradient(0deg, #e6b500, #e6b500 50%, transparent 50%);\n  border-color: #e6b500; }\n\n.tabs-background-royal .tabs,\n.tabs-background-royal > .tabs {\n  background-color: #886aea;\n  background-image: linear-gradient(0deg, #6b46e5, #6b46e5 50%, transparent 50%);\n  border-color: #6b46e5; }\n\n.tabs-background-dark .tabs,\n.tabs-background-dark > .tabs {\n  background-color: #444;\n  background-image: linear-gradient(0deg, #111, #111 50%, transparent 50%);\n  border-color: #111; }\n\n.tabs-color-light .tab-item {\n  color: rgba(255, 255, 255, 0.4);\n  opacity: 1; }\n  .tabs-color-light .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-light .tab-item.tab-item-active, .tabs-color-light .tab-item.active, .tabs-color-light .tab-item.activated {\n    color: #fff;\n    border: 0 solid #fff; }\n    .tabs-color-light .tab-item.tab-item-active .badge, .tabs-color-light .tab-item.active .badge, .tabs-color-light .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-stable .tab-item {\n  color: rgba(255, 13, 109, 0.4);\n  opacity: 1; }\n  .tabs-color-stable .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-stable .tab-item.tab-item-active, .tabs-color-stable .tab-item.active, .tabs-color-stable .tab-item.activated {\n    color: #FF0D6D;\n    border: 0 solid #FF0D6D; }\n    .tabs-color-stable .tab-item.tab-item-active .badge, .tabs-color-stable .tab-item.active .badge, .tabs-color-stable .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-positive .tab-item {\n  color: rgba(56, 126, 245, 0.4);\n  opacity: 1; }\n  .tabs-color-positive .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-positive .tab-item.tab-item-active, .tabs-color-positive .tab-item.active, .tabs-color-positive .tab-item.activated {\n    color: #387ef5;\n    border: 0 solid #387ef5; }\n    .tabs-color-positive .tab-item.tab-item-active .badge, .tabs-color-positive .tab-item.active .badge, .tabs-color-positive .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-calm .tab-item {\n  color: rgba(254, 125, 24, 0.4);\n  opacity: 1; }\n  .tabs-color-calm .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-calm .tab-item.tab-item-active, .tabs-color-calm .tab-item.active, .tabs-color-calm .tab-item.activated {\n    color: #FE7D18;\n    border: 0 solid #FE7D18; }\n    .tabs-color-calm .tab-item.tab-item-active .badge, .tabs-color-calm .tab-item.active .badge, .tabs-color-calm .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-assertive .tab-item {\n  color: rgba(239, 71, 58, 0.4);\n  opacity: 1; }\n  .tabs-color-assertive .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-assertive .tab-item.tab-item-active, .tabs-color-assertive .tab-item.active, .tabs-color-assertive .tab-item.activated {\n    color: #ef473a;\n    border: 0 solid #ef473a; }\n    .tabs-color-assertive .tab-item.tab-item-active .badge, .tabs-color-assertive .tab-item.active .badge, .tabs-color-assertive .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-balanced .tab-item {\n  color: rgba(51, 205, 95, 0.4);\n  opacity: 1; }\n  .tabs-color-balanced .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-balanced .tab-item.tab-item-active, .tabs-color-balanced .tab-item.active, .tabs-color-balanced .tab-item.activated {\n    color: #33cd5f;\n    border: 0 solid #33cd5f; }\n    .tabs-color-balanced .tab-item.tab-item-active .badge, .tabs-color-balanced .tab-item.active .badge, .tabs-color-balanced .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-energized .tab-item {\n  color: rgba(255, 201, 0, 0.4);\n  opacity: 1; }\n  .tabs-color-energized .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-energized .tab-item.tab-item-active, .tabs-color-energized .tab-item.active, .tabs-color-energized .tab-item.activated {\n    color: #ffc900;\n    border: 0 solid #ffc900; }\n    .tabs-color-energized .tab-item.tab-item-active .badge, .tabs-color-energized .tab-item.active .badge, .tabs-color-energized .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-royal .tab-item {\n  color: rgba(136, 106, 234, 0.4);\n  opacity: 1; }\n  .tabs-color-royal .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-royal .tab-item.tab-item-active, .tabs-color-royal .tab-item.active, .tabs-color-royal .tab-item.activated {\n    color: #886aea;\n    border: 0 solid #886aea; }\n    .tabs-color-royal .tab-item.tab-item-active .badge, .tabs-color-royal .tab-item.active .badge, .tabs-color-royal .tab-item.activated .badge {\n      opacity: 1; }\n\n.tabs-color-dark .tab-item {\n  color: rgba(68, 68, 68, 0.4);\n  opacity: 1; }\n  .tabs-color-dark .tab-item .badge {\n    opacity: 0.4; }\n  .tabs-color-dark .tab-item.tab-item-active, .tabs-color-dark .tab-item.active, .tabs-color-dark .tab-item.activated {\n    color: #444;\n    border: 0 solid #444; }\n    .tabs-color-dark .tab-item.tab-item-active .badge, .tabs-color-dark .tab-item.active .badge, .tabs-color-dark .tab-item.activated .badge {\n      opacity: 1; }\n\nion-tabs.tabs-color-active-light .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-light .tab-item.tab-item-active, ion-tabs.tabs-color-active-light .tab-item.active, ion-tabs.tabs-color-active-light .tab-item.activated {\n    color: #fff; }\n\nion-tabs.tabs-color-active-stable .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-stable .tab-item.tab-item-active, ion-tabs.tabs-color-active-stable .tab-item.active, ion-tabs.tabs-color-active-stable .tab-item.activated {\n    color: #FF0D6D; }\n\nion-tabs.tabs-color-active-positive .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-positive .tab-item.tab-item-active, ion-tabs.tabs-color-active-positive .tab-item.active, ion-tabs.tabs-color-active-positive .tab-item.activated {\n    color: #387ef5; }\n\nion-tabs.tabs-color-active-calm .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-calm .tab-item.tab-item-active, ion-tabs.tabs-color-active-calm .tab-item.active, ion-tabs.tabs-color-active-calm .tab-item.activated {\n    color: #FE7D18; }\n\nion-tabs.tabs-color-active-assertive .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-assertive .tab-item.tab-item-active, ion-tabs.tabs-color-active-assertive .tab-item.active, ion-tabs.tabs-color-active-assertive .tab-item.activated {\n    color: #ef473a; }\n\nion-tabs.tabs-color-active-balanced .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-balanced .tab-item.tab-item-active, ion-tabs.tabs-color-active-balanced .tab-item.active, ion-tabs.tabs-color-active-balanced .tab-item.activated {\n    color: #33cd5f; }\n\nion-tabs.tabs-color-active-energized .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-energized .tab-item.tab-item-active, ion-tabs.tabs-color-active-energized .tab-item.active, ion-tabs.tabs-color-active-energized .tab-item.activated {\n    color: #ffc900; }\n\nion-tabs.tabs-color-active-royal .tab-item {\n  color: #444; }\n  ion-tabs.tabs-color-active-royal .tab-item.tab-item-active, ion-tabs.tabs-color-active-royal .tab-item.active, ion-tabs.tabs-color-active-royal .tab-item.activated {\n    color: #886aea; }\n\nion-tabs.tabs-color-active-dark .tab-item {\n  color: #fff; }\n  ion-tabs.tabs-color-active-dark .tab-item.tab-item-active, ion-tabs.tabs-color-active-dark .tab-item.active, ion-tabs.tabs-color-active-dark .tab-item.activated {\n    color: #444; }\n\n.tabs-top.tabs-striped {\n  padding-bottom: 0; }\n  .tabs-top.tabs-striped .tab-item {\n    background: transparent;\n    -webkit-transition: all .1s ease;\n    -moz-transition: all .1s ease;\n    -ms-transition: all .1s ease;\n    -o-transition: all .1s ease;\n    transition: all .1s ease; }\n    .tabs-top.tabs-striped .tab-item.tab-item-active, .tabs-top.tabs-striped .tab-item.active, .tabs-top.tabs-striped .tab-item.activated {\n      margin-top: 0;\n      margin-bottom: -2px;\n      border-width: 0px 0px 2px 0px !important;\n      border-style: solid; }\n    .tabs-top.tabs-striped .tab-item .badge {\n      -webkit-transition: all .2s ease;\n      -moz-transition: all .2s ease;\n      -ms-transition: all .2s ease;\n      -o-transition: all .2s ease;\n      transition: all .2s ease; }\n\n/* Allow parent element to have tabs-top */\n/* If you change this, change platform.scss as well */\n.tabs-top > .tabs,\n.tabs.tabs-top {\n  top: 44px;\n  padding-top: 0;\n  background-position: bottom;\n  border-top-width: 0;\n  border-bottom-width: 1px; }\n  .tabs-top > .tabs .tab-item.tab-item-active .badge, .tabs-top > .tabs .tab-item.active .badge, .tabs-top > .tabs .tab-item.activated .badge,\n  .tabs.tabs-top .tab-item.tab-item-active .badge,\n  .tabs.tabs-top .tab-item.active .badge,\n  .tabs.tabs-top .tab-item.activated .badge {\n    top: 4%; }\n\n.tabs-top ~ .bar-header {\n  border-bottom-width: 0; }\n\n.tab-item {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -moz-box-flex: 1;\n  -moz-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  display: block;\n  overflow: hidden;\n  max-width: 150px;\n  height: 100%;\n  color: inherit;\n  text-align: center;\n  text-decoration: none;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-weight: 400;\n  font-size: 14px;\n  font-family: \"Helvetica Neue\", \"Roboto\", sans-serif;\n  opacity: 0.7; }\n  .tab-item:hover {\n    cursor: pointer; }\n  .tab-item.tab-hidden {\n    display: none; }\n\n.tabs-item-hide > .tabs,\n.tabs.tabs-item-hide {\n  display: none; }\n\n.tabs-icon-top > .tabs .tab-item,\n.tabs-icon-top.tabs .tab-item,\n.tabs-icon-bottom > .tabs .tab-item,\n.tabs-icon-bottom.tabs .tab-item {\n  font-size: 10px;\n  line-height: 14px; }\n\n.tab-item .icon {\n  display: block;\n  margin: 0 auto;\n  height: 32px;\n  font-size: 32px; }\n\n.tabs-icon-left.tabs .tab-item,\n.tabs-icon-left > .tabs .tab-item,\n.tabs-icon-right.tabs .tab-item,\n.tabs-icon-right > .tabs .tab-item {\n  font-size: 10px; }\n  .tabs-icon-left.tabs .tab-item .icon,\n  .tabs-icon-left > .tabs .tab-item .icon,\n  .tabs-icon-right.tabs .tab-item .icon,\n  .tabs-icon-right > .tabs .tab-item .icon {\n    display: inline-block;\n    vertical-align: top;\n    margin-top: -.1em; }\n    .tabs-icon-left.tabs .tab-item .icon:before,\n    .tabs-icon-left > .tabs .tab-item .icon:before,\n    .tabs-icon-right.tabs .tab-item .icon:before,\n    .tabs-icon-right > .tabs .tab-item .icon:before {\n      font-size: 24px;\n      line-height: 49px; }\n\n.tabs-icon-left > .tabs .tab-item .icon,\n.tabs-icon-left.tabs .tab-item .icon {\n  padding-right: 3px; }\n\n.tabs-icon-right > .tabs .tab-item .icon,\n.tabs-icon-right.tabs .tab-item .icon {\n  padding-left: 3px; }\n\n.tabs-icon-only > .tabs .icon,\n.tabs-icon-only.tabs .icon {\n  line-height: inherit; }\n\n.tab-item.has-badge {\n  position: relative; }\n\n.tab-item .badge {\n  position: absolute;\n  top: 4%;\n  right: 33%;\n  right: calc(50% - 26px);\n  padding: 1px 6px;\n  height: auto;\n  font-size: 12px;\n  line-height: 16px; }\n\n/* Navigational tab */\n/* Active state for tab */\n.tab-item.tab-item-active,\n.tab-item.active,\n.tab-item.activated {\n  opacity: 1; }\n  .tab-item.tab-item-active.tab-item-light,\n  .tab-item.active.tab-item-light,\n  .tab-item.activated.tab-item-light {\n    color: #fff; }\n  .tab-item.tab-item-active.tab-item-stable,\n  .tab-item.active.tab-item-stable,\n  .tab-item.activated.tab-item-stable {\n    color: #FF0D6D; }\n  .tab-item.tab-item-active.tab-item-positive,\n  .tab-item.active.tab-item-positive,\n  .tab-item.activated.tab-item-positive {\n    color: #387ef5; }\n  .tab-item.tab-item-active.tab-item-calm,\n  .tab-item.active.tab-item-calm,\n  .tab-item.activated.tab-item-calm {\n    color: #FE7D18; }\n  .tab-item.tab-item-active.tab-item-assertive,\n  .tab-item.active.tab-item-assertive,\n  .tab-item.activated.tab-item-assertive {\n    color: #ef473a; }\n  .tab-item.tab-item-active.tab-item-balanced,\n  .tab-item.active.tab-item-balanced,\n  .tab-item.activated.tab-item-balanced {\n    color: #33cd5f; }\n  .tab-item.tab-item-active.tab-item-energized,\n  .tab-item.active.tab-item-energized,\n  .tab-item.activated.tab-item-energized {\n    color: #ffc900; }\n  .tab-item.tab-item-active.tab-item-royal,\n  .tab-item.active.tab-item-royal,\n  .tab-item.activated.tab-item-royal {\n    color: #886aea; }\n  .tab-item.tab-item-active.tab-item-dark,\n  .tab-item.active.tab-item-dark,\n  .tab-item.activated.tab-item-dark {\n    color: #444; }\n\n.item.tabs {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  padding: 0; }\n  .item.tabs .icon:before {\n    position: relative; }\n\n.tab-item.disabled,\n.tab-item[disabled] {\n  opacity: .4;\n  cursor: default;\n  pointer-events: none; }\n\n/**\n * Menus\n * --------------------------------------------------\n * Side panel structure\n */\n.menu {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  z-index: 0;\n  overflow: hidden;\n  min-height: 100%;\n  max-height: 100%;\n  width: 275px;\n  background-color: #fff; }\n  .menu .scroll-content {\n    z-index: 10; }\n  .menu .bar-header {\n    z-index: 11; }\n\n.menu-content {\n  -webkit-transform: none;\n  transform: none;\n  box-shadow: -1px 0px 2px rgba(0, 0, 0, 0.2), 1px 0px 2px rgba(0, 0, 0, 0.2); }\n\n.menu-open .menu-content .pane,\n.menu-open .menu-content .scroll-content {\n  pointer-events: none; }\n\n.grade-b .menu-content,\n.grade-c .menu-content {\n  -webkit-box-sizing: content-box;\n  -moz-box-sizing: content-box;\n  box-sizing: content-box;\n  right: -1px;\n  left: -1px;\n  border-right: 1px solid #ccc;\n  border-left: 1px solid #ccc;\n  box-shadow: none; }\n\n.menu-left {\n  left: 0; }\n\n.menu-right {\n  right: 0; }\n\n.aside-open.aside-resizing .menu-right {\n  display: none; }\n\n.menu-animated {\n  -webkit-transition: -webkit-transform 200ms ease;\n  transition: transform 200ms ease; }\n\n/**\n * Modals\n * --------------------------------------------------\n * Modals are independent windows that slide in from off-screen.\n */\n.modal-backdrop {\n  -webkit-transition: background-color 300ms ease-in-out;\n  transition: background-color 300ms ease-in-out;\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 10;\n  width: 100%;\n  height: 100%;\n  background-color: rgba(0, 0, 0, 0); }\n  .modal-backdrop.active {\n    background-color: rgba(0, 0, 0, 0.5); }\n\n.modal {\n  display: block;\n  position: absolute;\n  top: 0;\n  z-index: 10;\n  overflow: hidden;\n  min-height: 100%;\n  width: 100%;\n  background-color: #fff; }\n\n@media (min-width: 680px) {\n  .modal {\n    top: 20%;\n    right: 20%;\n    bottom: 20%;\n    left: 20%;\n    overflow: visible;\n    min-height: 240px;\n    width: 60%; }\n  .modal.ng-leave-active {\n    bottom: 0; }\n  .platform-ios.platform-cordova .modal-wrapper .modal .bar-header:not(.bar-subheader) {\n    height: 44px; }\n    .platform-ios.platform-cordova .modal-wrapper .modal .bar-header:not(.bar-subheader) > * {\n      margin-top: 0; }\n  .platform-ios.platform-cordova .modal-wrapper .modal .tabs-top > .tabs,\n  .platform-ios.platform-cordova .modal-wrapper .modal .tabs.tabs-top {\n    top: 44px; }\n  .platform-ios.platform-cordova .modal-wrapper .modal .has-header,\n  .platform-ios.platform-cordova .modal-wrapper .modal .bar-subheader {\n    top: 44px; }\n  .platform-ios.platform-cordova .modal-wrapper .modal .has-subheader {\n    top: 88px; }\n  .platform-ios.platform-cordova .modal-wrapper .modal .has-tabs-top {\n    top: 93px; }\n  .platform-ios.platform-cordova .modal-wrapper .modal .has-header.has-subheader.has-tabs-top {\n    top: 137px; } }\n\n.modal-open {\n  pointer-events: none; }\n  .modal-open .modal,\n  .modal-open .modal-backdrop {\n    pointer-events: auto; }\n  .modal-open.loading-active .modal,\n  .modal-open.loading-active .modal-backdrop {\n    pointer-events: none; }\n\n/**\n * Popovers\n * --------------------------------------------------\n * Popovers are independent views which float over content\n */\n.popover-backdrop {\n  position: fixed;\n  top: 0;\n  left: 0;\n  z-index: 10;\n  width: 100%;\n  height: 100%;\n  background-color: rgba(0, 0, 0, 0); }\n  .popover-backdrop.active {\n    background-color: rgba(0, 0, 0, 0.1); }\n\n.popover {\n  position: absolute;\n  top: 25%;\n  left: 50%;\n  z-index: 10;\n  display: block;\n  margin-top: 12px;\n  margin-left: -110px;\n  height: 280px;\n  width: 220px;\n  background-color: #fff;\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.4);\n  opacity: 0; }\n  .popover .item:first-child {\n    border-top: 0; }\n  .popover .item:last-child {\n    border-bottom: 0; }\n  .popover.popover-bottom {\n    margin-top: -12px; }\n\n.popover,\n.popover .bar-header {\n  border-radius: 2px; }\n\n.popover .scroll-content {\n  z-index: 1;\n  margin: 2px 0; }\n\n.popover .bar-header {\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0; }\n\n.popover .has-header {\n  border-top-right-radius: 0;\n  border-top-left-radius: 0; }\n\n.popover-arrow {\n  display: none; }\n\n.platform-ios .popover {\n  box-shadow: 0 0 40px rgba(0, 0, 0, 0.08); }\n\n.platform-ios .popover,\n.platform-ios .popover .bar-header {\n  border-radius: 10px; }\n\n.platform-ios .popover .scroll-content {\n  margin: 8px 0;\n  border-radius: 10px; }\n\n.platform-ios .popover .scroll-content.has-header {\n  margin-top: 0; }\n\n.platform-ios .popover-arrow {\n  position: absolute;\n  display: block;\n  top: -17px;\n  width: 30px;\n  height: 19px;\n  overflow: hidden; }\n  .platform-ios .popover-arrow:after {\n    position: absolute;\n    top: 12px;\n    left: 5px;\n    width: 20px;\n    height: 20px;\n    background-color: #fff;\n    border-radius: 3px;\n    content: '';\n    -webkit-transform: rotate(-45deg);\n    transform: rotate(-45deg); }\n\n.platform-ios .popover-bottom .popover-arrow {\n  top: auto;\n  bottom: -10px; }\n  .platform-ios .popover-bottom .popover-arrow:after {\n    top: -6px; }\n\n.platform-android .popover {\n  margin-top: -32px;\n  background-color: #fafafa;\n  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.35); }\n  .platform-android .popover .item {\n    border-color: #fafafa;\n    background-color: #fafafa;\n    color: #4d4d4d; }\n  .platform-android .popover.popover-bottom {\n    margin-top: 32px; }\n\n.platform-android .popover-backdrop,\n.platform-android .popover-backdrop.active {\n  background-color: transparent; }\n\n.popover-open {\n  pointer-events: none; }\n  .popover-open .popover,\n  .popover-open .popover-backdrop {\n    pointer-events: auto; }\n  .popover-open.loading-active .popover,\n  .popover-open.loading-active .popover-backdrop {\n    pointer-events: none; }\n\n@media (min-width: 680px) {\n  .popover {\n    width: 360px; } }\n\n/**\n * Popups\n * --------------------------------------------------\n */\n.popup-container {\n  position: absolute;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  right: 0;\n  background: rgba(0, 0, 0, 0);\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  -webkit-justify-content: center;\n  -moz-justify-content: center;\n  justify-content: center;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  z-index: 12;\n  visibility: hidden; }\n  .popup-container.popup-showing {\n    visibility: visible; }\n  .popup-container.popup-hidden .popup {\n    -webkit-animation-name: scaleOut;\n    animation-name: scaleOut;\n    -webkit-animation-duration: 0.1s;\n    animation-duration: 0.1s;\n    -webkit-animation-timing-function: ease-in-out;\n    animation-timing-function: ease-in-out;\n    -webkit-animation-fill-mode: both;\n    animation-fill-mode: both; }\n  .popup-container.active .popup {\n    -webkit-animation-name: superScaleIn;\n    animation-name: superScaleIn;\n    -webkit-animation-duration: 0.2s;\n    animation-duration: 0.2s;\n    -webkit-animation-timing-function: ease-in-out;\n    animation-timing-function: ease-in-out;\n    -webkit-animation-fill-mode: both;\n    animation-fill-mode: both; }\n  .popup-container .popup {\n    width: 250px;\n    max-width: 100%;\n    max-height: 90%;\n    border-radius: 0px;\n    background-color: rgba(255, 255, 255, 0.9);\n    display: -webkit-box;\n    display: -webkit-flex;\n    display: -moz-box;\n    display: -moz-flex;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-direction: normal;\n    -webkit-box-orient: vertical;\n    -webkit-flex-direction: column;\n    -moz-flex-direction: column;\n    -ms-flex-direction: column;\n    flex-direction: column; }\n\n.popup-head {\n  padding: 15px 10px;\n  border-bottom: 1px solid #eee;\n  text-align: center; }\n\n.popup-title {\n  margin: 0;\n  padding: 0;\n  font-size: 15px; }\n\n.popup-sub-title {\n  margin: 5px 0 0 0;\n  padding: 0;\n  font-weight: normal;\n  font-size: 11px; }\n\n.popup-body {\n  padding: 10px;\n  overflow: scroll; }\n\n.popup-buttons {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-direction: normal;\n  -webkit-box-orient: horizontal;\n  -webkit-flex-direction: row;\n  -moz-flex-direction: row;\n  -ms-flex-direction: row;\n  flex-direction: row;\n  padding: 10px;\n  min-height: 65px; }\n  .popup-buttons .button {\n    -webkit-box-flex: 1;\n    -webkit-flex: 1;\n    -moz-box-flex: 1;\n    -moz-flex: 1;\n    -ms-flex: 1;\n    flex: 1;\n    display: block;\n    min-height: 45px;\n    border-radius: 2px;\n    line-height: 20px;\n    margin-right: 5px; }\n    .popup-buttons .button:last-child {\n      margin-right: 0px; }\n\n.popup-open {\n  pointer-events: none; }\n  .popup-open.modal-open .modal {\n    pointer-events: none; }\n  .popup-open .popup-backdrop, .popup-open .popup {\n    pointer-events: auto; }\n\n/**\n * Loading\n * --------------------------------------------------\n */\n.loading-container {\n  position: absolute;\n  left: 0;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 13;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  -webkit-justify-content: center;\n  -moz-justify-content: center;\n  justify-content: center;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  -webkit-transition: 0.2s opacity linear;\n  transition: 0.2s opacity linear;\n  visibility: hidden;\n  opacity: 0; }\n  .loading-container:not(.visible) .icon {\n    display: none; }\n  .loading-container.visible {\n    visibility: visible; }\n  .loading-container.active {\n    opacity: 1; }\n  .loading-container .loading {\n    padding: 20px;\n    border-radius: 5px;\n    background-color: rgba(0, 0, 0, 0.7);\n    color: #fff;\n    text-align: center;\n    text-overflow: ellipsis;\n    font-size: 15px; }\n    .loading-container .loading h1, .loading-container .loading h2, .loading-container .loading h3, .loading-container .loading h4, .loading-container .loading h5, .loading-container .loading h6 {\n      color: #fff; }\n\n/**\n * Items\n * --------------------------------------------------\n */\n.item {\n  border-color: #ddd;\n  background-color: #fff;\n  color: #444;\n  position: relative;\n  z-index: 2;\n  display: block;\n  margin: -1px;\n  padding: 16px;\n  border-width: 1px;\n  border-style: solid;\n  font-size: 16px; }\n  .item h2 {\n    margin: 0 0 2px 0;\n    font-size: 16px;\n    font-weight: normal; }\n  .item h3 {\n    margin: 0 0 4px 0;\n    font-size: 14px; }\n  .item h4 {\n    margin: 0 0 4px 0;\n    font-size: 12px; }\n  .item h5, .item h6 {\n    margin: 0 0 3px 0;\n    font-size: 10px; }\n  .item p {\n    color: #666;\n    font-size: 14px;\n    margin-bottom: 2px; }\n  .item h1:last-child,\n  .item h2:last-child,\n  .item h3:last-child,\n  .item h4:last-child,\n  .item h5:last-child,\n  .item h6:last-child,\n  .item p:last-child {\n    margin-bottom: 0; }\n  .item .badge {\n    display: -webkit-box;\n    display: -webkit-flex;\n    display: -moz-box;\n    display: -moz-flex;\n    display: -ms-flexbox;\n    display: flex;\n    position: absolute;\n    top: 16px;\n    right: 32px; }\n  .item.item-button-right .badge {\n    right: 67px; }\n  .item.item-divider .badge {\n    top: 8px; }\n  .item .badge + .badge {\n    margin-right: 5px; }\n  .item.item-light {\n    border-color: #ddd;\n    background-color: #fff;\n    color: #444; }\n  .item.item-stable {\n    border-color: #b2b2b2;\n    background-color: #FF0D6D;\n    color: #FFFFFF; }\n  .item.item-positive {\n    border-color: #0c60ee;\n    background-color: #387ef5;\n    color: #fff; }\n  .item.item-calm {\n    border-color: #e26401;\n    background-color: #FE7D18;\n    color: #fff; }\n  .item.item-assertive {\n    border-color: #e42112;\n    background-color: #ef473a;\n    color: #fff; }\n  .item.item-balanced {\n    border-color: #28a54c;\n    background-color: #33cd5f;\n    color: #fff; }\n  .item.item-energized {\n    border-color: #e6b500;\n    background-color: #ffc900;\n    color: #fff; }\n  .item.item-royal {\n    border-color: #6b46e5;\n    background-color: #886aea;\n    color: #fff; }\n  .item.item-dark {\n    border-color: #111;\n    background-color: #444;\n    color: #fff; }\n  .item[ng-click]:hover {\n    cursor: pointer; }\n\n.list-borderless .item,\n.item-borderless {\n  border-width: 0; }\n\n.item.active,\n.item.activated,\n.item-complex.active .item-content,\n.item-complex.activated .item-content,\n.item .item-content.active,\n.item .item-content.activated {\n  border-color: #ccc;\n  background-color: #D9D9D9; }\n  .item.active.item-light,\n  .item.activated.item-light,\n  .item-complex.active .item-content.item-light,\n  .item-complex.activated .item-content.item-light,\n  .item .item-content.active.item-light,\n  .item .item-content.activated.item-light {\n    border-color: #ccc;\n    background-color: #fafafa; }\n  .item.active.item-stable,\n  .item.activated.item-stable,\n  .item-complex.active .item-content.item-stable,\n  .item-complex.activated .item-content.item-stable,\n  .item .item-content.active.item-stable,\n  .item .item-content.activated.item-stable {\n    border-color: #a2a2a2;\n    background-color: #e5e5e5; }\n  .item.active.item-positive,\n  .item.activated.item-positive,\n  .item-complex.active .item-content.item-positive,\n  .item-complex.activated .item-content.item-positive,\n  .item .item-content.active.item-positive,\n  .item .item-content.activated.item-positive {\n    border-color: #0c60ee;\n    background-color: #0c60ee; }\n  .item.active.item-calm,\n  .item.activated.item-calm,\n  .item-complex.active .item-content.item-calm,\n  .item-complex.activated .item-content.item-calm,\n  .item .item-content.active.item-calm,\n  .item .item-content.activated.item-calm {\n    border-color: #e26401;\n    background-color: #e26401; }\n  .item.active.item-assertive,\n  .item.activated.item-assertive,\n  .item-complex.active .item-content.item-assertive,\n  .item-complex.activated .item-content.item-assertive,\n  .item .item-content.active.item-assertive,\n  .item .item-content.activated.item-assertive {\n    border-color: #e42112;\n    background-color: #e42112; }\n  .item.active.item-balanced,\n  .item.activated.item-balanced,\n  .item-complex.active .item-content.item-balanced,\n  .item-complex.activated .item-content.item-balanced,\n  .item .item-content.active.item-balanced,\n  .item .item-content.activated.item-balanced {\n    border-color: #28a54c;\n    background-color: #28a54c; }\n  .item.active.item-energized,\n  .item.activated.item-energized,\n  .item-complex.active .item-content.item-energized,\n  .item-complex.activated .item-content.item-energized,\n  .item .item-content.active.item-energized,\n  .item .item-content.activated.item-energized {\n    border-color: #e6b500;\n    background-color: #e6b500; }\n  .item.active.item-royal,\n  .item.activated.item-royal,\n  .item-complex.active .item-content.item-royal,\n  .item-complex.activated .item-content.item-royal,\n  .item .item-content.active.item-royal,\n  .item .item-content.activated.item-royal {\n    border-color: #6b46e5;\n    background-color: #6b46e5; }\n  .item.active.item-dark,\n  .item.activated.item-dark,\n  .item-complex.active .item-content.item-dark,\n  .item-complex.activated .item-content.item-dark,\n  .item .item-content.active.item-dark,\n  .item .item-content.activated.item-dark {\n    border-color: #000;\n    background-color: #262626; }\n\n.item,\n.item h1,\n.item h2,\n.item h3,\n.item h4,\n.item h5,\n.item h6,\n.item p,\n.item-content,\n.item-content h1,\n.item-content h2,\n.item-content h3,\n.item-content h4,\n.item-content h5,\n.item-content h6,\n.item-content p {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap; }\n\na.item {\n  color: inherit;\n  text-decoration: none; }\n  a.item:hover, a.item:focus {\n    text-decoration: none; }\n\n/**\n * Complex Items\n * --------------------------------------------------\n * Adding .item-complex allows the .item to be slidable and\n * have options underneath the button, but also requires an\n * additional .item-content element inside .item.\n * Basically .item-complex removes any default settings which\n * .item added, so that .item-content looks them as just .item.\n */\n.item-complex,\na.item.item-complex,\nbutton.item.item-complex {\n  padding: 0; }\n\n.item-complex .item-content,\n.item-radio .item-content {\n  position: relative;\n  z-index: 2;\n  padding: 16px 49px 16px 16px;\n  border: none;\n  background-color: white; }\n\na.item-content {\n  display: block;\n  color: inherit;\n  text-decoration: none; }\n\n.item-text-wrap .item,\n.item-text-wrap .item-content,\n.item-text-wrap,\n.item-text-wrap h1,\n.item-text-wrap h2,\n.item-text-wrap h3,\n.item-text-wrap h4,\n.item-text-wrap h5,\n.item-text-wrap h6,\n.item-text-wrap p,\n.item-complex.item-text-wrap .item-content,\n.item-body h1,\n.item-body h2,\n.item-body h3,\n.item-body h4,\n.item-body h5,\n.item-body h6,\n.item-body p {\n  overflow: visible;\n  white-space: normal; }\n\n.item-complex.item-text-wrap,\n.item-complex.item-text-wrap h1,\n.item-complex.item-text-wrap h2,\n.item-complex.item-text-wrap h3,\n.item-complex.item-text-wrap h4,\n.item-complex.item-text-wrap h5,\n.item-complex.item-text-wrap h6,\n.item-complex.item-text-wrap p {\n  overflow: visible;\n  white-space: normal; }\n\n.item-complex.item-light > .item-content {\n  border-color: #ddd;\n  background-color: #fff;\n  color: #444; }\n  .item-complex.item-light > .item-content.active, .item-complex.item-light > .item-content:active {\n    border-color: #ccc;\n    background-color: #fafafa; }\n\n.item-complex.item-stable > .item-content {\n  border-color: #b2b2b2;\n  background-color: #FF0D6D;\n  color: #FFFFFF; }\n  .item-complex.item-stable > .item-content.active, .item-complex.item-stable > .item-content:active {\n    border-color: #a2a2a2;\n    background-color: #e5e5e5; }\n\n.item-complex.item-positive > .item-content {\n  border-color: #0c60ee;\n  background-color: #387ef5;\n  color: #fff; }\n  .item-complex.item-positive > .item-content.active, .item-complex.item-positive > .item-content:active {\n    border-color: #0c60ee;\n    background-color: #0c60ee; }\n\n.item-complex.item-calm > .item-content {\n  border-color: #e26401;\n  background-color: #FE7D18;\n  color: #fff; }\n  .item-complex.item-calm > .item-content.active, .item-complex.item-calm > .item-content:active {\n    border-color: #e26401;\n    background-color: #e26401; }\n\n.item-complex.item-assertive > .item-content {\n  border-color: #e42112;\n  background-color: #ef473a;\n  color: #fff; }\n  .item-complex.item-assertive > .item-content.active, .item-complex.item-assertive > .item-content:active {\n    border-color: #e42112;\n    background-color: #e42112; }\n\n.item-complex.item-balanced > .item-content {\n  border-color: #28a54c;\n  background-color: #33cd5f;\n  color: #fff; }\n  .item-complex.item-balanced > .item-content.active, .item-complex.item-balanced > .item-content:active {\n    border-color: #28a54c;\n    background-color: #28a54c; }\n\n.item-complex.item-energized > .item-content {\n  border-color: #e6b500;\n  background-color: #ffc900;\n  color: #fff; }\n  .item-complex.item-energized > .item-content.active, .item-complex.item-energized > .item-content:active {\n    border-color: #e6b500;\n    background-color: #e6b500; }\n\n.item-complex.item-royal > .item-content {\n  border-color: #6b46e5;\n  background-color: #886aea;\n  color: #fff; }\n  .item-complex.item-royal > .item-content.active, .item-complex.item-royal > .item-content:active {\n    border-color: #6b46e5;\n    background-color: #6b46e5; }\n\n.item-complex.item-dark > .item-content {\n  border-color: #111;\n  background-color: #444;\n  color: #fff; }\n  .item-complex.item-dark > .item-content.active, .item-complex.item-dark > .item-content:active {\n    border-color: #000;\n    background-color: #262626; }\n\n/**\n * Item Icons\n * --------------------------------------------------\n */\n.item-icon-left .icon,\n.item-icon-right .icon {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  position: absolute;\n  top: 0;\n  height: 100%;\n  font-size: 32px; }\n  .item-icon-left .icon:before,\n  .item-icon-right .icon:before {\n    display: block;\n    width: 32px;\n    text-align: center; }\n\n.item .fill-icon {\n  min-width: 30px;\n  min-height: 30px;\n  font-size: 28px; }\n\n.item-icon-left {\n  padding-left: 54px; }\n  .item-icon-left .icon {\n    left: 11px; }\n\n.item-complex.item-icon-left {\n  padding-left: 0; }\n  .item-complex.item-icon-left .item-content {\n    padding-left: 54px; }\n\n.item-icon-right {\n  padding-right: 54px; }\n  .item-icon-right .icon {\n    right: 11px; }\n\n.item-complex.item-icon-right {\n  padding-right: 0; }\n  .item-complex.item-icon-right .item-content {\n    padding-right: 54px; }\n\n.item-icon-left.item-icon-right .icon:first-child {\n  right: auto; }\n\n.item-icon-left.item-icon-right .icon:last-child,\n.item-icon-left .item-delete .icon {\n  left: auto; }\n\n.item-icon-left .icon-accessory,\n.item-icon-right .icon-accessory {\n  color: #ccc;\n  font-size: 16px; }\n\n.item-icon-left .icon-accessory {\n  left: 3px; }\n\n.item-icon-right .icon-accessory {\n  right: 3px; }\n\n/**\n * Item Button\n * --------------------------------------------------\n * An item button is a child button inside an .item (not the entire .item)\n */\n.item-button-left {\n  padding-left: 72px; }\n\n.item-button-left > .button,\n.item-button-left .item-content > .button {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  position: absolute;\n  top: 8px;\n  left: 11px;\n  min-width: 34px;\n  min-height: 34px;\n  font-size: 18px;\n  line-height: 32px; }\n  .item-button-left > .button .icon:before,\n  .item-button-left .item-content > .button .icon:before {\n    position: relative;\n    left: auto;\n    width: auto;\n    line-height: 31px; }\n  .item-button-left > .button > .button,\n  .item-button-left .item-content > .button > .button {\n    margin: 0px 2px;\n    min-height: 34px;\n    font-size: 18px;\n    line-height: 32px; }\n\n.item-button-right,\na.item.item-button-right,\nbutton.item.item-button-right {\n  padding-right: 80px; }\n\n.item-button-right > .button,\n.item-button-right .item-content > .button,\n.item-button-right > .buttons,\n.item-button-right .item-content > .buttons {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  position: absolute;\n  top: 8px;\n  right: 16px;\n  min-width: 34px;\n  min-height: 34px;\n  font-size: 18px;\n  line-height: 32px; }\n  .item-button-right > .button .icon:before,\n  .item-button-right .item-content > .button .icon:before,\n  .item-button-right > .buttons .icon:before,\n  .item-button-right .item-content > .buttons .icon:before {\n    position: relative;\n    left: auto;\n    width: auto;\n    line-height: 31px; }\n  .item-button-right > .button > .button,\n  .item-button-right .item-content > .button > .button,\n  .item-button-right > .buttons > .button,\n  .item-button-right .item-content > .buttons > .button {\n    margin: 0px 2px;\n    min-width: 34px;\n    min-height: 34px;\n    font-size: 18px;\n    line-height: 32px; }\n\n.item-avatar,\n.item-avatar .item-content,\n.item-avatar-left,\n.item-avatar-left .item-content {\n  padding-left: 72px;\n  min-height: 72px; }\n  .item-avatar > img:first-child,\n  .item-avatar .item-image,\n  .item-avatar .item-content > img:first-child,\n  .item-avatar .item-content .item-image,\n  .item-avatar-left > img:first-child,\n  .item-avatar-left .item-image,\n  .item-avatar-left .item-content > img:first-child,\n  .item-avatar-left .item-content .item-image {\n    position: absolute;\n    top: 16px;\n    left: 16px;\n    max-width: 40px;\n    max-height: 40px;\n    width: 100%;\n    border-radius: 50%; }\n\n.item-avatar-right,\n.item-avatar-right .item-content {\n  padding-right: 72px;\n  min-height: 72px; }\n  .item-avatar-right > img:first-child,\n  .item-avatar-right .item-image,\n  .item-avatar-right .item-content > img:first-child,\n  .item-avatar-right .item-content .item-image {\n    position: absolute;\n    top: 16px;\n    right: 16px;\n    max-width: 40px;\n    max-height: 40px;\n    width: 100%;\n    border-radius: 50%; }\n\n.item-thumbnail-left,\n.item-thumbnail-left .item-content {\n  padding-top: 8px;\n  padding-left: 106px;\n  min-height: 100px; }\n  .item-thumbnail-left > img:first-child,\n  .item-thumbnail-left .item-image,\n  .item-thumbnail-left .item-content > img:first-child,\n  .item-thumbnail-left .item-content .item-image {\n    position: absolute;\n    top: 10px;\n    left: 10px;\n    max-width: 80px;\n    max-height: 80px;\n    width: 100%; }\n\n.item-avatar.item-complex,\n.item-avatar-left.item-complex,\n.item-thumbnail-left.item-complex {\n  padding-top: 0;\n  padding-left: 0; }\n\n.item-thumbnail-right,\n.item-thumbnail-right .item-content {\n  padding-top: 8px;\n  padding-right: 106px;\n  min-height: 100px; }\n  .item-thumbnail-right > img:first-child,\n  .item-thumbnail-right .item-image,\n  .item-thumbnail-right .item-content > img:first-child,\n  .item-thumbnail-right .item-content .item-image {\n    position: absolute;\n    top: 10px;\n    right: 10px;\n    max-width: 80px;\n    max-height: 80px;\n    width: 100%; }\n\n.item-avatar-right.item-complex,\n.item-thumbnail-right.item-complex {\n  padding-top: 0;\n  padding-right: 0; }\n\n.item-image {\n  padding: 0;\n  text-align: center; }\n  .item-image img:first-child, .item-image .list-img {\n    width: 100%;\n    vertical-align: middle; }\n\n.item-body {\n  overflow: auto;\n  padding: 16px;\n  text-overflow: inherit;\n  white-space: normal; }\n  .item-body h1, .item-body h2, .item-body h3, .item-body h4, .item-body h5, .item-body h6, .item-body p {\n    margin-top: 16px;\n    margin-bottom: 16px; }\n\n.item-divider {\n  padding-top: 8px;\n  padding-bottom: 8px;\n  min-height: 30px;\n  background-color: #f5f5f5;\n  color: #222;\n  font-weight: 500; }\n\n.platform-ios .item-divider-platform,\n.item-divider-ios {\n  padding-top: 26px;\n  text-transform: uppercase;\n  font-weight: 300;\n  font-size: 13px;\n  background-color: #efeff4;\n  color: #555; }\n\n.platform-android .item-divider-platform,\n.item-divider-android {\n  font-weight: 300;\n  font-size: 13px; }\n\n.item-note {\n  float: right;\n  color: #aaa;\n  font-size: 14px; }\n\n.item-left-editable .item-content,\n.item-right-editable .item-content {\n  -webkit-transition-duration: 250ms;\n  transition-duration: 250ms;\n  -webkit-transition-timing-function: ease-in-out;\n  transition-timing-function: ease-in-out;\n  -webkit-transition-property: -webkit-transform;\n  -moz-transition-property: -moz-transform;\n  transition-property: transform; }\n\n.list-left-editing .item-left-editable .item-content,\n.item-left-editing.item-left-editable .item-content {\n  -webkit-transform: translate3d(50px, 0, 0);\n  transform: translate3d(50px, 0, 0); }\n\n.list-right-editing .item-right-editable .item-content,\n.item-right-editing.item-right-editable .item-content {\n  -webkit-transform: translate3d(-50px, 0, 0);\n  transform: translate3d(-50px, 0, 0); }\n\n.item-remove-animate.ng-leave {\n  -webkit-transition-duration: 300ms;\n  transition-duration: 300ms; }\n\n.item-remove-animate.ng-leave .item-content, .item-remove-animate.ng-leave:last-of-type {\n  -webkit-transition-duration: 300ms;\n  transition-duration: 300ms;\n  -webkit-transition-timing-function: ease-in;\n  transition-timing-function: ease-in;\n  -webkit-transition-property: all;\n  transition-property: all; }\n\n.item-remove-animate.ng-leave.ng-leave-active .item-content {\n  opacity: 0;\n  -webkit-transform: translate3d(-100%, 0, 0) !important;\n  transform: translate3d(-100%, 0, 0) !important; }\n\n.item-remove-animate.ng-leave.ng-leave-active:last-of-type {\n  opacity: 0; }\n\n.item-remove-animate.ng-leave.ng-leave-active ~ ion-item:not(.ng-leave) {\n  -webkit-transform: translate3d(0, -webkit-calc(-100% + 1px), 0);\n  transform: translate3d(0, calc(-100% + 1px), 0);\n  -webkit-transition-duration: 300ms;\n  transition-duration: 300ms;\n  -webkit-transition-timing-function: cubic-bezier(0.25, 0.81, 0.24, 1);\n  transition-timing-function: cubic-bezier(0.25, 0.81, 0.24, 1);\n  -webkit-transition-property: all;\n  transition-property: all; }\n\n.item-left-edit {\n  -webkit-transition: all ease-in-out 125ms;\n  transition: all ease-in-out 125ms;\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 0;\n  width: 50px;\n  height: 100%;\n  line-height: 100%;\n  display: none;\n  opacity: 0;\n  -webkit-transform: translate3d(-21px, 0, 0);\n  transform: translate3d(-21px, 0, 0); }\n  .item-left-edit .button {\n    height: 100%; }\n    .item-left-edit .button.icon {\n      display: -webkit-box;\n      display: -webkit-flex;\n      display: -moz-box;\n      display: -moz-flex;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n      -ms-flex-align: center;\n      -webkit-align-items: center;\n      -moz-align-items: center;\n      align-items: center;\n      position: absolute;\n      top: 0;\n      height: 100%; }\n  .item-left-edit.visible {\n    display: block; }\n    .item-left-edit.visible.active {\n      opacity: 1;\n      -webkit-transform: translate3d(8px, 0, 0);\n      transform: translate3d(8px, 0, 0); }\n\n.list-left-editing .item-left-edit {\n  -webkit-transition-delay: 125ms;\n  transition-delay: 125ms; }\n\n.item-delete .button.icon {\n  color: #ef473a;\n  font-size: 24px; }\n  .item-delete .button.icon:hover {\n    opacity: .7; }\n\n.item-right-edit {\n  -webkit-transition: all ease-in-out 125ms;\n  transition: all ease-in-out 125ms;\n  position: absolute;\n  top: 0;\n  right: 0;\n  z-index: 0;\n  width: 75px;\n  height: 100%;\n  background: inherit;\n  padding-left: 20px;\n  display: none;\n  opacity: 0;\n  -webkit-transform: translate3d(25px, 0, 0);\n  transform: translate3d(25px, 0, 0); }\n  .item-right-edit .button {\n    min-width: 50px;\n    height: 100%; }\n    .item-right-edit .button.icon {\n      display: -webkit-box;\n      display: -webkit-flex;\n      display: -moz-box;\n      display: -moz-flex;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n      -ms-flex-align: center;\n      -webkit-align-items: center;\n      -moz-align-items: center;\n      align-items: center;\n      position: absolute;\n      top: 0;\n      height: 100%;\n      font-size: 32px; }\n  .item-right-edit.visible {\n    display: block;\n    z-index: 3; }\n    .item-right-edit.visible.active {\n      opacity: 1;\n      -webkit-transform: translate3d(0, 0, 0);\n      transform: translate3d(0, 0, 0); }\n\n.list-right-editing .item-right-edit {\n  -webkit-transition-delay: 125ms;\n  transition-delay: 125ms; }\n\n.item-reorder .button.icon {\n  color: #444;\n  font-size: 32px; }\n\n.item-reordering {\n  position: absolute;\n  left: 0;\n  top: 0;\n  z-index: 9;\n  width: 100%;\n  box-shadow: 0px 0px 10px 0px #aaa; }\n  .item-reordering .item-reorder {\n    z-index: 1; }\n\n.item-placeholder {\n  opacity: 0.7; }\n\n/**\n * The hidden right-side buttons that can be exposed under a list item\n * with dragging.\n */\n.item-options {\n  position: absolute;\n  top: 0;\n  right: 0;\n  z-index: 1;\n  height: 100%; }\n  .item-options .button {\n    height: 100%;\n    border: none;\n    border-radius: 0;\n    display: -webkit-inline-box;\n    display: -webkit-inline-flex;\n    display: -moz-inline-flex;\n    display: -ms-inline-flexbox;\n    display: inline-flex;\n    -webkit-box-align: center;\n    -ms-flex-align: center;\n    -webkit-align-items: center;\n    -moz-align-items: center;\n    align-items: center; }\n    .item-options .button:before {\n      margin: 0 auto; }\n\n/**\n * Lists\n * --------------------------------------------------\n */\n.list {\n  position: relative;\n  padding-top: 1px;\n  padding-bottom: 1px;\n  padding-left: 0;\n  margin-bottom: 20px; }\n\n.list:last-child {\n  margin-bottom: 0px; }\n  .list:last-child.card {\n    margin-bottom: 40px; }\n\n/**\n * List Header\n * --------------------------------------------------\n */\n.list-header {\n  margin-top: 20px;\n  padding: 5px 15px;\n  background-color: transparent;\n  color: #222;\n  font-weight: bold; }\n\n.card.list .list-item {\n  padding-right: 1px;\n  padding-left: 1px; }\n\n/**\n * Cards and Inset Lists\n * --------------------------------------------------\n * A card and list-inset are close to the same thing, except a card as a box shadow.\n */\n.card,\n.list-inset {\n  overflow: hidden;\n  margin: 20px 10px;\n  border-radius: 2px;\n  background-color: #fff; }\n\n.card {\n  padding-top: 1px;\n  padding-bottom: 1px;\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.3); }\n  .card .item {\n    border-left: 0;\n    border-right: 0; }\n  .card .item:first-child {\n    border-top: 0; }\n  .card .item:last-child {\n    border-bottom: 0; }\n\n.padding .card, .padding .list-inset {\n  margin-left: 0;\n  margin-right: 0; }\n\n.card .item:first-child,\n.list-inset .item:first-child,\n.padding > .list .item:first-child {\n  border-top-left-radius: 2px;\n  border-top-right-radius: 2px; }\n  .card .item:first-child .item-content,\n  .list-inset .item:first-child .item-content,\n  .padding > .list .item:first-child .item-content {\n    border-top-left-radius: 2px;\n    border-top-right-radius: 2px; }\n\n.card .item:last-child,\n.list-inset .item:last-child,\n.padding > .list .item:last-child {\n  border-bottom-right-radius: 2px;\n  border-bottom-left-radius: 2px; }\n  .card .item:last-child .item-content,\n  .list-inset .item:last-child .item-content,\n  .padding > .list .item:last-child .item-content {\n    border-bottom-right-radius: 2px;\n    border-bottom-left-radius: 2px; }\n\n.card .item:last-child,\n.list-inset .item:last-child {\n  margin-bottom: -1px; }\n\n.card .item,\n.list-inset .item,\n.padding > .list .item,\n.padding-horizontal > .list .item {\n  margin-right: 0;\n  margin-left: 0; }\n  .card .item.item-input input,\n  .list-inset .item.item-input input,\n  .padding > .list .item.item-input input,\n  .padding-horizontal > .list .item.item-input input {\n    padding-right: 44px; }\n\n.padding-left > .list .item {\n  margin-left: 0; }\n\n.padding-right > .list .item {\n  margin-right: 0; }\n\n/**\n * Badges\n * --------------------------------------------------\n */\n.badge {\n  background-color: transparent;\n  color: #AAAAAA;\n  z-index: 1;\n  display: inline-block;\n  padding: 3px 8px;\n  min-width: 10px;\n  border-radius: 10px;\n  vertical-align: baseline;\n  text-align: center;\n  white-space: nowrap;\n  font-weight: bold;\n  font-size: 14px;\n  line-height: 16px; }\n  .badge:empty {\n    display: none; }\n\n.tabs .tab-item .badge.badge-light,\n.badge.badge-light {\n  background-color: #fff;\n  color: #444; }\n\n.tabs .tab-item .badge.badge-stable,\n.badge.badge-stable {\n  background-color: #FF0D6D;\n  color: #FFFFFF; }\n\n.tabs .tab-item .badge.badge-positive,\n.badge.badge-positive {\n  background-color: #387ef5;\n  color: #fff; }\n\n.tabs .tab-item .badge.badge-calm,\n.badge.badge-calm {\n  background-color: #FE7D18;\n  color: #fff; }\n\n.tabs .tab-item .badge.badge-assertive,\n.badge.badge-assertive {\n  background-color: #ef473a;\n  color: #fff; }\n\n.tabs .tab-item .badge.badge-balanced,\n.badge.badge-balanced {\n  background-color: #33cd5f;\n  color: #fff; }\n\n.tabs .tab-item .badge.badge-energized,\n.badge.badge-energized {\n  background-color: #ffc900;\n  color: #fff; }\n\n.tabs .tab-item .badge.badge-royal,\n.badge.badge-royal {\n  background-color: #886aea;\n  color: #fff; }\n\n.tabs .tab-item .badge.badge-dark,\n.badge.badge-dark {\n  background-color: #444;\n  color: #fff; }\n\n.button .badge {\n  position: relative;\n  top: -1px; }\n\n/**\n * Slide Box\n * --------------------------------------------------\n */\n.slider {\n  position: relative;\n  visibility: hidden;\n  overflow: hidden; }\n\n.slider-slides {\n  position: relative;\n  height: 100%; }\n\n.slider-slide {\n  position: relative;\n  display: block;\n  float: left;\n  width: 100%;\n  height: 100%;\n  vertical-align: top; }\n\n.slider-slide-image > img {\n  width: 100%; }\n\n.slider-pager {\n  position: absolute;\n  bottom: 20px;\n  z-index: 1;\n  width: 100%;\n  height: 15px;\n  text-align: center; }\n  .slider-pager .slider-pager-page {\n    display: inline-block;\n    margin: 0px 3px;\n    width: 15px;\n    color: #000;\n    text-decoration: none;\n    opacity: 0.3; }\n    .slider-pager .slider-pager-page.active {\n      -webkit-transition: opacity 0.4s ease-in;\n      transition: opacity 0.4s ease-in;\n      opacity: 1; }\n\n/**\n * Forms\n * --------------------------------------------------\n */\nform {\n  margin: 0 0 1.42857; }\n\nlegend {\n  display: block;\n  margin-bottom: 1.42857;\n  padding: 0;\n  width: 100%;\n  border: 1px solid #ddd;\n  color: #444;\n  font-size: 21px;\n  line-height: 2.85714; }\n  legend small {\n    color: #FF0D6D;\n    font-size: 1.07143; }\n\nlabel,\ninput,\nbutton,\nselect,\ntextarea {\n  font-weight: normal;\n  font-size: 14px;\n  line-height: 1.42857; }\n\ninput,\nbutton,\nselect,\ntextarea {\n  font-family: \"Helvetica Neue\", \"Roboto\", sans-serif; }\n\n.item-input {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  position: relative;\n  overflow: hidden;\n  padding: 6px 0 5px 16px; }\n  .item-input input {\n    -webkit-border-radius: 0;\n    border-radius: 0;\n    -webkit-box-flex: 1;\n    -webkit-flex: 1 0 220px;\n    -moz-box-flex: 1;\n    -moz-flex: 1 0 220px;\n    -ms-flex: 1 0 220px;\n    flex: 1 0 220px;\n    -webkit-appearance: none;\n    -moz-appearance: none;\n    appearance: none;\n    margin: 0;\n    padding-right: 24px;\n    background-color: transparent; }\n  .item-input .button .icon {\n    -webkit-box-flex: 0;\n    -webkit-flex: 0 0 24px;\n    -moz-box-flex: 0;\n    -moz-flex: 0 0 24px;\n    -ms-flex: 0 0 24px;\n    flex: 0 0 24px;\n    position: static;\n    display: inline-block;\n    height: auto;\n    text-align: center;\n    font-size: 16px; }\n  .item-input .button-bar {\n    -webkit-border-radius: 0;\n    border-radius: 0;\n    -webkit-box-flex: 1;\n    -webkit-flex: 1 0 220px;\n    -moz-box-flex: 1;\n    -moz-flex: 1 0 220px;\n    -ms-flex: 1 0 220px;\n    flex: 1 0 220px;\n    -webkit-appearance: none;\n    -moz-appearance: none;\n    appearance: none; }\n  .item-input .icon {\n    min-width: 14px; }\n\n.item-input-inset {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  position: relative;\n  overflow: hidden;\n  padding: 10.66667px; }\n\n.item-input-wrapper {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1 0;\n  -moz-box-flex: 1;\n  -moz-flex: 1 0;\n  -ms-flex: 1 0;\n  flex: 1 0;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  -webkit-border-radius: 4px;\n  border-radius: 4px;\n  padding-right: 8px;\n  padding-left: 8px;\n  background: #eee; }\n\n.item-input-inset .item-input-wrapper input {\n  padding-left: 4px;\n  height: 29px;\n  background: transparent;\n  line-height: 18px; }\n\n.item-input-wrapper ~ .button {\n  margin-left: 10.66667px; }\n\n.input-label {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1 0 100px;\n  -moz-box-flex: 1;\n  -moz-flex: 1 0 100px;\n  -ms-flex: 1 0 100px;\n  flex: 1 0 100px;\n  display: table;\n  padding: 7px 10px 7px 0px;\n  max-width: 200px;\n  width: 35%;\n  color: #444;\n  font-size: 16px; }\n\n.placeholder-icon {\n  color: #aaa; }\n  .placeholder-icon:first-child {\n    padding-right: 6px; }\n  .placeholder-icon:last-child {\n    padding-left: 6px; }\n\n.item-stacked-label {\n  display: block;\n  background-color: transparent;\n  box-shadow: none; }\n  .item-stacked-label .input-label, .item-stacked-label .icon {\n    display: inline-block;\n    padding: 4px 0 0 0px;\n    vertical-align: middle; }\n\n.item-stacked-label input,\n.item-stacked-label textarea {\n  -webkit-border-radius: 2px;\n  border-radius: 2px;\n  padding: 4px 8px 3px 0;\n  border: none;\n  background-color: #fff; }\n\n.item-stacked-label input {\n  overflow: hidden;\n  height: 46px; }\n\n.item-floating-label {\n  display: block;\n  background-color: transparent;\n  box-shadow: none; }\n  .item-floating-label .input-label {\n    position: relative;\n    padding: 5px 0 0 0;\n    opacity: 0;\n    top: 10px;\n    -webkit-transition: opacity 0.15s ease-in, top 0.2s linear;\n    transition: opacity 0.15s ease-in, top 0.2s linear; }\n    .item-floating-label .input-label.has-input {\n      opacity: 1;\n      top: 0;\n      -webkit-transition: opacity 0.15s ease-in, top 0.2s linear;\n      transition: opacity 0.15s ease-in, top 0.2s linear; }\n\ntextarea,\ninput[type=\"text\"],\ninput[type=\"password\"],\ninput[type=\"datetime\"],\ninput[type=\"datetime-local\"],\ninput[type=\"date\"],\ninput[type=\"month\"],\ninput[type=\"time\"],\ninput[type=\"week\"],\ninput[type=\"number\"],\ninput[type=\"email\"],\ninput[type=\"url\"],\ninput[type=\"search\"],\ninput[type=\"tel\"],\ninput[type=\"color\"] {\n  display: block;\n  padding-top: 2px;\n  padding-left: 0;\n  height: 34px;\n  color: #111;\n  vertical-align: middle;\n  font-size: 14px;\n  line-height: 16px; }\n\n.platform-ios input[type=\"datetime-local\"],\n.platform-ios input[type=\"date\"],\n.platform-ios input[type=\"month\"],\n.platform-ios input[type=\"time\"],\n.platform-ios input[type=\"week\"],\n.platform-android input[type=\"datetime-local\"],\n.platform-android input[type=\"date\"],\n.platform-android input[type=\"month\"],\n.platform-android input[type=\"time\"],\n.platform-android input[type=\"week\"] {\n  padding-top: 8px; }\n\ninput,\ntextarea {\n  width: 100%; }\n\ntextarea {\n  padding-left: 0; }\n  textarea::-moz-placeholder {\n    color: #aaaaaa; }\n  textarea:-ms-input-placeholder {\n    color: #aaaaaa; }\n  textarea::-webkit-input-placeholder {\n    color: #aaaaaa;\n    text-indent: -3px; }\n\ntextarea {\n  height: auto; }\n\ntextarea,\ninput[type=\"text\"],\ninput[type=\"password\"],\ninput[type=\"datetime\"],\ninput[type=\"datetime-local\"],\ninput[type=\"date\"],\ninput[type=\"month\"],\ninput[type=\"time\"],\ninput[type=\"week\"],\ninput[type=\"number\"],\ninput[type=\"email\"],\ninput[type=\"url\"],\ninput[type=\"search\"],\ninput[type=\"tel\"],\ninput[type=\"color\"] {\n  border: 0; }\n\ninput[type=\"radio\"],\ninput[type=\"checkbox\"] {\n  margin: 0;\n  line-height: normal; }\n\ninput[type=\"file\"],\ninput[type=\"image\"],\ninput[type=\"submit\"],\ninput[type=\"reset\"],\ninput[type=\"button\"],\ninput[type=\"radio\"],\ninput[type=\"checkbox\"] {\n  width: auto; }\n\ninput[type=\"file\"] {\n  line-height: 34px; }\n\n.previous-input-focus,\n.cloned-text-input + input,\n.cloned-text-input + textarea {\n  position: absolute !important;\n  left: -9999px;\n  width: 200px; }\n\ninput::-moz-placeholder,\ntextarea::-moz-placeholder {\n  color: #aaaaaa; }\n\ninput:-ms-input-placeholder,\ntextarea:-ms-input-placeholder {\n  color: #aaaaaa; }\n\ninput::-webkit-input-placeholder,\ntextarea::-webkit-input-placeholder {\n  color: #aaaaaa;\n  text-indent: 0; }\n\ninput[disabled],\nselect[disabled],\ntextarea[disabled],\ninput[readonly]:not(.cloned-text-input),\ntextarea[readonly]:not(.cloned-text-input),\nselect[readonly] {\n  background-color: #FF0D6D;\n  cursor: not-allowed; }\n\ninput[type=\"radio\"][disabled],\ninput[type=\"checkbox\"][disabled],\ninput[type=\"radio\"][readonly],\ninput[type=\"checkbox\"][readonly] {\n  background-color: transparent; }\n\n/**\n * Checkbox\n * --------------------------------------------------\n */\n.checkbox {\n  position: relative;\n  display: inline-block;\n  padding: 7px 7px;\n  cursor: pointer; }\n  .checkbox input:before,\n  .checkbox .checkbox-icon:before {\n    border-color: #ddd; }\n  .checkbox input:checked:before,\n  .checkbox input:checked + .checkbox-icon:before {\n    background: #387ef5;\n    border-color: #387ef5; }\n\n.checkbox-light input:before,\n.checkbox-light .checkbox-icon:before {\n  border-color: #ddd; }\n\n.checkbox-light input:checked:before,\n.checkbox-light input:checked + .checkbox-icon:before {\n  background: #ddd;\n  border-color: #ddd; }\n\n.checkbox-stable input:before,\n.checkbox-stable .checkbox-icon:before {\n  border-color: #b2b2b2; }\n\n.checkbox-stable input:checked:before,\n.checkbox-stable input:checked + .checkbox-icon:before {\n  background: #FF006C;\n  border-color: #b2b2b2; }\n\n.checkbox-positive input:before,\n.checkbox-positive .checkbox-icon:before {\n  border-color: #387ef5; }\n\n.checkbox-positive input:checked:before,\n.checkbox-positive input:checked + .checkbox-icon:before {\n  background: #387ef5;\n  border-color: #387ef5; }\n\n.checkbox-calm input:before,\n.checkbox-calm .checkbox-icon:before {\n  border-color: #FE7D18; }\n\n.checkbox-calm input:checked:before,\n.checkbox-calm input:checked + .checkbox-icon:before {\n  background: #FE7D18;\n  border-color: #FE7D18; }\n\n.checkbox-assertive input:before,\n.checkbox-assertive .checkbox-icon:before {\n  border-color: #ef473a; }\n\n.checkbox-assertive input:checked:before,\n.checkbox-assertive input:checked + .checkbox-icon:before {\n  background: #ef473a;\n  border-color: #ef473a; }\n\n.checkbox-balanced input:before,\n.checkbox-balanced .checkbox-icon:before {\n  border-color: #33cd5f; }\n\n.checkbox-balanced input:checked:before,\n.checkbox-balanced input:checked + .checkbox-icon:before {\n  background: #33cd5f;\n  border-color: #33cd5f; }\n\n.checkbox-energized input:before,\n.checkbox-energized .checkbox-icon:before {\n  border-color: #ffc900; }\n\n.checkbox-energized input:checked:before,\n.checkbox-energized input:checked + .checkbox-icon:before {\n  background: #ffc900;\n  border-color: #ffc900; }\n\n.checkbox-royal input:before,\n.checkbox-royal .checkbox-icon:before {\n  border-color: #886aea; }\n\n.checkbox-royal input:checked:before,\n.checkbox-royal input:checked + .checkbox-icon:before {\n  background: #886aea;\n  border-color: #886aea; }\n\n.checkbox-dark input:before,\n.checkbox-dark .checkbox-icon:before {\n  border-color: #444; }\n\n.checkbox-dark input:checked:before,\n.checkbox-dark input:checked + .checkbox-icon:before {\n  background: #444;\n  border-color: #444; }\n\n.checkbox input:disabled:before,\n.checkbox input:disabled + .checkbox-icon:before {\n  border-color: #ddd; }\n\n.checkbox input:disabled:checked:before,\n.checkbox input:disabled:checked + .checkbox-icon:before {\n  background: #ddd; }\n\n.checkbox.checkbox-input-hidden input {\n  display: none !important; }\n\n.checkbox input,\n.checkbox-icon {\n  position: relative;\n  width: 28px;\n  height: 28px;\n  display: block;\n  border: 0;\n  background: transparent;\n  cursor: pointer;\n  -webkit-appearance: none; }\n  .checkbox input:before,\n  .checkbox-icon:before {\n    display: table;\n    width: 100%;\n    height: 100%;\n    border-width: 1px;\n    border-style: solid;\n    border-radius: 28px;\n    background: #fff;\n    content: ' ';\n    -webkit-transition: background-color 20ms ease-in-out;\n    transition: background-color 20ms ease-in-out; }\n\n.checkbox input:checked:before,\ninput:checked + .checkbox-icon:before {\n  border-width: 2px; }\n\n.checkbox input:after,\n.checkbox-icon:after {\n  -webkit-transition: opacity 0.05s ease-in-out;\n  transition: opacity 0.05s ease-in-out;\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n  position: absolute;\n  top: 33%;\n  left: 25%;\n  display: table;\n  width: 14px;\n  height: 6px;\n  border: 1px solid #fff;\n  border-top: 0;\n  border-right: 0;\n  content: ' ';\n  opacity: 0; }\n\n.platform-android .checkbox-platform input:before,\n.platform-android .checkbox-platform .checkbox-icon:before,\n.checkbox-square input:before,\n.checkbox-square .checkbox-icon:before {\n  border-radius: 2px;\n  width: 72%;\n  height: 72%;\n  margin-top: 14%;\n  margin-left: 14%;\n  border-width: 2px; }\n\n.platform-android .checkbox-platform input:after,\n.platform-android .checkbox-platform .checkbox-icon:after,\n.checkbox-square input:after,\n.checkbox-square .checkbox-icon:after {\n  border-width: 2px;\n  top: 19%;\n  left: 25%;\n  width: 13px;\n  height: 7px; }\n\n.grade-c .checkbox input:after,\n.grade-c .checkbox-icon:after {\n  -webkit-transform: rotate(0);\n  transform: rotate(0);\n  top: 3px;\n  left: 4px;\n  border: none;\n  color: #fff;\n  content: '\\2713';\n  font-weight: bold;\n  font-size: 20px; }\n\n.checkbox input:checked:after,\ninput:checked + .checkbox-icon:after {\n  opacity: 1; }\n\n.item-checkbox {\n  padding-left: 60px; }\n  .item-checkbox.active {\n    box-shadow: none; }\n\n.item-checkbox .checkbox {\n  position: absolute;\n  top: 50%;\n  right: 8px;\n  left: 8px;\n  z-index: 3;\n  margin-top: -21px; }\n\n.item-checkbox.item-checkbox-right {\n  padding-right: 60px;\n  padding-left: 16px; }\n\n.item-checkbox-right .checkbox input,\n.item-checkbox-right .checkbox-icon {\n  float: right; }\n\n/**\n * Toggle\n * --------------------------------------------------\n */\n.item-toggle {\n  pointer-events: none; }\n\n.toggle {\n  position: relative;\n  display: inline-block;\n  pointer-events: auto;\n  margin: -5px;\n  padding: 5px; }\n  .toggle input:checked + .track {\n    border-color: #387ef5;\n    background-color: #387ef5; }\n  .toggle.dragging .handle {\n    background-color: #f2f2f2 !important; }\n  .toggle.toggle-light input:checked + .track {\n    border-color: #ddd;\n    background-color: #ddd; }\n  .toggle.toggle-stable input:checked + .track {\n    border-color: #b2b2b2;\n    background-color: #b2b2b2; }\n  .toggle.toggle-positive input:checked + .track {\n    border-color: #387ef5;\n    background-color: #387ef5; }\n  .toggle.toggle-calm input:checked + .track {\n    border-color: #FE7D18;\n    background-color: #FE7D18; }\n  .toggle.toggle-assertive input:checked + .track {\n    border-color: #ef473a;\n    background-color: #ef473a; }\n  .toggle.toggle-balanced input:checked + .track {\n    border-color: #33cd5f;\n    background-color: #33cd5f; }\n  .toggle.toggle-energized input:checked + .track {\n    border-color: #ffc900;\n    background-color: #ffc900; }\n  .toggle.toggle-royal input:checked + .track {\n    border-color: #886aea;\n    background-color: #886aea; }\n  .toggle.toggle-dark input:checked + .track {\n    border-color: #444;\n    background-color: #444; }\n\n.toggle input {\n  display: none; }\n\n/* the track appearance when the toggle is \"off\" */\n.toggle .track {\n  -webkit-transition-timing-function: ease-in-out;\n  transition-timing-function: ease-in-out;\n  -webkit-transition-duration: 0.2s;\n  transition-duration: 0.2s;\n  -webkit-transition-property: background-color, border;\n  transition-property: background-color, border;\n  display: inline-block;\n  box-sizing: border-box;\n  width: 54px;\n  height: 32px;\n  border: solid 2px #E5E5E5;\n  border-radius: 20px;\n  background-color: #E5E5E5;\n  content: ' ';\n  cursor: pointer;\n  pointer-events: none; }\n\n/* Fix to avoid background color bleeding */\n/* (occured on (at least) Android 4.2, Asus MeMO Pad HD7 ME173X) */\n.platform-android4_2 .toggle .track {\n  -webkit-background-clip: padding-box; }\n\n/* the handle (circle) thats inside the toggle's track area */\n/* also the handle's appearance when it is \"off\" */\n.toggle .handle {\n  -webkit-transition: 0.2s ease-in-out;\n  transition: 0.2s ease-in-out;\n  position: absolute;\n  display: block;\n  width: 28px;\n  height: 28px;\n  border-radius: 28px;\n  background-color: #fff;\n  top: 7px;\n  left: 7px; }\n  .toggle .handle:before {\n    position: absolute;\n    top: -4px;\n    left: -22px;\n    padding: 19px 35px;\n    content: \" \"; }\n\n.toggle input:checked + .track .handle {\n  -webkit-transform: translate3d(22px, 0, 0);\n  transform: translate3d(22px, 0, 0);\n  background-color: #fff; }\n\n.item-toggle.active {\n  box-shadow: none; }\n\n.item-toggle,\n.item-toggle.item-complex .item-content {\n  padding-right: 102px; }\n\n.item-toggle.item-complex {\n  padding-right: 0; }\n\n.item-toggle .toggle {\n  position: absolute;\n  top: 8px;\n  right: 16px;\n  z-index: 3; }\n\n.toggle input:disabled + .track {\n  opacity: .6; }\n\n/**\n * Radio Button Inputs\n * --------------------------------------------------\n */\n.item-radio {\n  padding: 0; }\n  .item-radio:hover {\n    cursor: pointer; }\n\n.item-radio .item-content {\n  /* give some room to the right for the checkmark icon */\n  padding-right: 64px; }\n\n.item-radio .radio-icon {\n  /* checkmark icon will be hidden by default */\n  position: absolute;\n  top: 0;\n  right: 0;\n  z-index: 3;\n  visibility: hidden;\n  padding: 14px;\n  height: 100%;\n  font-size: 24px; }\n\n.item-radio input {\n  /* hide any radio button inputs elements (the ugly circles) */\n  position: absolute;\n  left: -9999px; }\n  .item-radio input:checked ~ .item-content {\n    /* style the item content when its checked */\n    background: #f7f7f7; }\n  .item-radio input:checked ~ .radio-icon {\n    /* show the checkmark icon when its checked */\n    visibility: visible; }\n\n.platform-android.grade-b .item-radio,\n.platform-android.grade-c .item-radio {\n  -webkit-animation: androidCheckedbugfix infinite 1s; }\n\n@-webkit-keyframes androidCheckedbugfix {\n  from {\n    padding: 0; }\n  to {\n    padding: 0; } }\n\n/**\n * Range\n * --------------------------------------------------\n */\ninput[type=\"range\"] {\n  display: inline-block;\n  overflow: hidden;\n  margin-top: 5px;\n  margin-bottom: 5px;\n  padding-right: 2px;\n  padding-left: 1px;\n  width: auto;\n  height: 43px;\n  outline: none;\n  background: -webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(0%, #ccc), color-stop(100%, #ccc));\n  background: linear-gradient(to right, #ccc 0%, #ccc 100%);\n  background-position: center;\n  background-size: 99% 2px;\n  background-repeat: no-repeat;\n  -webkit-appearance: none; }\n  input[type=\"range\"]::-webkit-slider-thumb {\n    position: relative;\n    width: 28px;\n    height: 28px;\n    border-radius: 50%;\n    background-color: #fff;\n    box-shadow: 0 0 2px rgba(0, 0, 0, 0.3), 0 3px 5px rgba(0, 0, 0, 0.2);\n    cursor: pointer;\n    -webkit-appearance: none;\n    border: 0; }\n  input[type=\"range\"]::-webkit-slider-thumb:before {\n    /* what creates the colorful line on the left side of the slider */\n    position: absolute;\n    top: 13px;\n    left: -2001px;\n    width: 2000px;\n    height: 2px;\n    background: #444;\n    content: ' '; }\n  input[type=\"range\"]::-webkit-slider-thumb:after {\n    /* create a larger (but hidden) hit area */\n    position: absolute;\n    top: -15px;\n    left: -15px;\n    padding: 30px;\n    content: ' '; }\n\n.range {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center;\n  padding: 2px 11px; }\n  .range.range-light input::-webkit-slider-thumb:before {\n    background: #ddd; }\n  .range.range-stable input::-webkit-slider-thumb:before {\n    background: #b2b2b2; }\n  .range.range-positive input::-webkit-slider-thumb:before {\n    background: #387ef5; }\n  .range.range-calm input::-webkit-slider-thumb:before {\n    background: #FE7D18; }\n  .range.range-balanced input::-webkit-slider-thumb:before {\n    background: #33cd5f; }\n  .range.range-assertive input::-webkit-slider-thumb:before {\n    background: #ef473a; }\n  .range.range-energized input::-webkit-slider-thumb:before {\n    background: #ffc900; }\n  .range.range-royal input::-webkit-slider-thumb:before {\n    background: #886aea; }\n  .range.range-dark input::-webkit-slider-thumb:before {\n    background: #444; }\n\n.range .icon {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0;\n  -moz-box-flex: 0;\n  -moz-flex: 0;\n  -ms-flex: 0;\n  flex: 0;\n  display: block;\n  min-width: 24px;\n  text-align: center;\n  font-size: 24px; }\n\n.range input {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -moz-box-flex: 1;\n  -moz-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  display: block;\n  margin-right: 10px;\n  margin-left: 10px; }\n\n.range-label {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 auto;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  flex: 0 0 auto;\n  display: block;\n  white-space: nowrap; }\n\n.range-label:first-child {\n  padding-left: 5px; }\n\n.range input + .range-label {\n  padding-right: 5px;\n  padding-left: 0; }\n\n/**\n * Select\n * --------------------------------------------------\n */\n.item-select {\n  position: relative; }\n  .item-select select {\n    -webkit-appearance: none;\n    -moz-appearance: none;\n    appearance: none;\n    position: absolute;\n    top: 0;\n    right: 0;\n    padding: 14px 48px 16px 16px;\n    max-width: 65%;\n    border: none;\n    background: #fff;\n    color: #333;\n    text-indent: .01px;\n    text-overflow: '';\n    white-space: nowrap;\n    font-size: 14px;\n    cursor: pointer;\n    direction: rtl; }\n  .item-select select::-ms-expand {\n    display: none; }\n  .item-select option {\n    direction: ltr; }\n  .item-select:after {\n    position: absolute;\n    top: 50%;\n    right: 16px;\n    margin-top: -3px;\n    width: 0;\n    height: 0;\n    border-top: 5px solid;\n    border-right: 5px solid rgba(0, 0, 0, 0);\n    border-left: 5px solid rgba(0, 0, 0, 0);\n    color: #999;\n    content: \"\";\n    pointer-events: none; }\n  .item-select.item-light select {\n    background: #fff;\n    color: #444; }\n  .item-select.item-stable select {\n    background: #FF0D6D;\n    color: #FFFFFF; }\n  .item-select.item-stable:after, .item-select.item-stable .input-label {\n    color: #666666; }\n  .item-select.item-positive select {\n    background: #387ef5;\n    color: #fff; }\n  .item-select.item-positive:after, .item-select.item-positive .input-label {\n    color: #fff; }\n  .item-select.item-calm select {\n    background: #FE7D18;\n    color: #fff; }\n  .item-select.item-calm:after, .item-select.item-calm .input-label {\n    color: #fff; }\n  .item-select.item-assertive select {\n    background: #ef473a;\n    color: #fff; }\n  .item-select.item-assertive:after, .item-select.item-assertive .input-label {\n    color: #fff; }\n  .item-select.item-balanced select {\n    background: #33cd5f;\n    color: #fff; }\n  .item-select.item-balanced:after, .item-select.item-balanced .input-label {\n    color: #fff; }\n  .item-select.item-energized select {\n    background: #ffc900;\n    color: #fff; }\n  .item-select.item-energized:after, .item-select.item-energized .input-label {\n    color: #fff; }\n  .item-select.item-royal select {\n    background: #886aea;\n    color: #fff; }\n  .item-select.item-royal:after, .item-select.item-royal .input-label {\n    color: #fff; }\n  .item-select.item-dark select {\n    background: #444;\n    color: #fff; }\n  .item-select.item-dark:after, .item-select.item-dark .input-label {\n    color: #fff; }\n\nselect[multiple], select[size] {\n  height: auto; }\n\n/**\n * Progress\n * --------------------------------------------------\n */\nprogress {\n  display: block;\n  margin: 15px auto;\n  width: 100%; }\n\n/**\n * Buttons\n * --------------------------------------------------\n */\n.button {\n  border-color: #b2b2b2;\n  background-color: #FF0D6D;\n  color: #FFFFFF;\n  position: relative;\n  display: inline-block;\n  margin: 0;\n  padding: 0 12px;\n  min-width: 52px;\n  min-height: 47px;\n  border-width: 1px;\n  border-style: solid;\n  border-radius: 6px;\n  vertical-align: top;\n  text-align: center;\n  text-overflow: ellipsis;\n  font-size: 16px;\n  line-height: 42px;\n  cursor: pointer; }\n  .button:hover {\n    color: #FFFFFF;\n    text-decoration: none; }\n  .button.active, .button.activated {\n    border-color: #a2a2a2;\n    background-color: #e5e5e5;\n    box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n  .button:after {\n    position: absolute;\n    top: -6px;\n    right: -6px;\n    bottom: -6px;\n    left: -6px;\n    content: ' '; }\n  .button .icon {\n    vertical-align: top;\n    pointer-events: none; }\n  .button .icon:before, .button.icon:before, .button.icon-left:before, .button.icon-right:before {\n    display: inline-block;\n    padding: 0 0 1px 0;\n    vertical-align: inherit;\n    font-size: 24px;\n    line-height: 41px;\n    pointer-events: none; }\n  .button.icon-left:before {\n    float: left;\n    padding-right: .2em;\n    padding-left: 0; }\n  .button.icon-right:before {\n    float: right;\n    padding-right: 0;\n    padding-left: .2em; }\n  .button.button-block, .button.button-full {\n    margin-top: 10px;\n    margin-bottom: 10px; }\n  .button.button-light {\n    border-color: #ddd;\n    background-color: #fff;\n    color: #444; }\n    .button.button-light:hover {\n      color: #444;\n      text-decoration: none; }\n    .button.button-light.active, .button.button-light.activated {\n      border-color: #ccc;\n      background-color: #fafafa;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-light.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #ddd; }\n    .button.button-light.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-light.button-outline {\n      border-color: #ddd;\n      background: transparent;\n      color: #ddd; }\n      .button.button-light.button-outline.active, .button.button-light.button-outline.activated {\n        background-color: #ddd;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-stable {\n    border-color: #b2b2b2;\n    background-color: #FF0D6D;\n    color: #FFFFFF; }\n    .button.button-stable:hover {\n      color: #FFFFFF;\n      text-decoration: none; }\n    .button.button-stable.active, .button.button-stable.activated {\n      border-color: #a2a2a2;\n      background-color: #e5e5e5;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-stable.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #b2b2b2; }\n    .button.button-stable.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-stable.button-outline {\n      border-color: #b2b2b2;\n      background: transparent;\n      color: #b2b2b2; }\n      .button.button-stable.button-outline.active, .button.button-stable.button-outline.activated {\n        background-color: #b2b2b2;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-positive {\n    border-color: #0c60ee;\n    background-color: #387ef5;\n    color: #fff; }\n    .button.button-positive:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-positive.active, .button.button-positive.activated {\n      border-color: #0c60ee;\n      background-color: #0c60ee;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-positive.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #387ef5; }\n    .button.button-positive.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-positive.button-outline {\n      border-color: #387ef5;\n      background: transparent;\n      color: #387ef5; }\n      .button.button-positive.button-outline.active, .button.button-positive.button-outline.activated {\n        background-color: #387ef5;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-calm {\n    border-color: #e26401;\n    background-color: #FE7D18;\n    color: #fff; }\n    .button.button-calm:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-calm.active, .button.button-calm.activated {\n      border-color: #e26401;\n      background-color: #e26401;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-calm.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #FE7D18; }\n    .button.button-calm.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-calm.button-outline {\n      border-color: #FE7D18;\n      background: transparent;\n      color: #FE7D18; }\n      .button.button-calm.button-outline.active, .button.button-calm.button-outline.activated {\n        background-color: #FE7D18;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-assertive {\n    border-color: #e42112;\n    background-color: #ef473a;\n    color: #fff; }\n    .button.button-assertive:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-assertive.active, .button.button-assertive.activated {\n      border-color: #e42112;\n      background-color: #e42112;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-assertive.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #ef473a; }\n    .button.button-assertive.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-assertive.button-outline {\n      border-color: #ef473a;\n      background: transparent;\n      color: #ef473a; }\n      .button.button-assertive.button-outline.active, .button.button-assertive.button-outline.activated {\n        background-color: #ef473a;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-balanced {\n    border-color: #28a54c;\n    background-color: #33cd5f;\n    color: #fff; }\n    .button.button-balanced:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-balanced.active, .button.button-balanced.activated {\n      border-color: #28a54c;\n      background-color: #28a54c;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-balanced.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #33cd5f; }\n    .button.button-balanced.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-balanced.button-outline {\n      border-color: #33cd5f;\n      background: transparent;\n      color: #33cd5f; }\n      .button.button-balanced.button-outline.active, .button.button-balanced.button-outline.activated {\n        background-color: #33cd5f;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-energized {\n    border-color: #e6b500;\n    background-color: #ffc900;\n    color: #fff; }\n    .button.button-energized:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-energized.active, .button.button-energized.activated {\n      border-color: #e6b500;\n      background-color: #e6b500;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-energized.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #ffc900; }\n    .button.button-energized.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-energized.button-outline {\n      border-color: #ffc900;\n      background: transparent;\n      color: #ffc900; }\n      .button.button-energized.button-outline.active, .button.button-energized.button-outline.activated {\n        background-color: #ffc900;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-royal {\n    border-color: #6b46e5;\n    background-color: #886aea;\n    color: #fff; }\n    .button.button-royal:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-royal.active, .button.button-royal.activated {\n      border-color: #6b46e5;\n      background-color: #6b46e5;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-royal.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #886aea; }\n    .button.button-royal.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-royal.button-outline {\n      border-color: #886aea;\n      background: transparent;\n      color: #886aea; }\n      .button.button-royal.button-outline.active, .button.button-royal.button-outline.activated {\n        background-color: #886aea;\n        box-shadow: none;\n        color: #fff; }\n  .button.button-dark {\n    border-color: #111;\n    background-color: #444;\n    color: #fff; }\n    .button.button-dark:hover {\n      color: #fff;\n      text-decoration: none; }\n    .button.button-dark.active, .button.button-dark.activated {\n      border-color: #000;\n      background-color: #262626;\n      box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.1); }\n    .button.button-dark.button-clear {\n      border-color: transparent;\n      background: none;\n      box-shadow: none;\n      color: #444; }\n    .button.button-dark.button-icon {\n      border-color: transparent;\n      background: none; }\n    .button.button-dark.button-outline {\n      border-color: #444;\n      background: transparent;\n      color: #444; }\n      .button.button-dark.button-outline.active, .button.button-dark.button-outline.activated {\n        background-color: #444;\n        box-shadow: none;\n        color: #fff; }\n\n.button-small {\n  padding: 2px 4px 1px;\n  min-width: 28px;\n  min-height: 30px;\n  font-size: 12px;\n  line-height: 26px; }\n  .button-small .icon:before, .button-small.icon:before, .button-small.icon-left:before, .button-small.icon-right:before {\n    font-size: 16px;\n    line-height: 19px;\n    margin-top: 3px; }\n\n.button-large {\n  padding: 0 16px;\n  min-width: 68px;\n  min-height: 59px;\n  font-size: 20px;\n  line-height: 53px; }\n  .button-large .icon:before, .button-large.icon:before, .button-large.icon-left:before, .button-large.icon-right:before {\n    padding-bottom: 2px;\n    font-size: 32px;\n    line-height: 51px; }\n\n.button-icon {\n  -webkit-transition: opacity 0.1s;\n  transition: opacity 0.1s;\n  padding: 0 6px;\n  min-width: initial;\n  border-color: transparent;\n  background: none; }\n  .button-icon.button.active, .button-icon.button.activated {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    opacity: 0.3; }\n  .button-icon .icon:before, .button-icon.icon:before {\n    font-size: 32px; }\n\n.button-clear {\n  -webkit-transition: opacity 0.1s;\n  transition: opacity 0.1s;\n  padding: 0 6px;\n  max-height: 42px;\n  border-color: transparent;\n  background: none;\n  box-shadow: none; }\n  .button-clear.button-clear {\n    border-color: transparent;\n    background: none;\n    box-shadow: none;\n    color: #b2b2b2; }\n  .button-clear.button-icon {\n    border-color: transparent;\n    background: none; }\n  .button-clear.active, .button-clear.activated {\n    opacity: 0.3; }\n\n.button-outline {\n  -webkit-transition: opacity 0.1s;\n  transition: opacity 0.1s;\n  background: none;\n  box-shadow: none; }\n  .button-outline.button-outline {\n    border-color: #b2b2b2;\n    background: transparent;\n    color: #b2b2b2; }\n    .button-outline.button-outline.active, .button-outline.button-outline.activated {\n      background-color: #b2b2b2;\n      box-shadow: none;\n      color: #fff; }\n\n.padding > .button.button-block:first-child {\n  margin-top: 0; }\n\n.button-block {\n  display: block;\n  clear: both; }\n  .button-block:after {\n    clear: both; }\n\n.button-full,\n.button-full > .button {\n  display: block;\n  margin-right: 0;\n  margin-left: 0;\n  border-right-width: 0;\n  border-left-width: 0;\n  border-radius: 0; }\n\nbutton.button-block,\nbutton.button-full,\n.button-full > button.button,\ninput.button.button-block {\n  width: 100%; }\n\na.button {\n  text-decoration: none; }\n  a.button .icon:before, a.button.icon:before, a.button.icon-left:before, a.button.icon-right:before {\n    margin-top: 2px; }\n\n.button.disabled,\n.button[disabled] {\n  opacity: .4;\n  cursor: default !important;\n  pointer-events: none; }\n\n/**\n * Button Bar\n * --------------------------------------------------\n */\n.button-bar {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -moz-box-flex: 1;\n  -moz-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  width: 100%; }\n  .button-bar.button-bar-inline {\n    display: block;\n    width: auto;\n    *zoom: 1; }\n    .button-bar.button-bar-inline:before, .button-bar.button-bar-inline:after {\n      display: table;\n      content: \"\";\n      line-height: 0; }\n    .button-bar.button-bar-inline:after {\n      clear: both; }\n    .button-bar.button-bar-inline > .button {\n      width: auto;\n      display: inline-block;\n      float: left; }\n\n.button-bar > .button {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -moz-box-flex: 1;\n  -moz-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  display: block;\n  overflow: hidden;\n  padding: 0 16px;\n  width: 0;\n  border-width: 1px 0px 1px 1px;\n  border-radius: 0;\n  text-align: center;\n  text-overflow: ellipsis;\n  white-space: nowrap; }\n  .button-bar > .button:before,\n  .button-bar > .button .icon:before {\n    line-height: 44px; }\n  .button-bar > .button:first-child {\n    border-radius: 6px 0px 0px 6px; }\n  .button-bar > .button:last-child {\n    border-right-width: 1px;\n    border-radius: 0px 6px 6px 0px; }\n\n/**\n * Grid\n * --------------------------------------------------\n * Using flexbox for the grid, inspired by Philip Walton:\n * http://philipwalton.github.io/solved-by-flexbox/demos/grids/\n * By default each .col within a .row will evenly take up\n * available width, and the height of each .col with take\n * up the height of the tallest .col in the same .row.\n */\n.row {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -moz-box;\n  display: -moz-flex;\n  display: -ms-flexbox;\n  display: flex;\n  padding: 5px;\n  width: 100%; }\n\n.row-wrap {\n  -webkit-flex-wrap: wrap;\n  -moz-flex-wrap: wrap;\n  -ms-flex-wrap: wrap;\n  flex-wrap: wrap; }\n\n.row + .row {\n  margin-top: -5px;\n  padding-top: 0; }\n\n.col {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -moz-box-flex: 1;\n  -moz-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  display: block;\n  padding: 5px;\n  width: 100%; }\n\n/* Vertically Align Columns */\n/* .row-* vertically aligns every .col in the .row */\n.row-top {\n  -webkit-box-align: start;\n  -ms-flex-align: start;\n  -webkit-align-items: flex-start;\n  -moz-align-items: flex-start;\n  align-items: flex-start; }\n\n.row-bottom {\n  -webkit-box-align: end;\n  -ms-flex-align: end;\n  -webkit-align-items: flex-end;\n  -moz-align-items: flex-end;\n  align-items: flex-end; }\n\n.row-center {\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  -webkit-align-items: center;\n  -moz-align-items: center;\n  align-items: center; }\n\n.row-stretch {\n  -webkit-box-align: stretch;\n  -ms-flex-align: stretch;\n  -webkit-align-items: stretch;\n  -moz-align-items: stretch;\n  align-items: stretch; }\n\n.row-baseline {\n  -webkit-box-align: baseline;\n  -ms-flex-align: baseline;\n  -webkit-align-items: baseline;\n  -moz-align-items: baseline;\n  align-items: baseline; }\n\n/* .col-* vertically aligns an individual .col */\n.col-top {\n  -webkit-align-self: flex-start;\n  -moz-align-self: flex-start;\n  -ms-flex-item-align: start;\n  align-self: flex-start; }\n\n.col-bottom {\n  -webkit-align-self: flex-end;\n  -moz-align-self: flex-end;\n  -ms-flex-item-align: end;\n  align-self: flex-end; }\n\n.col-center {\n  -webkit-align-self: center;\n  -moz-align-self: center;\n  -ms-flex-item-align: center;\n  align-self: center; }\n\n/* Column Offsets */\n.col-offset-10 {\n  margin-left: 10%; }\n\n.col-offset-20 {\n  margin-left: 20%; }\n\n.col-offset-25 {\n  margin-left: 25%; }\n\n.col-offset-33, .col-offset-34 {\n  margin-left: 33.3333%; }\n\n.col-offset-50 {\n  margin-left: 50%; }\n\n.col-offset-66, .col-offset-67 {\n  margin-left: 66.6666%; }\n\n.col-offset-75 {\n  margin-left: 75%; }\n\n.col-offset-80 {\n  margin-left: 80%; }\n\n.col-offset-90 {\n  margin-left: 90%; }\n\n/* Explicit Column Percent Sizes */\n/* By default each grid column will evenly distribute */\n/* across the grid. However, you can specify individual */\n/* columns to take up a certain size of the available area */\n.col-10 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 10%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 10%;\n  -ms-flex: 0 0 10%;\n  flex: 0 0 10%;\n  max-width: 10%; }\n\n.col-20 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 20%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 20%;\n  -ms-flex: 0 0 20%;\n  flex: 0 0 20%;\n  max-width: 20%; }\n\n.col-25 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 25%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 25%;\n  -ms-flex: 0 0 25%;\n  flex: 0 0 25%;\n  max-width: 25%; }\n\n.col-33, .col-34 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 33.3333%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 33.3333%;\n  -ms-flex: 0 0 33.3333%;\n  flex: 0 0 33.3333%;\n  max-width: 33.3333%; }\n\n.col-50 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 50%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 50%;\n  -ms-flex: 0 0 50%;\n  flex: 0 0 50%;\n  max-width: 50%; }\n\n.col-66, .col-67 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 66.6666%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 66.6666%;\n  -ms-flex: 0 0 66.6666%;\n  flex: 0 0 66.6666%;\n  max-width: 66.6666%; }\n\n.col-75 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 75%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 75%;\n  -ms-flex: 0 0 75%;\n  flex: 0 0 75%;\n  max-width: 75%; }\n\n.col-80 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 80%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 80%;\n  -ms-flex: 0 0 80%;\n  flex: 0 0 80%;\n  max-width: 80%; }\n\n.col-90 {\n  -webkit-box-flex: 0;\n  -webkit-flex: 0 0 90%;\n  -moz-box-flex: 0;\n  -moz-flex: 0 0 90%;\n  -ms-flex: 0 0 90%;\n  flex: 0 0 90%;\n  max-width: 90%; }\n\n/* Responsive Grid Classes */\n/* Adding a class of responsive-X to a row */\n/* will trigger the flex-direction to */\n/* change to column and add some margin */\n/* to any columns in the row for clearity */\n@media (max-width: 567px) {\n  .responsive-sm {\n    -webkit-box-direction: normal;\n    -moz-box-direction: normal;\n    -webkit-box-orient: vertical;\n    -moz-box-orient: vertical;\n    -webkit-flex-direction: column;\n    -ms-flex-direction: column;\n    flex-direction: column; }\n    .responsive-sm .col, .responsive-sm .col-10, .responsive-sm .col-20, .responsive-sm .col-25, .responsive-sm .col-33, .responsive-sm .col-34, .responsive-sm .col-50, .responsive-sm .col-66, .responsive-sm .col-67, .responsive-sm .col-75, .responsive-sm .col-80, .responsive-sm .col-90 {\n      -webkit-box-flex: 1;\n      -webkit-flex: 1;\n      -moz-box-flex: 1;\n      -moz-flex: 1;\n      -ms-flex: 1;\n      flex: 1;\n      margin-bottom: 15px;\n      margin-left: 0;\n      max-width: 100%;\n      width: 100%; } }\n\n@media (max-width: 767px) {\n  .responsive-md {\n    -webkit-box-direction: normal;\n    -moz-box-direction: normal;\n    -webkit-box-orient: vertical;\n    -moz-box-orient: vertical;\n    -webkit-flex-direction: column;\n    -ms-flex-direction: column;\n    flex-direction: column; }\n    .responsive-md .col, .responsive-md .col-10, .responsive-md .col-20, .responsive-md .col-25, .responsive-md .col-33, .responsive-md .col-34, .responsive-md .col-50, .responsive-md .col-66, .responsive-md .col-67, .responsive-md .col-75, .responsive-md .col-80, .responsive-md .col-90 {\n      -webkit-box-flex: 1;\n      -webkit-flex: 1;\n      -moz-box-flex: 1;\n      -moz-flex: 1;\n      -ms-flex: 1;\n      flex: 1;\n      margin-bottom: 15px;\n      margin-left: 0;\n      max-width: 100%;\n      width: 100%; } }\n\n@media (max-width: 1023px) {\n  .responsive-lg {\n    -webkit-box-direction: normal;\n    -moz-box-direction: normal;\n    -webkit-box-orient: vertical;\n    -moz-box-orient: vertical;\n    -webkit-flex-direction: column;\n    -ms-flex-direction: column;\n    flex-direction: column; }\n    .responsive-lg .col, .responsive-lg .col-10, .responsive-lg .col-20, .responsive-lg .col-25, .responsive-lg .col-33, .responsive-lg .col-34, .responsive-lg .col-50, .responsive-lg .col-66, .responsive-lg .col-67, .responsive-lg .col-75, .responsive-lg .col-80, .responsive-lg .col-90 {\n      -webkit-box-flex: 1;\n      -webkit-flex: 1;\n      -moz-box-flex: 1;\n      -moz-flex: 1;\n      -ms-flex: 1;\n      flex: 1;\n      margin-bottom: 15px;\n      margin-left: 0;\n      max-width: 100%;\n      width: 100%; } }\n\n/**\n * Utility Classes\n * --------------------------------------------------\n */\n.hide {\n  display: none; }\n\n.opacity-hide {\n  opacity: 0; }\n\n.grade-b .opacity-hide,\n.grade-c .opacity-hide {\n  opacity: 1;\n  display: none; }\n\n.show {\n  display: block; }\n\n.opacity-show {\n  opacity: 1; }\n\n.invisible {\n  visibility: hidden; }\n\n.keyboard-open .hide-on-keyboard-open {\n  display: none; }\n\n.keyboard-open .tabs.hide-on-keyboard-open + .pane .has-tabs,\n.keyboard-open .bar-footer.hide-on-keyboard-open + .pane .has-footer {\n  bottom: 0; }\n\n.inline {\n  display: inline-block; }\n\n.disable-pointer-events {\n  pointer-events: none; }\n\n.enable-pointer-events {\n  pointer-events: auto; }\n\n.disable-user-behavior {\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  -webkit-touch-callout: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-tap-highlight-color: transparent;\n  -webkit-user-drag: none;\n  -ms-touch-action: none;\n  -ms-content-zooming: none; }\n\n.click-block {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 99999;\n  width: 100%;\n  height: 100%;\n  opacity: 0;\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0); }\n\n.click-block-hide {\n  -webkit-transform: translate3d(-9999px, 0, 0);\n  transform: translate3d(-9999px, 0, 0); }\n\n.no-resize {\n  resize: none; }\n\n.block {\n  display: block;\n  clear: both; }\n  .block:after {\n    display: block;\n    visibility: hidden;\n    clear: both;\n    height: 0;\n    content: \".\"; }\n\n.full-image {\n  width: 100%; }\n\n.clearfix {\n  *zoom: 1; }\n  .clearfix:before, .clearfix:after {\n    display: table;\n    content: \"\";\n    line-height: 0; }\n  .clearfix:after {\n    clear: both; }\n\n/**\n * Content Padding\n * --------------------------------------------------\n */\n.padding {\n  padding: 10px; }\n\n.padding-top,\n.padding-vertical {\n  padding-top: 10px; }\n\n.padding-right,\n.padding-horizontal {\n  padding-right: 10px; }\n\n.padding-bottom,\n.padding-vertical {\n  padding-bottom: 10px; }\n\n.padding-left,\n.padding-horizontal {\n  padding-left: 10px; }\n\n/**\n * Rounded\n * --------------------------------------------------\n */\n.rounded {\n  border-radius: 4px; }\n\n/**\n * Utility Colors\n * --------------------------------------------------\n * Utility colors are added to help set a naming convention. You'll\n * notice we purposely do not use words like \"red\" or \"blue\", but\n * instead have colors which represent an emotion or generic theme.\n */\n.light, a.light {\n  color: #fff; }\n\n.light-bg {\n  background-color: #fff; }\n\n.light-border {\n  border-color: #ddd; }\n\n.stable, a.stable {\n  color: #FF0D6D; }\n\n.stable-bg {\n  background-color: #FF0D6D; }\n\n.stable-border {\n  border-color: #b2b2b2; }\n\n.positive, a.positive {\n  color: #387ef5; }\n\n.positive-bg {\n  background-color: #387ef5; }\n\n.positive-border {\n  border-color: #0c60ee; }\n\n.calm, a.calm {\n  color: #FE7D18; }\n\n.calm-bg {\n  background-color: #FE7D18; }\n\n.calm-border {\n  border-color: #e26401; }\n\n.assertive, a.assertive {\n  color: #ef473a; }\n\n.assertive-bg {\n  background-color: #ef473a; }\n\n.assertive-border {\n  border-color: #e42112; }\n\n.balanced, a.balanced {\n  color: #33cd5f; }\n\n.balanced-bg {\n  background-color: #33cd5f; }\n\n.balanced-border {\n  border-color: #28a54c; }\n\n.energized, a.energized {\n  color: #ffc900; }\n\n.energized-bg {\n  background-color: #ffc900; }\n\n.energized-border {\n  border-color: #e6b500; }\n\n.royal, a.royal {\n  color: #886aea; }\n\n.royal-bg {\n  background-color: #886aea; }\n\n.royal-border {\n  border-color: #6b46e5; }\n\n.dark, a.dark {\n  color: #444; }\n\n.dark-bg {\n  background-color: #444; }\n\n.dark-border {\n  border-color: #111; }\n\n/**\n * Platform\n * --------------------------------------------------\n * Platform specific tweaks\n */\n.platform-ios.platform-cordova:not(.fullscreen) .bar-header:not(.bar-subheader) {\n  height: 64px; }\n  .platform-ios.platform-cordova:not(.fullscreen) .bar-header:not(.bar-subheader).item-input-inset .item-input-wrapper {\n    margin-top: 19px !important; }\n  .platform-ios.platform-cordova:not(.fullscreen) .bar-header:not(.bar-subheader) > * {\n    margin-top: 20px; }\n\n.platform-ios.platform-cordova:not(.fullscreen) .tabs-top > .tabs,\n.platform-ios.platform-cordova:not(.fullscreen) .tabs.tabs-top {\n  top: 64px; }\n\n.platform-ios.platform-cordova:not(.fullscreen) .has-header,\n.platform-ios.platform-cordova:not(.fullscreen) .bar-subheader {\n  top: 64px; }\n\n.platform-ios.platform-cordova:not(.fullscreen) .has-subheader {\n  top: 108px; }\n\n.platform-ios.platform-cordova:not(.fullscreen) .has-tabs-top {\n  top: 113px; }\n\n.platform-ios.platform-cordova:not(.fullscreen) .has-header.has-subheader.has-tabs-top {\n  top: 157px; }\n\n.platform-ios.platform-cordova.status-bar-hide {\n  margin-bottom: 20px; }\n\n@media (orientation: landscape) {\n  .platform-ios.platform-browser.platform-ipad {\n    position: fixed; } }\n\n.platform-c:not(.enable-transitions) * {\n  -webkit-transition: none !important;\n  transition: none !important; }\n\n.slide-in-up {\n  -webkit-transform: translate3d(0, 100%, 0);\n  transform: translate3d(0, 100%, 0); }\n\n.slide-in-up.ng-enter,\n.slide-in-up > .ng-enter {\n  -webkit-transition: all cubic-bezier(0.1, 0.7, 0.1, 1) 400ms;\n  transition: all cubic-bezier(0.1, 0.7, 0.1, 1) 400ms; }\n\n.slide-in-up.ng-enter-active,\n.slide-in-up > .ng-enter-active {\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0); }\n\n.slide-in-up.ng-leave,\n.slide-in-up > .ng-leave {\n  -webkit-transition: all ease-in-out 250ms;\n  transition: all ease-in-out 250ms; }\n\n@-webkit-keyframes scaleOut {\n  from {\n    -webkit-transform: scale(1);\n    opacity: 1; }\n  to {\n    -webkit-transform: scale(0.8);\n    opacity: 0; } }\n\n@keyframes scaleOut {\n  from {\n    transform: scale(1);\n    opacity: 1; }\n  to {\n    transform: scale(0.8);\n    opacity: 0; } }\n\n@-webkit-keyframes superScaleIn {\n  from {\n    -webkit-transform: scale(1.2);\n    opacity: 0; }\n  to {\n    -webkit-transform: scale(1);\n    opacity: 1; } }\n\n@keyframes superScaleIn {\n  from {\n    transform: scale(1.2);\n    opacity: 0; }\n  to {\n    transform: scale(1);\n    opacity: 1; } }\n\n[nav-view-transition=\"ios\"] [nav-view=\"entering\"],\n[nav-view-transition=\"ios\"] [nav-view=\"leaving\"] {\n  -webkit-transition-duration: 450ms;\n  transition-duration: 450ms;\n  -webkit-transition-timing-function: cubic-bezier(0.3, 0.9, 0.4, 1);\n  transition-timing-function: cubic-bezier(0.3, 0.9, 0.4, 1);\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, transform; }\n\n[nav-view-transition=\"ios\"][nav-view-direction=\"forward\"], [nav-view-transition=\"ios\"][nav-view-direction=\"back\"] {\n  background-color: #000; }\n\n[nav-view-transition=\"ios\"] [nav-view=\"active\"],\n[nav-view-transition=\"ios\"][nav-view-direction=\"forward\"] [nav-view=\"entering\"],\n[nav-view-transition=\"ios\"][nav-view-direction=\"back\"] [nav-view=\"leaving\"] {\n  z-index: 3; }\n\n[nav-view-transition=\"ios\"][nav-view-direction=\"back\"] [nav-view=\"entering\"],\n[nav-view-transition=\"ios\"][nav-view-direction=\"forward\"] [nav-view=\"leaving\"] {\n  z-index: 2; }\n\n[nav-bar-transition=\"ios\"] .title,\n[nav-bar-transition=\"ios\"] .buttons,\n[nav-bar-transition=\"ios\"] .back-text {\n  -webkit-transition-duration: 450ms;\n  transition-duration: 450ms;\n  -webkit-transition-timing-function: cubic-bezier(0.3, 0.9, 0.4, 1);\n  transition-timing-function: cubic-bezier(0.3, 0.9, 0.4, 1);\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, transform; }\n\n[nav-bar-transition=\"ios\"] [nav-bar=\"active\"],\n[nav-bar-transition=\"ios\"] [nav-bar=\"entering\"] {\n  z-index: 10; }\n  [nav-bar-transition=\"ios\"] [nav-bar=\"active\"] .bar,\n  [nav-bar-transition=\"ios\"] [nav-bar=\"entering\"] .bar {\n    background: transparent; }\n\n[nav-bar-transition=\"ios\"] [nav-bar=\"cached\"] {\n  display: block; }\n  [nav-bar-transition=\"ios\"] [nav-bar=\"cached\"] .header-item {\n    display: none; }\n\n[nav-view-transition=\"android\"] [nav-view=\"entering\"],\n[nav-view-transition=\"android\"] [nav-view=\"leaving\"] {\n  -webkit-transition-duration: 200ms;\n  transition-duration: 200ms;\n  -webkit-transition-timing-function: cubic-bezier(0.4, 0.6, 0.2, 1);\n  transition-timing-function: cubic-bezier(0.4, 0.6, 0.2, 1);\n  -webkit-transition-property: -webkit-transform;\n  transition-property: transform; }\n\n[nav-view-transition=\"android\"] [nav-view=\"active\"],\n[nav-view-transition=\"android\"][nav-view-direction=\"forward\"] [nav-view=\"entering\"],\n[nav-view-transition=\"android\"][nav-view-direction=\"back\"] [nav-view=\"leaving\"] {\n  z-index: 3; }\n\n[nav-view-transition=\"android\"][nav-view-direction=\"back\"] [nav-view=\"entering\"],\n[nav-view-transition=\"android\"][nav-view-direction=\"forward\"] [nav-view=\"leaving\"] {\n  z-index: 2; }\n\n[nav-bar-transition=\"android\"] .title,\n[nav-bar-transition=\"android\"] .buttons {\n  -webkit-transition-duration: 200ms;\n  transition-duration: 200ms;\n  -webkit-transition-timing-function: cubic-bezier(0.4, 0.6, 0.2, 1);\n  transition-timing-function: cubic-bezier(0.4, 0.6, 0.2, 1);\n  -webkit-transition-property: opacity;\n  transition-property: opacity; }\n\n[nav-bar-transition=\"android\"] [nav-bar=\"active\"],\n[nav-bar-transition=\"android\"] [nav-bar=\"entering\"] {\n  z-index: 10; }\n  [nav-bar-transition=\"android\"] [nav-bar=\"active\"] .bar,\n  [nav-bar-transition=\"android\"] [nav-bar=\"entering\"] .bar {\n    background: transparent; }\n\n[nav-bar-transition=\"android\"] [nav-bar=\"cached\"] {\n  display: block; }\n  [nav-bar-transition=\"android\"] [nav-bar=\"cached\"] .header-item {\n    display: none; }\n\n[nav-view=\"cached\"],\n[nav-bar=\"cached\"] {\n  display: none; }\n\n[nav-view=\"stage\"] {\n  opacity: 0;\n  -webkit-transition-duration: 0;\n  transition-duration: 0; }\n\n[nav-bar=\"stage\"] .title,\n[nav-bar=\"stage\"] .buttons,\n[nav-bar=\"stage\"] .back-text {\n  position: absolute;\n  opacity: 0;\n  -webkit-transition-duration: 0s;\n  transition-duration: 0s; }\n\n.padding {\n  position: relative; }\n\nion-content {\n  background: #eeeeee; }\n  ion-content div.padding, ion-content.menubg {\n    background: #ffffff; }\n  ion-content h1 {\n    color: #FF006C; }\n  ion-content h2.subtitle {\n    font-size: 150%;\n    color: #999999; }\n  ion-content h1, ion-content h3, ion-content h4, ion-content a {\n    color: #FF006C; }\n  ion-content div.summary {\n    font-weight: bold;\n    margin-bottom: 0.5em; }\n  ion-content div.survey-question {\n    margin-bottom: 20px; }\n    ion-content div.survey-question p.help-block {\n      color: #555555;\n      margin-bottom: 10px; }\n    ion-content div.survey-question select {\n      color: #555555;\n      border: 1px solid #cccccc;\n      background: #ffffff;\n      padding: 8px;\n      max-width: 100%; }\n    ion-content div.survey-question textarea {\n      border: 1px solid #cccccc;\n      height: 120px; }\n\n.cards {\n  background: #eeeeee; }\n  .cards div.padding, .cards.padding {\n    background: #eeeeee; }\n  .cards .card h1 {\n    font-size: 1.5em; }\n  .cards .card h2 {\n    color: #FF006C;\n    margin: 0;\n    font-size: 1.5em; }\n  .cards .list.card a .icon {\n    color: #FF006C; }\n  .cards .list.card a h1 {\n    white-space: normal;\n    margin: 0; }\n\ndiv.survey-question {\n  margin-bottom: 20px; }\n  div.survey-question.error {\n    padding-left: 16px;\n    margin-left: -10px;\n    border-left: 16px solid #FF006C; }\n    div.survey-question.error select {\n      border-color: #FF006C;\n      color: #FF006C; }\n\ndiv.error-message {\n  background: #f2dede;\n  color: #b94a48;\n  margin-bottom: 10px;\n  padding: 10px;\n  border-radius: 3px; }\n\n.button-large {\n  font-size: 150%; }\n\n.button {\n  text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.25); }\n  .button.primary {\n    background: #fe016c;\n    /* Old browsers */\n    background: -moz-linear-gradient(top, #fe016c 0%, #e00060 100%);\n    /* FF3.6+ */\n    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #fe016c), color-stop(100%, #e00060));\n    /* Chrome,Safari4+ */\n    background: -webkit-linear-gradient(top, #fe016c 0%, #e00060 100%);\n    /* Chrome10+,Safari5.1+ */\n    background: -o-linear-gradient(top, #fe016c 0%, #e00060 100%);\n    /* Opera 11.10+ */\n    background: -ms-linear-gradient(top, #fe016c 0%, #e00060 100%);\n    /* IE10+ */\n    background: linear-gradient(to bottom, #fe016c 0%, #e00060 100%);\n    /* W3C */\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='$from', endColorstr='$to',GradientType=0 );\n    /* IE6-9 */ }\n  .button .icon:before {\n    line-height: 1; }\n\n.button-medium {\n  min-height: 0;\n  line-height: 1.8;\n  padding: 8px;\n  text-align: left; }\n\ndiv.nav-buttons {\n  padding: 10px;\n  border-top: 1px solid #AAAAAA; }\n\nul.button-list li {\n  margin-bottom: 10px; }\n\nbutton {\n  text-shadow: none !important; }\n\nbutton.survey-choice i {\n  color: #FF006C; }\n\nbutton.wide {\n  display: block;\n  text-align: center;\n  width: 100%; }\n\n.button-clear.button-clear {\n  color: black; }\n\nbutton.right {\n  position: absolute;\n  right: 13px;\n  top: 16px; }\n\nion-list.menu-secondary {\n  position: absolute;\n  bottom: 0;\n  left: 0;\n  right: 0; }\n\n.bar.bar-header button {\n  font-size: 1em !important;\n  opacity: 0.8; }\n\nlabel.item-radio div.item-content {\n  padding-left: 60px; }\n\nlabel.item-radio i.radio-icon {\n  left: 0; }\n\nli.item.item-checkbox {\n  white-space: normal; }\n  li.item.item-checkbox .checkbox {\n    margin-top: 0;\n    top: 8px; }\n\n.item-content {\n  white-space: normal; }\n\na {\n  text-decoration: none; }\n\na.external-link i {\n  padding-right: 3px;\n  padding-left: 3px;\n  font-size: 1.1em; }\n\n.rsc-medium img.preview {\n  width: 100%;\n  height: auto; }\n", ""]);


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
// eslint-disable-next-line func-names
module.exports = function (useSourceMap) {
  var list = []; // return the list of modules as css string

  list.toString = function toString() {
    return this.map(function (item) {
      var content = cssWithMappingToString(item, useSourceMap);

      if (item[2]) {
        return "@media ".concat(item[2], "{").concat(content, "}");
      }

      return content;
    }).join('');
  }; // import a list of modules into the list
  // eslint-disable-next-line func-names


  list.i = function (modules, mediaQuery) {
    if (typeof modules === 'string') {
      // eslint-disable-next-line no-param-reassign
      modules = [[null, modules, '']];
    }

    var alreadyImportedModules = {};

    for (var i = 0; i < this.length; i++) {
      // eslint-disable-next-line prefer-destructuring
      var id = this[i][0];

      if (id != null) {
        alreadyImportedModules[id] = true;
      }
    }

    for (var _i = 0; _i < modules.length; _i++) {
      var item = modules[_i]; // skip already imported module
      // this implementation is not 100% perfect for weird media query combinations
      // when a module is imported multiple times with different media queries.
      // I hope this will never occur (Hey this way we have smaller bundles)

      if (item[0] == null || !alreadyImportedModules[item[0]]) {
        if (mediaQuery && !item[2]) {
          item[2] = mediaQuery;
        } else if (mediaQuery) {
          item[2] = "(".concat(item[2], ") and (").concat(mediaQuery, ")");
        }

        list.push(item);
      }
    }
  };

  return list;
};

function cssWithMappingToString(item, useSourceMap) {
  var content = item[1] || ''; // eslint-disable-next-line prefer-destructuring

  var cssMapping = item[3];

  if (!cssMapping) {
    return content;
  }

  if (useSourceMap && typeof btoa === 'function') {
    var sourceMapping = toComment(cssMapping);
    var sourceURLs = cssMapping.sources.map(function (source) {
      return "/*# sourceURL=".concat(cssMapping.sourceRoot).concat(source, " */");
    });
    return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
  }

  return [content].join('\n');
} // Adapted from convert-source-map (MIT)


function toComment(sourceMap) {
  // eslint-disable-next-line no-undef
  var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
  var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
  return "/*# ".concat(data, " */");
}

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var stylesInDom = {};

var isOldIE = function isOldIE() {
  var memo;
  return function memorize() {
    if (typeof memo === 'undefined') {
      // Test for IE <= 9 as proposed by Browserhacks
      // @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
      // Tests for existence of standard globals is to allow style-loader
      // to operate correctly into non-standard environments
      // @see https://github.com/webpack-contrib/style-loader/issues/177
      memo = Boolean(window && document && document.all && !window.atob);
    }

    return memo;
  };
}();

var getTarget = function getTarget() {
  var memo = {};
  return function memorize(target) {
    if (typeof memo[target] === 'undefined') {
      var styleTarget = document.querySelector(target); // Special case to return head of iframe instead of iframe itself

      if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
        try {
          // This will throw an exception if access to iframe is blocked
          // due to cross-origin restrictions
          styleTarget = styleTarget.contentDocument.head;
        } catch (e) {
          // istanbul ignore next
          styleTarget = null;
        }
      }

      memo[target] = styleTarget;
    }

    return memo[target];
  };
}();

function listToStyles(list, options) {
  var styles = [];
  var newStyles = {};

  for (var i = 0; i < list.length; i++) {
    var item = list[i];
    var id = options.base ? item[0] + options.base : item[0];
    var css = item[1];
    var media = item[2];
    var sourceMap = item[3];
    var part = {
      css: css,
      media: media,
      sourceMap: sourceMap
    };

    if (!newStyles[id]) {
      styles.push(newStyles[id] = {
        id: id,
        parts: [part]
      });
    } else {
      newStyles[id].parts.push(part);
    }
  }

  return styles;
}

function addStylesToDom(styles, options) {
  for (var i = 0; i < styles.length; i++) {
    var item = styles[i];
    var domStyle = stylesInDom[item.id];
    var j = 0;

    if (domStyle) {
      domStyle.refs++;

      for (; j < domStyle.parts.length; j++) {
        domStyle.parts[j](item.parts[j]);
      }

      for (; j < item.parts.length; j++) {
        domStyle.parts.push(addStyle(item.parts[j], options));
      }
    } else {
      var parts = [];

      for (; j < item.parts.length; j++) {
        parts.push(addStyle(item.parts[j], options));
      }

      stylesInDom[item.id] = {
        id: item.id,
        refs: 1,
        parts: parts
      };
    }
  }
}

function insertStyleElement(options) {
  var style = document.createElement('style');

  if (typeof options.attributes.nonce === 'undefined') {
    var nonce =  true ? __webpack_require__.nc : undefined;

    if (nonce) {
      options.attributes.nonce = nonce;
    }
  }

  Object.keys(options.attributes).forEach(function (key) {
    style.setAttribute(key, options.attributes[key]);
  });

  if (typeof options.insert === 'function') {
    options.insert(style);
  } else {
    var target = getTarget(options.insert || 'head');

    if (!target) {
      throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
    }

    target.appendChild(style);
  }

  return style;
}

function removeStyleElement(style) {
  // istanbul ignore if
  if (style.parentNode === null) {
    return false;
  }

  style.parentNode.removeChild(style);
}
/* istanbul ignore next  */


var replaceText = function replaceText() {
  var textStore = [];
  return function replace(index, replacement) {
    textStore[index] = replacement;
    return textStore.filter(Boolean).join('\n');
  };
}();

function applyToSingletonTag(style, index, remove, obj) {
  var css = remove ? '' : obj.css; // For old IE

  /* istanbul ignore if  */

  if (style.styleSheet) {
    style.styleSheet.cssText = replaceText(index, css);
  } else {
    var cssNode = document.createTextNode(css);
    var childNodes = style.childNodes;

    if (childNodes[index]) {
      style.removeChild(childNodes[index]);
    }

    if (childNodes.length) {
      style.insertBefore(cssNode, childNodes[index]);
    } else {
      style.appendChild(cssNode);
    }
  }
}

function applyToTag(style, options, obj) {
  var css = obj.css;
  var media = obj.media;
  var sourceMap = obj.sourceMap;

  if (media) {
    style.setAttribute('media', media);
  }

  if (sourceMap && btoa) {
    css += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))), " */");
  } // For old IE

  /* istanbul ignore if  */


  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    while (style.firstChild) {
      style.removeChild(style.firstChild);
    }

    style.appendChild(document.createTextNode(css));
  }
}

var singleton = null;
var singletonCounter = 0;

function addStyle(obj, options) {
  var style;
  var update;
  var remove;

  if (options.singleton) {
    var styleIndex = singletonCounter++;
    style = singleton || (singleton = insertStyleElement(options));
    update = applyToSingletonTag.bind(null, style, styleIndex, false);
    remove = applyToSingletonTag.bind(null, style, styleIndex, true);
  } else {
    style = insertStyleElement(options);
    update = applyToTag.bind(null, style, options);

    remove = function remove() {
      removeStyleElement(style);
    };
  }

  update(obj);
  return function updateStyle(newObj) {
    if (newObj) {
      if (newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap) {
        return;
      }

      update(obj = newObj);
    } else {
      remove();
    }
  };
}

module.exports = function (list, options) {
  options = options || {};
  options.attributes = typeof options.attributes === 'object' ? options.attributes : {}; // Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
  // tags it will allow on a page

  if (!options.singleton && typeof options.singleton !== 'boolean') {
    options.singleton = isOldIE();
  }

  var styles = listToStyles(list, options);
  addStylesToDom(styles, options);
  return function update(newList) {
    var mayRemove = [];

    for (var i = 0; i < styles.length; i++) {
      var item = styles[i];
      var domStyle = stylesInDom[item.id];

      if (domStyle) {
        domStyle.refs--;
        mayRemove.push(domStyle);
      }
    }

    if (newList) {
      var newStyles = listToStyles(newList, options);
      addStylesToDom(newStyles, options);
    }

    for (var _i = 0; _i < mayRemove.length; _i++) {
      var _domStyle = mayRemove[_i];

      if (_domStyle.refs === 0) {
        for (var j = 0; j < _domStyle.parts.length; j++) {
          _domStyle.parts[j]();
        }

        delete stylesInDom[_domStyle.id];
      }
    }
  };
};

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

var content = __webpack_require__(18);

if (typeof content === 'string') {
  content = [[module.i, content, '']];
}

var options = {}

options.insert = "head";
options.singleton = false;

var update = __webpack_require__(16)(content, options);

if (content.locals) {
  module.exports = content.locals;
}


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(15)(false);
// Module
exports.push([module.i, "body.rtl {\n  direction: rtl; }\n", ""]);


/***/ })
/******/ ]);